/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.pricing.internal.dto.v2_0.converter;

import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.currency.service.CommerceCurrencyService;
import com.liferay.commerce.currency.util.CommercePriceFormatter;
import com.liferay.commerce.discount.model.CommerceDiscount;
import com.liferay.commerce.discount.service.CommerceDiscountService;
import com.liferay.commerce.percentage.PercentageFormatter;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.headless.commerce.admin.pricing.dto.v2_0.Discount;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import java.math.BigDecimal;
import java.util.Locale;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, property={"model.class.name=com.liferay.commerce.discount.model.CommerceDiscount"}, service={DiscountDTOConverter.class, DTOConverter.class})
public class DiscountDTOConverter
implements DTOConverter<CommerceDiscount, Discount> {
    @Reference
    private CommerceCurrencyService _commerceCurrencyService;
    @Reference
    private CommerceDiscountService _commerceDiscountService;
    @Reference
    private CommercePriceFormatter _commercePriceFormatter;
    @Reference
    private PercentageFormatter _percentageFormatter;

    public String getContentType() {
        return Discount.class.getSimpleName();
    }

    public Discount toDTO(final DTOConverterContext dtoConverterContext) throws Exception {
        final CommerceDiscount commerceDiscount = this._commerceDiscountService.getCommerceDiscount(((Long)dtoConverterContext.getId()).longValue());
        final ExpandoBridge expandoBridge = commerceDiscount.getExpandoBridge();
        final Locale locale = dtoConverterContext.getLocale();
        return new Discount(){
            {
                this.actions = dtoConverterContext.getActions();
                this.active = commerceDiscount.isActive();
                this.amountFormatted = DiscountDTOConverter.this._getAmountFormatted(commerceDiscount, locale);
                this.couponCode = commerceDiscount.getCouponCode();
                this.customFields = expandoBridge.getAttributes();
                this.displayDate = commerceDiscount.getDisplayDate();
                this.expirationDate = commerceDiscount.getExpirationDate();
                this.externalReferenceCode = commerceDiscount.getExternalReferenceCode();
                this.id = commerceDiscount.getCommerceDiscountId();
                this.level = commerceDiscount.getLevel();
                this.limitationTimes = commerceDiscount.getLimitationTimes();
                this.limitationTimesPerAccount = commerceDiscount.getLimitationTimesPerAccount();
                this.limitationType = commerceDiscount.getLimitationType();
                this.maximumDiscountAmount = commerceDiscount.getMaximumDiscountAmount();
                this.numberOfUse = commerceDiscount.getNumberOfUse();
                this.percentageLevel1 = commerceDiscount.getLevel1();
                this.percentageLevel2 = commerceDiscount.getLevel2();
                this.percentageLevel3 = commerceDiscount.getLevel3();
                this.percentageLevel4 = commerceDiscount.getLevel4();
                this.rulesConjunction = commerceDiscount.isRulesConjunction();
                this.target = commerceDiscount.getTarget();
                this.title = commerceDiscount.getTitle();
                this.useCouponCode = commerceDiscount.isUseCouponCode();
                this.usePercentage = commerceDiscount.isUsePercentage();
            }
        };
    }

    private BigDecimal _getAmount(CommerceDiscount commerceDiscount) {
        if (Objects.equals(commerceDiscount.getLevel(), "L1")) {
            return commerceDiscount.getLevel1();
        }
        if (Objects.equals(commerceDiscount.getLevel(), "L2")) {
            return commerceDiscount.getLevel2();
        }
        if (Objects.equals(commerceDiscount.getLevel(), "L3")) {
            return commerceDiscount.getLevel3();
        }
        if (Objects.equals(commerceDiscount.getLevel(), "L4")) {
            return commerceDiscount.getLevel4();
        }
        return BigDecimal.ZERO;
    }

    private String _getAmountFormatted(CommerceDiscount commerceDiscount, Locale locale) throws Exception {
        BigDecimal amount = this._getAmount(commerceDiscount);
        if (amount == null) {
            amount = BigDecimal.ZERO;
        }
        CommerceCurrency commerceCurrency = this._commerceCurrencyService.fetchPrimaryCommerceCurrency(commerceDiscount.getCompanyId());
        if (commerceDiscount.isUsePercentage()) {
            return this._percentageFormatter.getLocalizedPercentage(locale, commerceCurrency.getMaxFractionDigits(), commerceCurrency.getMinFractionDigits(), amount);
        }
        return this._commercePriceFormatter.format(commerceCurrency, amount, locale);
    }
}

