/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.pricing.internal.dto.v1_0.converter;

import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.price.list.model.CommercePriceList;
import com.liferay.commerce.price.list.service.CommercePriceListService;
import com.liferay.commerce.product.model.CommerceCatalog;
import com.liferay.commerce.product.service.CommerceCatalogService;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.headless.commerce.admin.pricing.dto.v1_0.PriceList;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, property={"model.class.name=com.liferay.commerce.price.list.model.CommercePriceList"}, service={DTOConverter.class, PriceListDTOConverter.class})
public class PriceListDTOConverter
implements DTOConverter<CommercePriceList, PriceList> {
    @Reference
    private CommerceCatalogService _commerceCatalogService;
    @Reference
    private CommercePriceListService _commercePriceListService;

    public String getContentType() {
        return PriceList.class.getSimpleName();
    }

    public PriceList toDTO(DTOConverterContext dtoConverterContext) throws Exception {
        final CommercePriceList commercePriceList = this._commercePriceListService.getCommercePriceList(((Long)dtoConverterContext.getId()).longValue());
        final CommerceCurrency commerceCurrency = commercePriceList.getCommerceCurrency();
        final ExpandoBridge expandoBridge = commercePriceList.getExpandoBridge();
        return new PriceList(){
            {
                this.active = !commercePriceList.isInactive();
                this.catalogId = PriceListDTOConverter.this._getCatalogId(commercePriceList);
                this.currencyCode = commerceCurrency.getCode();
                this.customFields = expandoBridge.getAttributes();
                this.displayDate = commercePriceList.getDisplayDate();
                this.expirationDate = commercePriceList.getExpirationDate();
                this.externalReferenceCode = commercePriceList.getExternalReferenceCode();
                this.id = commercePriceList.getCommercePriceListId();
                this.name = commercePriceList.getName();
                this.priority = commercePriceList.getPriority();
            }
        };
    }

    private long _getCatalogId(CommercePriceList commercePriceList) throws Exception {
        CommerceCatalog commerceCatalog = this._commerceCatalogService.fetchCommerceCatalogByGroupId(commercePriceList.getGroupId());
        if (commerceCatalog == null) {
            return 0L;
        }
        return commerceCatalog.getCommerceCatalogId();
    }
}

