/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.order.internal.resource.v1_0;

import com.liferay.commerce.model.CommerceOrderType;
import com.liferay.commerce.service.CommerceOrderTypeService;
import com.liferay.commerce.term.exception.NoSuchTermEntryException;
import com.liferay.commerce.term.model.CommerceTermEntry;
import com.liferay.commerce.term.model.CommerceTermEntryRel;
import com.liferay.commerce.term.service.CommerceTermEntryRelService;
import com.liferay.commerce.term.service.CommerceTermEntryService;
import com.liferay.headless.commerce.admin.order.dto.v1_0.Term;
import com.liferay.headless.commerce.admin.order.dto.v1_0.TermOrderType;
import com.liferay.headless.commerce.admin.order.internal.dto.v1_0.converter.TermDTOConverter;
import com.liferay.headless.commerce.admin.order.internal.odata.entity.v1_0.TermEntityModel;
import com.liferay.headless.commerce.admin.order.internal.resource.v1_0.BaseTermResourceImpl;
import com.liferay.headless.commerce.admin.order.internal.util.v1_0.TermOrderTypeUtil;
import com.liferay.headless.commerce.admin.order.resource.v1_0.TermResource;
import com.liferay.headless.commerce.core.util.DateConfig;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.SearchUtil;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import javax.ws.rs.core.MultivaluedMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/term.properties"}, scope=ServiceScope.PROTOTYPE, service={TermResource.class})
public class TermResourceImpl
extends BaseTermResourceImpl {
    private static final EntityModel _entityModel = new TermEntityModel();
    @Reference
    private CommerceOrderTypeService _commerceOrderTypeService;
    @Reference(target="(model.class.name=com.liferay.commerce.term.model.CommerceTermEntry)")
    private ModelResourcePermission<CommerceTermEntry> _commerceTermEntryModelResourcePermission;
    @Reference
    private CommerceTermEntryRelService _commerceTermEntryRelService;
    @Reference
    private CommerceTermEntryService _commerceTermEntryService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private ServiceContextHelper _serviceContextHelper;
    @Reference
    private TermDTOConverter _termDTOConverter;

    @Override
    public void deleteTerm(Long id) throws Exception {
        this._commerceTermEntryService.deleteCommerceTermEntry(id.longValue());
    }

    @Override
    public void deleteTermByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CommerceTermEntry commerceTermEntry = this._commerceTermEntryService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceTermEntry == null) {
            throw new NoSuchTermEntryException("Unable to find term with external reference code " + externalReferenceCode);
        }
        this._commerceTermEntryService.deleteCommerceTermEntry(commerceTermEntry.getCommerceTermEntryId());
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return _entityModel;
    }

    @Override
    public Term getTerm(Long id) throws Exception {
        return this._toTerm(GetterUtil.getLong((Object)id));
    }

    @Override
    public Term getTermByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CommerceTermEntry commerceTermEntry = this._commerceTermEntryService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceTermEntry == null) {
            throw new NoSuchTermEntryException("Unable to find term with external reference code " + externalReferenceCode);
        }
        return this._toTerm(commerceTermEntry.getCommerceTermEntryId());
    }

    @Override
    public Page<Term> getTermsPage(String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return SearchUtil.search(null, booleanQuery -> booleanQuery.getPreBooleanFilter(), (Filter)filter, (String)CommerceTermEntry.class.getName(), (String)search, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> {
            searchContext.setAttribute("status", (Serializable)Integer.valueOf(-1));
            searchContext.setCompanyId(this.contextCompany.getCompanyId());
        }, (Sort[])sorts, document -> this._toTerm(GetterUtil.getLong((String)document.get("entryClassPK"))));
    }

    @Override
    public Term patchTerm(Long id, Term term) throws Exception {
        return this._toTerm(this._updateTerm(this._commerceTermEntryService.getCommerceTermEntry(id.longValue()), term));
    }

    @Override
    public Term patchTermByExternalReferenceCode(String externalReferenceCode, Term term) throws Exception {
        CommerceTermEntry commerceTermEntry = this._commerceTermEntryService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceTermEntry == null) {
            throw new NoSuchTermEntryException("Unable to find term with external reference code " + externalReferenceCode);
        }
        return this._toTerm(this._updateTerm(commerceTermEntry, term));
    }

    @Override
    public Term postTerm(Term term) throws Exception {
        CommerceTermEntry commerceTermEntry = this._addCommerceTermEntry(term);
        return this._toTerm(commerceTermEntry.getCommerceTermEntryId());
    }

    private CommerceTermEntry _addCommerceTermEntry(Term term) throws Exception {
        ServiceContext serviceContext = this._serviceContextHelper.getServiceContext();
        DateConfig displayDateConfig = DateConfig.toDisplayDateConfig((Date)term.getDisplayDate(), (TimeZone)serviceContext.getTimeZone());
        DateConfig expirationDateConfig = DateConfig.toExpirationDateConfig((Date)term.getExpirationDate(), (TimeZone)serviceContext.getTimeZone());
        CommerceTermEntry commerceTermEntry = this._commerceTermEntryService.addCommerceTermEntry(term.getExternalReferenceCode(), GetterUtil.getBoolean((Object)term.getActive()), LanguageUtils.getLocalizedMap((Map)term.getDescription()), displayDateConfig.getMonth(), displayDateConfig.getDay(), displayDateConfig.getYear(), displayDateConfig.getHour(), displayDateConfig.getMinute(), expirationDateConfig.getMonth(), expirationDateConfig.getDay(), expirationDateConfig.getYear(), expirationDateConfig.getHour(), expirationDateConfig.getMinute(), GetterUtil.getBoolean((Object)term.getNeverExpire(), (boolean)true), LanguageUtils.getLocalizedMap((Map)term.getLabel()), term.getName(), GetterUtil.getDouble((Object)term.getPriority()), term.getType(), term.getTypeSettings(), serviceContext);
        return this._updateNestedResources(commerceTermEntry, term);
    }

    private Map<String, Map<String, String>> _getActions(CommerceTermEntry commerceTermEntry) throws Exception {
        return HashMapBuilder.put((Object)"delete", this.addAction("DELETE", commerceTermEntry.getCommerceTermEntryId(), "deleteTerm", this._commerceTermEntryModelResourcePermission)).put((Object)"get", this.addAction("VIEW", commerceTermEntry.getCommerceTermEntryId(), "getTerm", this._commerceTermEntryModelResourcePermission)).put((Object)"permissions", this.addAction("PERMISSIONS", commerceTermEntry.getCommerceTermEntryId(), "patchTerm", this._commerceTermEntryModelResourcePermission)).put((Object)"update", this.addAction("UPDATE", commerceTermEntry.getCommerceTermEntryId(), "patchTerm", this._commerceTermEntryModelResourcePermission)).build();
    }

    private Term _toTerm(CommerceTermEntry commerceTermEntry) throws Exception {
        return this._toTerm(commerceTermEntry.getCommerceTermEntryId());
    }

    private Term _toTerm(Long commerceTermEntryId) throws Exception {
        CommerceTermEntry commerceTermEntry = this._commerceTermEntryService.getCommerceTermEntry(commerceTermEntryId.longValue());
        return this._termDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), this._getActions(commerceTermEntry), this._dtoConverterRegistry, (Object)commerceTermEntryId, this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser));
    }

    private CommerceTermEntry _updateNestedResources(CommerceTermEntry commerceTermEntry, Term term) throws Exception {
        TermOrderType[] termOrderTypes = term.getTermOrderType();
        if (termOrderTypes != null) {
            for (TermOrderType termOrderType : termOrderTypes) {
                CommerceTermEntryRel commerceTermEntryRel = this._commerceTermEntryRelService.fetchCommerceTermEntryRel(CommerceOrderType.class.getName(), termOrderType.getTermId().longValue(), commerceTermEntry.getCommerceTermEntryId());
                if (commerceTermEntryRel != null) continue;
                TermOrderTypeUtil.addCommerceTermEntryCommerceOrderTypeRel(this._commerceOrderTypeService, commerceTermEntry, this._commerceTermEntryRelService, termOrderType);
            }
        }
        return commerceTermEntry;
    }

    private CommerceTermEntry _updateTerm(CommerceTermEntry commerceTermEntry, Term term) throws Exception {
        Map descriptionMap = term.getDescription();
        if (commerceTermEntry != null && descriptionMap == null) {
            descriptionMap = commerceTermEntry.getLanguageIdToDescriptionMap();
        }
        ServiceContext serviceContext = this._serviceContextHelper.getServiceContext();
        DateConfig displayDateConfig = DateConfig.toDisplayDateConfig((Date)term.getDisplayDate(), (TimeZone)serviceContext.getTimeZone());
        DateConfig expirationDateConfig = DateConfig.toExpirationDateConfig((Date)term.getExpirationDate(), (TimeZone)serviceContext.getTimeZone());
        Map labelMap = term.getLabel();
        if (commerceTermEntry != null && descriptionMap == null) {
            labelMap = commerceTermEntry.getLanguageIdToLabelMap();
        }
        commerceTermEntry = this._commerceTermEntryService.updateCommerceTermEntry(commerceTermEntry.getCommerceTermEntryId(), GetterUtil.getBoolean((Object)term.getActive(), (boolean)commerceTermEntry.isActive()), LanguageUtils.getLocalizedMap((Map)descriptionMap), displayDateConfig.getMonth(), displayDateConfig.getDay(), displayDateConfig.getYear(), displayDateConfig.getHour(), displayDateConfig.getMinute(), expirationDateConfig.getMonth(), expirationDateConfig.getDay(), expirationDateConfig.getYear(), expirationDateConfig.getHour(), expirationDateConfig.getMinute(), GetterUtil.getBoolean((Object)term.getNeverExpire(), (boolean)true), LanguageUtils.getLocalizedMap((Map)labelMap), GetterUtil.getString((String)term.getName(), (String)commerceTermEntry.getName()), GetterUtil.getDouble((Object)term.getPriority(), (double)commerceTermEntry.getPriority()), GetterUtil.get((String)term.getTypeSettings(), (String)commerceTermEntry.getTypeSettings()), serviceContext);
        return this._updateNestedResources(commerceTermEntry, term);
    }
}

