/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.order.internal.resource.v1_0;

import com.liferay.commerce.model.CommerceOrderType;
import com.liferay.commerce.service.CommerceOrderTypeService;
import com.liferay.commerce.term.exception.NoSuchTermEntryException;
import com.liferay.commerce.term.model.CommerceTermEntry;
import com.liferay.commerce.term.model.CommerceTermEntryRel;
import com.liferay.commerce.term.service.CommerceTermEntryRelService;
import com.liferay.commerce.term.service.CommerceTermEntryService;
import com.liferay.headless.commerce.admin.order.dto.v1_0.Term;
import com.liferay.headless.commerce.admin.order.dto.v1_0.TermOrderType;
import com.liferay.headless.commerce.admin.order.internal.dto.v1_0.converter.TermOrderTypeDTOConverter;
import com.liferay.headless.commerce.admin.order.internal.resource.v1_0.BaseTermOrderTypeResourceImpl;
import com.liferay.headless.commerce.admin.order.resource.v1_0.TermOrderTypeResource;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.fields.NestedFieldSupport;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/term-order-type.properties"}, scope=ServiceScope.PROTOTYPE, service={NestedFieldSupport.class, TermOrderTypeResource.class})
public class TermOrderTypeResourceImpl
extends BaseTermOrderTypeResourceImpl
implements NestedFieldSupport {
    @Reference
    private CommerceOrderTypeService _commerceOrderTypeService;
    @Reference(target="(model.class.name=com.liferay.commerce.term.model.CommerceTermEntryRel)")
    private ModelResourcePermission<CommerceTermEntryRel> _commerceTermEntryRelModelResourcePermission;
    @Reference
    private CommerceTermEntryRelService _commerceTermEntryRelService;
    @Reference
    private CommerceTermEntryService _commerceTermEntryService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private TermOrderTypeDTOConverter _termOrderTypeDTOConverter;

    @Override
    public void deleteTermOrderType(Long id) throws Exception {
        this._commerceTermEntryRelService.deleteCommerceTermEntryRel(id.longValue());
    }

    @Override
    public Page<TermOrderType> getTermByExternalReferenceCodeTermOrderTypesPage(String externalReferenceCode, Pagination pagination) throws Exception {
        CommerceTermEntry commerceTermEntry = this._commerceTermEntryService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceTermEntry == null) {
            throw new NoSuchTermEntryException("Unable to find term with external reference code " + externalReferenceCode);
        }
        return Page.of(this.transform(this._commerceTermEntryRelService.getCommerceOrderTypeCommerceTermEntryRels(commerceTermEntry.getCommerceTermEntryId(), null, pagination.getStartPosition(), pagination.getEndPosition()), commerceTermEntryRel -> this._toTermOrderType((CommerceTermEntryRel)commerceTermEntryRel)), (Pagination)pagination, (long)this._commerceTermEntryRelService.getCommerceOrderTypeCommerceTermEntryRelsCount(commerceTermEntry.getCommerceTermEntryId(), null));
    }

    @Override
    @NestedField(parentClass=Term.class, value="termOrderTypes")
    public Page<TermOrderType> getTermIdTermOrderTypesPage(Long id, String search, Pagination pagination) throws Exception {
        CommerceTermEntry commerceTermEntry = this._commerceTermEntryService.fetchCommerceTermEntry(id.longValue());
        if (commerceTermEntry == null) {
            throw new NoSuchTermEntryException("Unable to find term with ID " + id);
        }
        return Page.of(this.transform(this._commerceTermEntryRelService.getCommerceOrderTypeCommerceTermEntryRels(id.longValue(), search, pagination.getStartPosition(), pagination.getEndPosition()), commerceTermEntryRel -> this._toTermOrderType((CommerceTermEntryRel)commerceTermEntryRel)), (Pagination)pagination, (long)this._commerceTermEntryRelService.getCommerceOrderTypeCommerceTermEntryRelsCount(id.longValue(), search));
    }

    @Override
    public TermOrderType postTermByExternalReferenceCodeTermOrderType(String externalReferenceCode, TermOrderType termOrderType) throws Exception {
        CommerceTermEntry commerceTermEntry = this._commerceTermEntryService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceTermEntry == null) {
            throw new NoSuchTermEntryException("Unable to find term with external reference code " + externalReferenceCode);
        }
        CommerceOrderType commerceOrderType = this._getCommerceOrderType(termOrderType);
        return this._toTermOrderType(this._commerceTermEntryRelService.addCommerceTermEntryRel(CommerceOrderType.class.getName(), commerceOrderType.getCommerceOrderTypeId(), commerceTermEntry.getCommerceTermEntryId()));
    }

    @Override
    public TermOrderType postTermIdTermOrderType(Long id, TermOrderType termOrderType) throws Exception {
        CommerceOrderType commerceOrderType = this._getCommerceOrderType(termOrderType);
        return this._toTermOrderType(this._commerceTermEntryRelService.addCommerceTermEntryRel(CommerceOrderType.class.getName(), commerceOrderType.getCommerceOrderTypeId(), id.longValue()));
    }

    private Map<String, Map<String, String>> _getActions(CommerceTermEntryRel commerceTermEntryRel) throws Exception {
        return HashMapBuilder.put((Object)"delete", this.addAction("UPDATE", commerceTermEntryRel.getCommerceTermEntryRelId(), "deleteTermOrderType", this._commerceTermEntryRelModelResourcePermission)).build();
    }

    private CommerceOrderType _getCommerceOrderType(TermOrderType termOrderType) throws Exception {
        CommerceOrderType commerceOrderType = null;
        commerceOrderType = termOrderType.getOrderTypeId() > 0L ? this._commerceOrderTypeService.getCommerceOrderType(termOrderType.getOrderTypeId().longValue()) : this._commerceOrderTypeService.fetchByExternalReferenceCode(termOrderType.getOrderTypeExternalReferenceCode(), this.contextCompany.getCompanyId());
        return commerceOrderType;
    }

    private TermOrderType _toTermOrderType(CommerceTermEntryRel commerceTermEntryRel) throws Exception {
        return this._termOrderTypeDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), this._getActions(commerceTermEntryRel), this._dtoConverterRegistry, (Object)commerceTermEntryRel.getCommerceTermEntryRelId(), this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser));
    }
}

