/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.order.internal.resource.v1_0;

import com.liferay.commerce.exception.NoSuchOrderException;
import com.liferay.commerce.model.CommerceAddress;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.service.CommerceAddressService;
import com.liferay.commerce.service.CommerceOrderItemService;
import com.liferay.commerce.service.CommerceOrderService;
import com.liferay.headless.commerce.admin.order.dto.v1_0.Order;
import com.liferay.headless.commerce.admin.order.dto.v1_0.OrderItem;
import com.liferay.headless.commerce.admin.order.dto.v1_0.ShippingAddress;
import com.liferay.headless.commerce.admin.order.internal.dto.v1_0.converter.ShippingAddressDTOConverter;
import com.liferay.headless.commerce.admin.order.internal.resource.v1_0.BaseShippingAddressResourceImpl;
import com.liferay.headless.commerce.admin.order.internal.util.v1_0.ShippingAddressUtil;
import com.liferay.headless.commerce.admin.order.resource.v1_0.ShippingAddressResource;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.fields.NestedFieldSupport;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/shipping-address.properties"}, scope=ServiceScope.PROTOTYPE, service={NestedFieldSupport.class, ShippingAddressResource.class})
public class ShippingAddressResourceImpl
extends BaseShippingAddressResourceImpl
implements NestedFieldSupport {
    @Reference
    private CommerceAddressService _commerceAddressService;
    @Reference
    private CommerceOrderItemService _commerceOrderItemService;
    @Reference
    private CommerceOrderService _commerceOrderService;
    @Reference
    private ServiceContextHelper _serviceContextHelper;
    @Reference
    private ShippingAddressDTOConverter _shippingAddressDTOConverter;

    @Override
    public ShippingAddress getOrderByExternalReferenceCodeShippingAddress(String externalReferenceCode) throws Exception {
        CommerceOrder commerceOrder = this._commerceOrderService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commerceOrder == null) {
            throw new NoSuchOrderException("Unable to find order with external reference code " + externalReferenceCode);
        }
        CommerceAddress commerceAddress = this._commerceAddressService.getCommerceAddress(commerceOrder.getShippingAddressId());
        return this._shippingAddressDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)commerceAddress.getCommerceAddressId(), this.contextAcceptLanguage.getPreferredLocale()));
    }

    @Override
    @NestedField(parentClass=Order.class, value="shippingAddress")
    public ShippingAddress getOrderIdShippingAddress(Long id) throws Exception {
        CommerceOrder commerceOrder = this._commerceOrderService.getCommerceOrder(id.longValue());
        CommerceAddress commerceAddress = this._commerceAddressService.fetchCommerceAddress(commerceOrder.getShippingAddressId());
        if (commerceAddress == null) {
            return new ShippingAddress();
        }
        return this._shippingAddressDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)commerceAddress.getCommerceAddressId(), this.contextAcceptLanguage.getPreferredLocale()));
    }

    @Override
    @NestedField(parentClass=OrderItem.class, value="shippingAddress")
    public ShippingAddress getOrderItemShippingAddress(Long id) throws Exception {
        CommerceOrderItem commerceOrderItem = this._commerceOrderItemService.getCommerceOrderItem(id.longValue());
        if (commerceOrderItem.getShippingAddressId() == 0L) {
            return new ShippingAddress();
        }
        return this._shippingAddressDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)commerceOrderItem.getShippingAddressId(), this.contextAcceptLanguage.getPreferredLocale()));
    }

    @Override
    public Response patchOrderByExternalReferenceCodeShippingAddress(String externalReferenceCode, ShippingAddress shippingAddress) throws Exception {
        CommerceOrder commerceOrder = this._commerceOrderService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commerceOrder == null) {
            throw new NoSuchOrderException("Unable to find order with external reference code " + externalReferenceCode);
        }
        ShippingAddressUtil.addOrUpdateShippingAddress(this._commerceAddressService, this._commerceOrderService, commerceOrder, shippingAddress, this._serviceContextHelper.getServiceContext());
        Response.ResponseBuilder responseBuilder = Response.noContent();
        return responseBuilder.build();
    }

    @Override
    public Response patchOrderIdShippingAddress(Long id, ShippingAddress shippingAddress) throws Exception {
        ShippingAddressUtil.addOrUpdateShippingAddress(this._commerceAddressService, this._commerceOrderService, this._commerceOrderService.getCommerceOrder(id.longValue()), shippingAddress, this._serviceContextHelper.getServiceContext());
        Response.ResponseBuilder responseBuilder = Response.noContent();
        return responseBuilder.build();
    }
}

