/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.order.internal.resource.v1_0;

import com.liferay.commerce.exception.NoSuchOrderTypeException;
import com.liferay.commerce.model.CommerceOrderType;
import com.liferay.commerce.order.rule.model.COREntryRel;
import com.liferay.commerce.order.rule.service.COREntryRelService;
import com.liferay.commerce.service.CommerceOrderTypeService;
import com.liferay.commerce.term.model.CommerceTermEntryRel;
import com.liferay.commerce.term.service.CommerceTermEntryRelService;
import com.liferay.headless.commerce.admin.order.dto.v1_0.OrderRuleOrderType;
import com.liferay.headless.commerce.admin.order.dto.v1_0.OrderType;
import com.liferay.headless.commerce.admin.order.dto.v1_0.TermOrderType;
import com.liferay.headless.commerce.admin.order.internal.dto.v1_0.converter.OrderTypeDTOConverter;
import com.liferay.headless.commerce.admin.order.internal.odata.entity.v1_0.OrderTypeEntityModel;
import com.liferay.headless.commerce.admin.order.internal.resource.v1_0.BaseOrderTypeResourceImpl;
import com.liferay.headless.commerce.admin.order.resource.v1_0.OrderTypeResource;
import com.liferay.headless.commerce.core.util.DateConfig;
import com.liferay.headless.commerce.core.util.ExpandoUtil;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.fields.NestedFieldSupport;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.SearchUtil;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import javax.ws.rs.core.MultivaluedMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/order-type.properties"}, scope=ServiceScope.PROTOTYPE, service={NestedFieldSupport.class, OrderTypeResource.class})
public class OrderTypeResourceImpl
extends BaseOrderTypeResourceImpl
implements NestedFieldSupport {
    private static final EntityModel _entityModel = new OrderTypeEntityModel();
    @Reference(target="(model.class.name=com.liferay.commerce.model.CommerceOrderType)")
    private ModelResourcePermission<CommerceOrderType> _commerceOrderTypeModelResourcePermission;
    @Reference
    private CommerceOrderTypeService _commerceOrderTypeService;
    @Reference
    private CommerceTermEntryRelService _commerceTermEntryRelService;
    @Reference
    private COREntryRelService _corEntryRelService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private OrderTypeDTOConverter _orderTypeDTOConverter;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    @Override
    public void deleteOrderType(Long id) throws Exception {
        this._commerceOrderTypeService.deleteCommerceOrderType(id.longValue());
    }

    @Override
    public void deleteOrderTypeByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CommerceOrderType commerceOrderType = this._commerceOrderTypeService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commerceOrderType == null) {
            throw new NoSuchOrderTypeException("Unable to find order type with external reference code " + externalReferenceCode);
        }
        this._commerceOrderTypeService.deleteCommerceOrderType(commerceOrderType.getCommerceOrderTypeId());
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return _entityModel;
    }

    @Override
    @NestedField(parentClass=OrderRuleOrderType.class, value="orderType")
    public OrderType getOrderRuleOrderTypeOrderType(Long id) throws Exception {
        COREntryRel corEntryRel = this._corEntryRelService.getCOREntryRel(id.longValue());
        CommerceOrderType commerceOrderType = this._commerceOrderTypeService.getCommerceOrderType(corEntryRel.getClassPK());
        return this._toOrderType(commerceOrderType.getCommerceOrderTypeId());
    }

    @Override
    public OrderType getOrderType(Long id) throws Exception {
        return this._toOrderType(GetterUtil.getLong((Object)id));
    }

    @Override
    public OrderType getOrderTypeByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CommerceOrderType commerceOrderType = this._commerceOrderTypeService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commerceOrderType == null) {
            throw new NoSuchOrderTypeException("Unable to find order type with external reference code " + externalReferenceCode);
        }
        return this._toOrderType(commerceOrderType.getCommerceOrderTypeId());
    }

    @Override
    public Page<OrderType> getOrderTypesPage(String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return SearchUtil.search(null, booleanQuery -> booleanQuery.getPreBooleanFilter(), (Filter)filter, (String)CommerceOrderType.class.getName(), (String)search, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> {
            searchContext.setAttribute("status", (Serializable)Integer.valueOf(-1));
            searchContext.setCompanyId(this.contextCompany.getCompanyId());
        }, (Sort[])sorts, document -> this._toOrderType(GetterUtil.getLong((String)document.get("entryClassPK"))));
    }

    @Override
    @NestedField(parentClass=TermOrderType.class, value="orderType")
    public OrderType getTermOrderTypeOrderType(Long id) throws Exception {
        CommerceTermEntryRel commerceTermEntryRel = this._commerceTermEntryRelService.getCommerceTermEntryRel(id.longValue());
        CommerceOrderType commerceOrderType = this._commerceOrderTypeService.getCommerceOrderType(commerceTermEntryRel.getClassPK());
        return this._toOrderType(commerceOrderType.getCommerceOrderTypeId());
    }

    @Override
    public OrderType patchOrderType(Long id, OrderType orderType) throws Exception {
        return this._toOrderType(this._updateOrderType(this._commerceOrderTypeService.getCommerceOrderType(id.longValue()), orderType));
    }

    @Override
    public OrderType patchOrderTypeByExternalReferenceCode(String externalReferenceCode, OrderType orderType) throws Exception {
        CommerceOrderType commerceOrderType = this._commerceOrderTypeService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commerceOrderType == null) {
            throw new NoSuchOrderTypeException("Unable to find order type with external reference code " + externalReferenceCode);
        }
        return this._toOrderType(this._updateOrderType(commerceOrderType, orderType));
    }

    @Override
    public OrderType postOrderType(OrderType orderType) throws Exception {
        CommerceOrderType commerceOrderType = this._addCommerceOrderType(orderType);
        return this._toOrderType(commerceOrderType.getCommerceOrderTypeId());
    }

    private CommerceOrderType _addCommerceOrderType(OrderType orderType) throws Exception {
        ServiceContext serviceContext = this._serviceContextHelper.getServiceContext();
        DateConfig displayDateConfig = DateConfig.toDisplayDateConfig((Date)orderType.getDisplayDate(), (TimeZone)serviceContext.getTimeZone());
        DateConfig expirationDateConfig = DateConfig.toExpirationDateConfig((Date)orderType.getExpirationDate(), (TimeZone)serviceContext.getTimeZone());
        return this._commerceOrderTypeService.addCommerceOrderType(orderType.getExternalReferenceCode(), LanguageUtils.getLocalizedMap((Map)orderType.getName()), LanguageUtils.getLocalizedMap((Map)orderType.getDescription()), GetterUtil.getBoolean((Object)orderType.getActive()), displayDateConfig.getMonth(), displayDateConfig.getDay(), displayDateConfig.getYear(), displayDateConfig.getHour(), displayDateConfig.getMinute(), GetterUtil.getInteger((Object)orderType.getDisplayOrder()), expirationDateConfig.getMonth(), expirationDateConfig.getDay(), expirationDateConfig.getYear(), expirationDateConfig.getHour(), expirationDateConfig.getMinute(), GetterUtil.getBoolean((Object)orderType.getNeverExpire(), (boolean)true), serviceContext);
    }

    private Map<String, Map<String, String>> _getActions(CommerceOrderType commerceOrderType) throws Exception {
        return HashMapBuilder.put((Object)"delete", this.addAction("DELETE", commerceOrderType.getCommerceOrderTypeId(), "deleteOrderType", this._commerceOrderTypeModelResourcePermission)).put((Object)"get", this.addAction("VIEW", commerceOrderType.getCommerceOrderTypeId(), "getOrderType", this._commerceOrderTypeModelResourcePermission)).put((Object)"permissions", this.addAction("PERMISSIONS", commerceOrderType.getCommerceOrderTypeId(), "patchOrderType", this._commerceOrderTypeModelResourcePermission)).put((Object)"update", this.addAction("UPDATE", commerceOrderType.getCommerceOrderTypeId(), "patchOrderType", this._commerceOrderTypeModelResourcePermission)).build();
    }

    private OrderType _toOrderType(CommerceOrderType commerceOrderType) throws Exception {
        return this._toOrderType(commerceOrderType.getCommerceOrderTypeId());
    }

    private OrderType _toOrderType(Long commerceOrderTypeId) throws Exception {
        CommerceOrderType commerceOrderType = this._commerceOrderTypeService.getCommerceOrderType(commerceOrderTypeId.longValue());
        return this._orderTypeDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), this._getActions(commerceOrderType), this._dtoConverterRegistry, (Object)commerceOrderTypeId, this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser));
    }

    private CommerceOrderType _updateOrderType(CommerceOrderType commerceOrderType, OrderType orderType) throws Exception {
        ServiceContext serviceContext = this._serviceContextHelper.getServiceContext();
        DateConfig displayDateConfig = DateConfig.toDisplayDateConfig((Date)orderType.getDisplayDate(), (TimeZone)serviceContext.getTimeZone());
        DateConfig expirationDateConfig = DateConfig.toExpirationDateConfig((Date)orderType.getExpirationDate(), (TimeZone)serviceContext.getTimeZone());
        commerceOrderType = this._commerceOrderTypeService.updateCommerceOrderType(GetterUtil.getString((String)orderType.getExternalReferenceCode(), (String)commerceOrderType.getExternalReferenceCode()), commerceOrderType.getCommerceOrderTypeId(), LanguageUtils.getLocalizedMap((Map)orderType.getName()), LanguageUtils.getLocalizedMap((Map)orderType.getDescription()), GetterUtil.get((Object)orderType.getActive(), (boolean)commerceOrderType.isActive()), displayDateConfig.getMonth(), displayDateConfig.getDay(), displayDateConfig.getYear(), displayDateConfig.getHour(), displayDateConfig.getMinute(), GetterUtil.getInteger((Object)orderType.getDisplayOrder(), (int)commerceOrderType.getDisplayOrder()), expirationDateConfig.getMonth(), expirationDateConfig.getDay(), expirationDateConfig.getYear(), expirationDateConfig.getHour(), expirationDateConfig.getMinute(), GetterUtil.getBoolean((Object)orderType.getNeverExpire(), (boolean)true), serviceContext);
        Map customFields = orderType.getCustomFields();
        if (customFields != null && !customFields.isEmpty()) {
            ExpandoUtil.updateExpando((long)serviceContext.getCompanyId(), CommerceOrderType.class, (long)commerceOrderType.getPrimaryKey(), (Map)customFields);
        }
        return commerceOrderType;
    }
}

