/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.order.internal.resource.v1_0;

import com.liferay.account.model.AccountEntry;
import com.liferay.account.model.AccountGroup;
import com.liferay.commerce.account.service.CommerceAccountGroupService;
import com.liferay.commerce.account.service.CommerceAccountService;
import com.liferay.commerce.model.CommerceOrderType;
import com.liferay.commerce.order.rule.exception.NoSuchCOREntryException;
import com.liferay.commerce.order.rule.model.COREntry;
import com.liferay.commerce.order.rule.model.COREntryRel;
import com.liferay.commerce.order.rule.service.COREntryRelService;
import com.liferay.commerce.order.rule.service.COREntryService;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CommerceChannelService;
import com.liferay.commerce.service.CommerceOrderTypeService;
import com.liferay.headless.commerce.admin.order.dto.v1_0.OrderRule;
import com.liferay.headless.commerce.admin.order.dto.v1_0.OrderRuleAccount;
import com.liferay.headless.commerce.admin.order.dto.v1_0.OrderRuleAccountGroup;
import com.liferay.headless.commerce.admin.order.dto.v1_0.OrderRuleChannel;
import com.liferay.headless.commerce.admin.order.dto.v1_0.OrderRuleOrderType;
import com.liferay.headless.commerce.admin.order.internal.dto.v1_0.converter.OrderRuleDTOConverter;
import com.liferay.headless.commerce.admin.order.internal.odata.entity.v1_0.OrderRuleEntityModel;
import com.liferay.headless.commerce.admin.order.internal.resource.v1_0.BaseOrderRuleResourceImpl;
import com.liferay.headless.commerce.admin.order.internal.util.v1_0.OrderRuleAccountGroupUtil;
import com.liferay.headless.commerce.admin.order.internal.util.v1_0.OrderRuleAccountUtil;
import com.liferay.headless.commerce.admin.order.internal.util.v1_0.OrderRuleChannelUtil;
import com.liferay.headless.commerce.admin.order.internal.util.v1_0.OrderRuleOrderTypeUtil;
import com.liferay.headless.commerce.admin.order.resource.v1_0.OrderRuleResource;
import com.liferay.headless.commerce.core.util.DateConfig;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.SearchUtil;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import javax.ws.rs.core.MultivaluedMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/order-rule.properties"}, scope=ServiceScope.PROTOTYPE, service={OrderRuleResource.class})
public class OrderRuleResourceImpl
extends BaseOrderRuleResourceImpl {
    private static final EntityModel _entityModel = new OrderRuleEntityModel();
    @Reference
    private CommerceAccountGroupService _commerceAccountGroupService;
    @Reference
    private CommerceAccountService _commerceAccountService;
    @Reference
    private CommerceChannelService _commerceChannelService;
    @Reference
    private CommerceOrderTypeService _commerceOrderTypeService;
    @Reference(target="(model.class.name=com.liferay.commerce.order.rule.model.COREntry)")
    private ModelResourcePermission<COREntry> _corEntryModelResourcePermission;
    @Reference
    private COREntryRelService _corEntryRelService;
    @Reference
    private COREntryService _corEntryService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private OrderRuleDTOConverter _orderRuleDTOConverter;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    @Override
    public void deleteOrderRule(Long id) throws Exception {
        this._corEntryService.deleteCOREntry(id.longValue());
    }

    @Override
    public void deleteOrderRuleByExternalReferenceCode(String externalReferenceCode) throws Exception {
        COREntry corEntry = this._corEntryService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (corEntry == null) {
            throw new NoSuchCOREntryException("Unable to find order rule with external reference code " + externalReferenceCode);
        }
        this._corEntryService.deleteCOREntry(corEntry.getCOREntryId());
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return _entityModel;
    }

    @Override
    public OrderRule getOrderRule(Long id) throws Exception {
        return this._toOrderRule(GetterUtil.getLong((Object)id));
    }

    @Override
    public OrderRule getOrderRuleByExternalReferenceCode(String externalReferenceCode) throws Exception {
        COREntry corEntry = this._corEntryService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (corEntry == null) {
            throw new NoSuchCOREntryException("Unable to find order rule with external reference code " + externalReferenceCode);
        }
        return this._toOrderRule(corEntry.getCOREntryId());
    }

    @Override
    public Page<OrderRule> getOrderRulesPage(String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return SearchUtil.search(null, booleanQuery -> booleanQuery.getPreBooleanFilter(), (Filter)filter, (String)COREntry.class.getName(), (String)search, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> {
            searchContext.setAttribute("status", (Serializable)Integer.valueOf(-1));
            searchContext.setCompanyId(this.contextCompany.getCompanyId());
        }, (Sort[])sorts, document -> this._toOrderRule(GetterUtil.getLong((String)document.get("entryClassPK"))));
    }

    @Override
    public OrderRule patchOrderRule(Long id, OrderRule orderRule) throws Exception {
        return this._toOrderRule(this._updateOrderRule(this._corEntryService.getCOREntry(id.longValue()), orderRule));
    }

    @Override
    public OrderRule patchOrderRuleByExternalReferenceCode(String externalReferenceCode, OrderRule orderRule) throws Exception {
        COREntry corEntry = this._corEntryService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (corEntry == null) {
            throw new NoSuchCOREntryException("Unable to find order rule with external reference code " + externalReferenceCode);
        }
        return this._toOrderRule(this._updateOrderRule(corEntry, orderRule));
    }

    @Override
    public OrderRule postOrderRule(OrderRule orderRule) throws Exception {
        COREntry corEntry = this._addCOREntry(orderRule);
        return this._toOrderRule(corEntry.getCOREntryId());
    }

    private COREntry _addCOREntry(OrderRule orderRule) throws Exception {
        ServiceContext serviceContext = this._serviceContextHelper.getServiceContext();
        DateConfig displayDateConfig = DateConfig.toDisplayDateConfig((Date)orderRule.getDisplayDate(), (TimeZone)serviceContext.getTimeZone());
        DateConfig expirationDateConfig = DateConfig.toExpirationDateConfig((Date)orderRule.getExpirationDate(), (TimeZone)serviceContext.getTimeZone());
        COREntry corEntry = this._corEntryService.addCOREntry(orderRule.getExternalReferenceCode(), GetterUtil.getBoolean((Object)orderRule.getActive()), orderRule.getDescription(), displayDateConfig.getMonth(), displayDateConfig.getDay(), displayDateConfig.getYear(), displayDateConfig.getHour(), displayDateConfig.getMinute(), expirationDateConfig.getMonth(), expirationDateConfig.getDay(), expirationDateConfig.getYear(), expirationDateConfig.getHour(), expirationDateConfig.getMinute(), GetterUtil.getBoolean((Object)orderRule.getNeverExpire(), (boolean)true), orderRule.getName(), GetterUtil.getInteger((Object)orderRule.getPriority()), orderRule.getType(), orderRule.getTypeSettings(), serviceContext);
        return this._updateNestedResources(corEntry, orderRule);
    }

    private Map<String, Map<String, String>> _getActions(COREntry corEntry) throws Exception {
        return HashMapBuilder.put((Object)"delete", this.addAction("DELETE", corEntry.getCOREntryId(), "deleteOrderRule", this._corEntryModelResourcePermission)).put((Object)"get", this.addAction("VIEW", corEntry.getCOREntryId(), "getOrderRule", this._corEntryModelResourcePermission)).put((Object)"permissions", this.addAction("PERMISSIONS", corEntry.getCOREntryId(), "patchOrderRule", this._corEntryModelResourcePermission)).put((Object)"update", this.addAction("UPDATE", corEntry.getCOREntryId(), "patchOrderRule", this._corEntryModelResourcePermission)).build();
    }

    private OrderRule _toOrderRule(COREntry corEntry) throws Exception {
        return this._toOrderRule(corEntry.getCOREntryId());
    }

    private OrderRule _toOrderRule(Long corEntryId) throws Exception {
        COREntry corEntry = this._corEntryService.getCOREntry(corEntryId.longValue());
        return this._orderRuleDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), this._getActions(corEntry), this._dtoConverterRegistry, (Object)corEntryId, this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser));
    }

    private COREntry _updateNestedResources(COREntry corEntry, OrderRule orderRule) throws Exception {
        OrderRuleOrderType[] orderRuleOrderTypes;
        OrderRuleChannel[] orderRuleChannels;
        OrderRuleAccount[] orderRuleAccounts;
        OrderRuleAccountGroup[] orderRuleAccountGroups = orderRule.getOrderRuleAccountGroup();
        if (orderRuleAccountGroups != null) {
            for (OrderRuleAccountGroup orderRuleAccountGroup : orderRuleAccountGroups) {
                COREntryRel corEntryRel = this._corEntryRelService.fetchCOREntryRel(AccountGroup.class.getName(), orderRuleAccountGroup.getAccountGroupId().longValue(), corEntry.getCOREntryId());
                if (corEntryRel != null) continue;
                OrderRuleAccountGroupUtil.addCOREntryCommerceAccountGroupRel(this._commerceAccountGroupService, this._corEntryRelService, corEntry, orderRuleAccountGroup);
            }
        }
        if ((orderRuleAccounts = orderRule.getOrderRuleAccount()) != null) {
            for (OrderRuleAccount orderRuleAccount : orderRuleAccounts) {
                COREntryRel corEntryRel = this._corEntryRelService.fetchCOREntryRel(AccountEntry.class.getName(), orderRuleAccount.getAccountId().longValue(), corEntry.getCOREntryId());
                if (corEntryRel != null) continue;
                OrderRuleAccountUtil.addCOREntryCommerceAccountRel(this._commerceAccountService, this._corEntryRelService, corEntry, orderRuleAccount);
            }
        }
        if ((orderRuleChannels = orderRule.getOrderRuleChannel()) != null) {
            for (OrderRuleChannel orderRuleChannel : orderRuleChannels) {
                COREntryRel corEntryRel = this._corEntryRelService.fetchCOREntryRel(CommerceChannel.class.getName(), orderRuleChannel.getChannelId().longValue(), corEntry.getCOREntryId());
                if (corEntryRel != null) continue;
                OrderRuleChannelUtil.addCOREntryCommerceChannelRel(this._commerceChannelService, this._corEntryRelService, corEntry, orderRuleChannel);
            }
        }
        if ((orderRuleOrderTypes = orderRule.getOrderRuleOrderType()) != null) {
            for (OrderRuleOrderType orderRuleOrderType : orderRuleOrderTypes) {
                COREntryRel corEntryRel = this._corEntryRelService.fetchCOREntryRel(CommerceOrderType.class.getName(), orderRuleOrderType.getOrderRuleId().longValue(), corEntry.getCOREntryId());
                if (corEntryRel != null) continue;
                OrderRuleOrderTypeUtil.addCOREntryCommerceOrderTypeRel(this._corEntryRelService, corEntry, this._commerceOrderTypeService, orderRuleOrderType);
            }
        }
        return corEntry;
    }

    private COREntry _updateOrderRule(COREntry corEntry, OrderRule orderRule) throws Exception {
        ServiceContext serviceContext = this._serviceContextHelper.getServiceContext();
        DateConfig displayDateConfig = DateConfig.toDisplayDateConfig((Date)orderRule.getDisplayDate(), (TimeZone)serviceContext.getTimeZone());
        DateConfig expirationDateConfig = DateConfig.toExpirationDateConfig((Date)orderRule.getExpirationDate(), (TimeZone)serviceContext.getTimeZone());
        corEntry = this._corEntryService.updateCOREntry(corEntry.getCOREntryId(), GetterUtil.getBoolean((Object)orderRule.getActive(), (boolean)corEntry.isActive()), GetterUtil.getString((String)orderRule.getDescription(), (String)corEntry.getDescription()), displayDateConfig.getMonth(), displayDateConfig.getDay(), displayDateConfig.getYear(), displayDateConfig.getHour(), displayDateConfig.getMinute(), expirationDateConfig.getMonth(), expirationDateConfig.getDay(), expirationDateConfig.getYear(), expirationDateConfig.getHour(), expirationDateConfig.getMinute(), GetterUtil.getBoolean((Object)orderRule.getNeverExpire(), (boolean)true), GetterUtil.getString((String)orderRule.getName(), (String)corEntry.getName()), GetterUtil.getInteger((Object)orderRule.getPriority(), (int)corEntry.getPriority()), GetterUtil.get((String)orderRule.getTypeSettings(), (String)corEntry.getTypeSettings()), serviceContext);
        return this._updateNestedResources(corEntry, orderRule);
    }
}

