/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.order.internal.resource.v1_0;

import com.liferay.account.model.AccountEntry;
import com.liferay.commerce.account.model.CommerceAccount;
import com.liferay.commerce.account.service.CommerceAccountService;
import com.liferay.commerce.order.rule.exception.NoSuchCOREntryException;
import com.liferay.commerce.order.rule.model.COREntry;
import com.liferay.commerce.order.rule.model.COREntryRel;
import com.liferay.commerce.order.rule.service.COREntryRelService;
import com.liferay.commerce.order.rule.service.COREntryService;
import com.liferay.headless.commerce.admin.order.dto.v1_0.OrderRule;
import com.liferay.headless.commerce.admin.order.dto.v1_0.OrderRuleAccount;
import com.liferay.headless.commerce.admin.order.internal.dto.v1_0.converter.OrderRuleAccountDTOConverter;
import com.liferay.headless.commerce.admin.order.internal.resource.v1_0.BaseOrderRuleAccountResourceImpl;
import com.liferay.headless.commerce.admin.order.resource.v1_0.OrderRuleAccountResource;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.fields.NestedFieldSupport;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/order-rule-account.properties"}, scope=ServiceScope.PROTOTYPE, service={NestedFieldSupport.class, OrderRuleAccountResource.class})
public class OrderRuleAccountResourceImpl
extends BaseOrderRuleAccountResourceImpl
implements NestedFieldSupport {
    @Reference
    private CommerceAccountService _commerceAccountService;
    @Reference(target="(model.class.name=com.liferay.commerce.order.rule.model.COREntryRel)")
    private ModelResourcePermission<COREntryRel> _corEntryRelModelResourcePermission;
    @Reference
    private COREntryRelService _corEntryRelService;
    @Reference
    private COREntryService _corEntryService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private OrderRuleAccountDTOConverter _orderRuleAccountDTOConverter;

    @Override
    public void deleteOrderRuleAccount(Long id) throws Exception {
        this._corEntryRelService.deleteCOREntryRel(id.longValue());
    }

    @Override
    public Page<OrderRuleAccount> getOrderRuleByExternalReferenceCodeOrderRuleAccountsPage(String externalReferenceCode, Pagination pagination) throws Exception {
        COREntry corEntry = this._corEntryService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (corEntry == null) {
            throw new NoSuchCOREntryException("Unable to find order rule with external reference code " + externalReferenceCode);
        }
        return Page.of(this.transform(this._corEntryRelService.getAccountEntryCOREntryRels(corEntry.getCOREntryId(), null, pagination.getStartPosition(), pagination.getEndPosition()), corEntryRel -> this._toOrderRuleAccount((COREntryRel)corEntryRel)), (Pagination)pagination, (long)this._corEntryRelService.getAccountEntryCOREntryRelsCount(corEntry.getCOREntryId(), null));
    }

    @Override
    @NestedField(parentClass=OrderRule.class, value="orderRuleAccounts")
    public Page<OrderRuleAccount> getOrderRuleIdOrderRuleAccountsPage(Long id, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        COREntry corEntry = this._corEntryService.fetchCOREntry(id.longValue());
        if (corEntry == null) {
            throw new NoSuchCOREntryException("Unable to find order rule with ID " + id);
        }
        return Page.of(this.transform(this._corEntryRelService.getAccountEntryCOREntryRels(id.longValue(), search, pagination.getStartPosition(), pagination.getEndPosition()), corEntryRel -> this._toOrderRuleAccount((COREntryRel)corEntryRel)), (Pagination)pagination, (long)this._corEntryRelService.getAccountEntryCOREntryRelsCount(id.longValue(), search));
    }

    @Override
    public OrderRuleAccount postOrderRuleByExternalReferenceCodeOrderRuleAccount(String externalReferenceCode, OrderRuleAccount orderRuleAccount) throws Exception {
        COREntry corEntry = this._corEntryService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (corEntry == null) {
            throw new NoSuchCOREntryException("Unable to find order rule with external reference code " + externalReferenceCode);
        }
        CommerceAccount commerceAccount = this._getCommerceAccount(orderRuleAccount);
        return this._toOrderRuleAccount(this._corEntryRelService.addCOREntryRel(AccountEntry.class.getName(), commerceAccount.getCommerceAccountId(), corEntry.getCOREntryId()));
    }

    @Override
    public OrderRuleAccount postOrderRuleIdOrderRuleAccount(Long id, OrderRuleAccount orderRuleAccount) throws Exception {
        CommerceAccount commerceAccount = this._getCommerceAccount(orderRuleAccount);
        return this._toOrderRuleAccount(this._corEntryRelService.addCOREntryRel(AccountEntry.class.getName(), commerceAccount.getCommerceAccountId(), id.longValue()));
    }

    private Map<String, Map<String, String>> _getActions(COREntryRel corEntryRel) throws Exception {
        return HashMapBuilder.put((Object)"delete", this.addAction("UPDATE", corEntryRel.getCOREntryRelId(), "deleteOrderRuleAccount", this._corEntryRelModelResourcePermission)).build();
    }

    private CommerceAccount _getCommerceAccount(OrderRuleAccount orderRuleAccount) throws Exception {
        CommerceAccount commerceAccount = null;
        commerceAccount = orderRuleAccount.getAccountId() > 0L ? this._commerceAccountService.getCommerceAccount(orderRuleAccount.getAccountId().longValue()) : this._commerceAccountService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), orderRuleAccount.getAccountExternalReferenceCode());
        return commerceAccount;
    }

    private OrderRuleAccount _toOrderRuleAccount(COREntryRel corEntryRel) throws Exception {
        return this._orderRuleAccountDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), this._getActions(corEntryRel), this._dtoConverterRegistry, (Object)corEntryRel.getCOREntryRelId(), this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser));
    }
}

