/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.order.internal.resource.v1_0;

import com.liferay.commerce.context.CommerceContextFactory;
import com.liferay.commerce.exception.NoSuchOrderException;
import com.liferay.commerce.exception.NoSuchOrderItemException;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.product.service.CPInstanceService;
import com.liferay.commerce.service.CommerceOrderItemService;
import com.liferay.commerce.service.CommerceOrderService;
import com.liferay.expando.kernel.service.ExpandoColumnLocalService;
import com.liferay.expando.kernel.service.ExpandoTableLocalService;
import com.liferay.headless.commerce.admin.order.dto.v1_0.Order;
import com.liferay.headless.commerce.admin.order.dto.v1_0.OrderItem;
import com.liferay.headless.commerce.admin.order.internal.dto.v1_0.converter.OrderItemDTOConverter;
import com.liferay.headless.commerce.admin.order.internal.dto.v1_0.util.CustomFieldsUtil;
import com.liferay.headless.commerce.admin.order.internal.helper.v1_0.OrderItemHelper;
import com.liferay.headless.commerce.admin.order.internal.odata.entity.v1_0.OrderItemEntityModel;
import com.liferay.headless.commerce.admin.order.internal.resource.v1_0.BaseOrderItemResourceImpl;
import com.liferay.headless.commerce.admin.order.internal.util.v1_0.OrderItemUtil;
import com.liferay.headless.commerce.admin.order.resource.v1_0.OrderItemResource;
import com.liferay.headless.commerce.core.util.ExpandoUtil;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.headless.common.spi.odata.entity.EntityFieldsUtil;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.search.expando.ExpandoBridgeIndexer;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.fields.NestedFieldSupport;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.SearchUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/order-item.properties"}, scope=ServiceScope.PROTOTYPE, service={NestedFieldSupport.class, OrderItemResource.class})
public class OrderItemResourceImpl
extends BaseOrderItemResourceImpl
implements NestedFieldSupport {
    @Reference
    private CommerceContextFactory _commerceContextFactory;
    @Reference
    private CommerceOrderItemService _commerceOrderItemService;
    @Reference(target="(model.class.name=com.liferay.commerce.model.CommerceOrder)")
    private ModelResourcePermission<CommerceOrder> _commerceOrderModelResourcePermission;
    @Reference
    private CommerceOrderService _commerceOrderService;
    @Reference
    private CPInstanceService _cpInstanceService;
    @Reference
    private ExpandoBridgeIndexer _expandoBridgeIndexer;
    @Reference
    private ExpandoColumnLocalService _expandoColumnLocalService;
    @Reference
    private ExpandoTableLocalService _expandoTableLocalService;
    @Reference
    private OrderItemDTOConverter _orderItemDTOConverter;
    @Reference
    private OrderItemHelper _orderItemHelper;
    @Reference
    private Portal _portal;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    @Override
    public Response deleteOrderItem(Long id) throws Exception {
        CommerceOrderItem commerceOrderItem = this._commerceOrderItemService.getCommerceOrderItem(id.longValue());
        CommerceOrder commerceOrder = this._commerceOrderService.getCommerceOrder(commerceOrderItem.getCommerceOrderId());
        this._commerceOrderItemService.deleteCommerceOrderItem(commerceOrderItem.getCommerceOrderItemId(), this._commerceContextFactory.create(this.contextCompany.getCompanyId(), commerceOrder.getGroupId(), this.contextUser.getUserId(), commerceOrder.getCommerceOrderId(), commerceOrder.getCommerceAccountId()));
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Response deleteOrderItemByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CommerceOrderItem commerceOrderItem = this._commerceOrderItemService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commerceOrderItem == null) {
            throw new NoSuchOrderItemException("Unable to find order item with external reference code " + externalReferenceCode);
        }
        CommerceOrder commerceOrder = this._commerceOrderService.getCommerceOrder(commerceOrderItem.getCommerceOrderId());
        this._commerceOrderItemService.deleteCommerceOrderItem(commerceOrderItem.getCommerceOrderItemId(), this._commerceContextFactory.create(this.contextCompany.getCompanyId(), commerceOrder.getGroupId(), this.contextUser.getUserId(), commerceOrder.getCommerceOrderId(), commerceOrder.getCommerceAccountId()));
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return new OrderItemEntityModel(EntityFieldsUtil.getEntityFields((long)this._portal.getClassNameId(CommerceOrderItem.class.getName()), (long)this.contextCompany.getCompanyId(), (ExpandoBridgeIndexer)this._expandoBridgeIndexer, (ExpandoColumnLocalService)this._expandoColumnLocalService, (ExpandoTableLocalService)this._expandoTableLocalService));
    }

    @Override
    public Page<OrderItem> getOrderByExternalReferenceCodeOrderItemsPage(String externalReferenceCode, Pagination pagination) throws Exception {
        CommerceOrder commerceOrder = this._commerceOrderService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commerceOrder == null) {
            throw new NoSuchOrderException("Unable to find order with external reference code " + externalReferenceCode);
        }
        List commerceOrderItems = this._commerceOrderItemService.getCommerceOrderItems(commerceOrder.getCommerceOrderId(), pagination.getStartPosition(), pagination.getEndPosition());
        int totalItems = this._commerceOrderItemService.getCommerceOrderItemsCount(commerceOrder.getCommerceOrderId());
        return Page.of(this._orderItemHelper.toOrderItems(commerceOrderItems, this.contextAcceptLanguage.getPreferredLocale()), (Pagination)pagination, (long)totalItems);
    }

    @Override
    @NestedField(parentClass=Order.class, value="orderItems")
    public Page<OrderItem> getOrderIdOrderItemsPage(Long id, Pagination pagination) throws Exception {
        return this._orderItemHelper.getOrderItemsPage(id, this.contextAcceptLanguage.getPreferredLocale(), pagination);
    }

    @Override
    public OrderItem getOrderItem(Long id) throws Exception {
        return this._toOrderItem(GetterUtil.getLong((Object)id));
    }

    @Override
    public OrderItem getOrderItemByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CommerceOrderItem commerceOrderItem = this._commerceOrderItemService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commerceOrderItem == null) {
            throw new NoSuchOrderItemException("Unable to find order item with external reference code " + externalReferenceCode);
        }
        return this._toOrderItem(commerceOrderItem.getCommerceOrderItemId());
    }

    @Override
    public Page<OrderItem> getOrderItemsPage(String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return SearchUtil.search(null, booleanQuery -> booleanQuery.getPreBooleanFilter(), (Filter)filter, (String)CommerceOrderItem.class.getName(), (String)search, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> searchContext.setCompanyId(this.contextCompany.getCompanyId()), (Sort[])sorts, document -> this._toOrderItem(GetterUtil.getLong((String)document.get("entryClassPK"))));
    }

    @Override
    public Response patchOrderItem(Long id, OrderItem orderItem) throws Exception {
        this._updateOrderItem(this._commerceOrderItemService.getCommerceOrderItem(id.longValue()), orderItem);
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Response patchOrderItemByExternalReferenceCode(String externalReferenceCode, OrderItem orderItem) throws Exception {
        CommerceOrderItem commerceOrderItem = this._commerceOrderItemService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commerceOrderItem == null) {
            throw new NoSuchOrderItemException("Unable to find order item with external reference code " + externalReferenceCode);
        }
        this._updateOrderItem(commerceOrderItem, orderItem);
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public OrderItem postOrderByExternalReferenceCodeOrderItem(String externalReferenceCode, OrderItem orderItem) throws Exception {
        CommerceOrder commerceOrder = this._commerceOrderService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commerceOrder == null) {
            throw new NoSuchOrderException("Unable to find order with external reference code " + externalReferenceCode);
        }
        return this._addOrderItem(commerceOrder, orderItem);
    }

    @Override
    public OrderItem postOrderIdOrderItem(Long id, OrderItem orderItem) throws Exception {
        return this._addOrderItem(this._commerceOrderService.getCommerceOrder(id.longValue()), orderItem);
    }

    @Override
    public OrderItem putOrderItem(Long id, OrderItem orderItem) throws Exception {
        Map<String, Serializable> customFields;
        CommerceOrder commerceOrder = this._commerceOrderService.getCommerceOrder(orderItem.getOrderId().longValue());
        CommerceOrderItem commerceOrderItem = this._commerceOrderItemService.updateCommerceOrderItem(id.longValue(), GetterUtil.getString((String)orderItem.getOptions(), (String)"[]"), GetterUtil.getInteger((Object)orderItem.getQuantity()), this._commerceContextFactory.create(this.contextCompany.getCompanyId(), commerceOrder.getGroupId(), this.contextUser.getUserId(), commerceOrder.getCommerceOrderId(), commerceOrder.getCommerceAccountId()), this._serviceContextHelper.getServiceContext(commerceOrder.getScopeGroupId()));
        PortletResourcePermission portletResourcePermission = this._commerceOrderModelResourcePermission.getPortletResourcePermission();
        if (portletResourcePermission.contains(PermissionThreadLocal.getPermissionChecker(), commerceOrder.getGroupId(), "MANAGE_COMMERCE_ORDER_PRICES")) {
            commerceOrderItem = this._commerceOrderItemService.updateCommerceOrderItemPrices(commerceOrderItem.getCommerceOrderItemId(), (BigDecimal)GetterUtil.getNumber((Object)orderItem.getDiscountAmount(), (Number)BigDecimal.ZERO), (BigDecimal)GetterUtil.getNumber((Object)orderItem.getDiscountWithTaxAmount(), (Number)BigDecimal.ZERO), (BigDecimal)GetterUtil.getNumber((Object)orderItem.getDiscountPercentageLevel1(), (Number)BigDecimal.ZERO), (BigDecimal)GetterUtil.getNumber((Object)orderItem.getDiscountPercentageLevel1WithTaxAmount(), (Number)BigDecimal.ZERO), (BigDecimal)GetterUtil.getNumber((Object)orderItem.getDiscountPercentageLevel2(), (Number)BigDecimal.ZERO), (BigDecimal)GetterUtil.getNumber((Object)orderItem.getDiscountPercentageLevel2WithTaxAmount(), (Number)BigDecimal.ZERO), (BigDecimal)GetterUtil.getNumber((Object)orderItem.getDiscountPercentageLevel3(), (Number)BigDecimal.ZERO), (BigDecimal)GetterUtil.getNumber((Object)orderItem.getDiscountPercentageLevel3WithTaxAmount(), (Number)BigDecimal.ZERO), (BigDecimal)GetterUtil.getNumber((Object)orderItem.getDiscountPercentageLevel4(), (Number)BigDecimal.ZERO), (BigDecimal)GetterUtil.getNumber((Object)orderItem.getDiscountPercentageLevel4WithTaxAmount(), (Number)BigDecimal.ZERO), (BigDecimal)GetterUtil.getNumber((Object)orderItem.getFinalPrice(), (Number)BigDecimal.ZERO), (BigDecimal)GetterUtil.getNumber((Object)orderItem.getFinalPriceWithTaxAmount(), (Number)BigDecimal.ZERO), (BigDecimal)GetterUtil.getNumber((Object)orderItem.getPromoPrice(), (Number)BigDecimal.ZERO), (BigDecimal)GetterUtil.getNumber((Object)orderItem.getPromoPriceWithTaxAmount(), (Number)BigDecimal.ZERO), (BigDecimal)GetterUtil.getNumber((Object)orderItem.getUnitPrice(), (Number)BigDecimal.ZERO), (BigDecimal)GetterUtil.getNumber((Object)orderItem.getUnitPriceWithTaxAmount(), (Number)BigDecimal.ZERO));
        }
        if ((customFields = this._getExpandoBridgeAttributes(orderItem)) != null && !customFields.isEmpty()) {
            ExpandoUtil.updateExpando((long)this.contextCompany.getCompanyId(), CommerceOrderItem.class, (long)commerceOrderItem.getPrimaryKey(), customFields);
        }
        return this._toOrderItem(commerceOrderItem.getCommerceOrderItemId());
    }

    @Override
    public OrderItem putOrderItemByExternalReferenceCode(String externalReferenceCode, OrderItem orderItem) throws Exception {
        CommerceOrder commerceOrder = this._commerceOrderService.getCommerceOrder(GetterUtil.getLong((Object)orderItem.getOrderId()));
        CommerceOrderItem commerceOrderItem = this._commerceOrderItemService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commerceOrderItem == null) {
            commerceOrderItem = OrderItemUtil.addCommerceOrderItem(this._cpInstanceService, this._commerceOrderItemService, this._commerceOrderModelResourcePermission, orderItem, commerceOrder, this._commerceContextFactory.create(this.contextCompany.getCompanyId(), commerceOrder.getGroupId(), this.contextUser.getUserId(), commerceOrder.getCommerceOrderId(), commerceOrder.getCommerceAccountId()), this._serviceContextHelper.getServiceContext(commerceOrder.getGroupId()));
            commerceOrderItem = this._commerceOrderItemService.updateExternalReferenceCode(commerceOrderItem.getCommerceOrderItemId(), externalReferenceCode);
        } else {
            commerceOrderItem = this._commerceOrderItemService.updateCommerceOrderItem(commerceOrderItem.getCommerceOrderItemId(), GetterUtil.getString((String)orderItem.getOptions(), (String)"[]"), GetterUtil.getInteger((Object)orderItem.getQuantity()), this._commerceContextFactory.create(this.contextCompany.getCompanyId(), commerceOrder.getGroupId(), this.contextUser.getUserId(), commerceOrder.getCommerceOrderId(), commerceOrder.getCommerceAccountId()), this._serviceContextHelper.getServiceContext(commerceOrder.getGroupId()));
            PortletResourcePermission portletResourcePermission = this._commerceOrderModelResourcePermission.getPortletResourcePermission();
            if (portletResourcePermission.contains(PermissionThreadLocal.getPermissionChecker(), commerceOrder.getGroupId(), "MANAGE_COMMERCE_ORDER_PRICES")) {
                commerceOrderItem = this._commerceOrderItemService.updateCommerceOrderItemPrices(commerceOrderItem.getCommerceOrderItemId(), (BigDecimal)GetterUtil.getNumber((Object)orderItem.getDiscountAmount(), (Number)BigDecimal.ZERO), (BigDecimal)GetterUtil.getNumber((Object)orderItem.getDiscountWithTaxAmount(), (Number)BigDecimal.ZERO), (BigDecimal)GetterUtil.getNumber((Object)orderItem.getDiscountPercentageLevel1(), (Number)BigDecimal.ZERO), (BigDecimal)GetterUtil.getNumber((Object)orderItem.getDiscountPercentageLevel1WithTaxAmount(), (Number)BigDecimal.ZERO), (BigDecimal)GetterUtil.getNumber((Object)orderItem.getDiscountPercentageLevel2(), (Number)BigDecimal.ZERO), (BigDecimal)GetterUtil.getNumber((Object)orderItem.getDiscountPercentageLevel2WithTaxAmount(), (Number)BigDecimal.ZERO), (BigDecimal)GetterUtil.getNumber((Object)orderItem.getDiscountPercentageLevel3(), (Number)BigDecimal.ZERO), (BigDecimal)GetterUtil.getNumber((Object)orderItem.getDiscountPercentageLevel3WithTaxAmount(), (Number)BigDecimal.ZERO), (BigDecimal)GetterUtil.getNumber((Object)orderItem.getDiscountPercentageLevel4(), (Number)BigDecimal.ZERO), (BigDecimal)GetterUtil.getNumber((Object)orderItem.getDiscountPercentageLevel4WithTaxAmount(), (Number)BigDecimal.ZERO), (BigDecimal)GetterUtil.getNumber((Object)orderItem.getFinalPrice(), (Number)BigDecimal.ZERO), (BigDecimal)GetterUtil.getNumber((Object)orderItem.getFinalPriceWithTaxAmount(), (Number)BigDecimal.ZERO), (BigDecimal)GetterUtil.getNumber((Object)orderItem.getPromoPrice(), (Number)BigDecimal.ZERO), (BigDecimal)GetterUtil.getNumber((Object)orderItem.getPromoPriceWithTaxAmount(), (Number)BigDecimal.ZERO), (BigDecimal)GetterUtil.getNumber((Object)orderItem.getUnitPrice(), (Number)BigDecimal.ZERO), (BigDecimal)GetterUtil.getNumber((Object)orderItem.getUnitPriceWithTaxAmount(), (Number)BigDecimal.ZERO));
            }
        }
        Map<String, Serializable> customFields = this._getExpandoBridgeAttributes(orderItem);
        if (customFields != null && !customFields.isEmpty()) {
            ExpandoUtil.updateExpando((long)this.contextCompany.getCompanyId(), CommerceOrderItem.class, (long)commerceOrderItem.getPrimaryKey(), customFields);
        }
        return this._toOrderItem(commerceOrderItem.getCommerceOrderItemId());
    }

    private OrderItem _addOrderItem(CommerceOrder commerceOrder, OrderItem orderItem) throws Exception {
        Map<String, Serializable> customFields;
        CommerceOrderItem commerceOrderItem = OrderItemUtil.addCommerceOrderItem(this._cpInstanceService, this._commerceOrderItemService, this._commerceOrderModelResourcePermission, orderItem, commerceOrder, this._commerceContextFactory.create(this.contextCompany.getCompanyId(), commerceOrder.getGroupId(), this.contextUser.getUserId(), commerceOrder.getCommerceOrderId(), commerceOrder.getCommerceAccountId()), this._serviceContextHelper.getServiceContext(commerceOrder.getGroupId()));
        PortletResourcePermission portletResourcePermission = this._commerceOrderModelResourcePermission.getPortletResourcePermission();
        if (portletResourcePermission.contains(PermissionThreadLocal.getPermissionChecker(), commerceOrder.getGroupId(), "MANAGE_COMMERCE_ORDER_PRICES")) {
            commerceOrderItem = this._commerceOrderItemService.updateCommerceOrderItemPrices(commerceOrderItem.getCommerceOrderItemId(), (BigDecimal)GetterUtil.get((Object)orderItem.getDiscountAmount(), (Number)commerceOrderItem.getDiscountAmount()), (BigDecimal)GetterUtil.get((Object)orderItem.getDiscountWithTaxAmount(), (Number)commerceOrderItem.getDiscountWithTaxAmount()), (BigDecimal)GetterUtil.get((Object)orderItem.getDiscountPercentageLevel1(), (Number)commerceOrderItem.getDiscountPercentageLevel1()), (BigDecimal)GetterUtil.get((Object)orderItem.getDiscountPercentageLevel1WithTaxAmount(), (Number)commerceOrderItem.getDiscountPercentageLevel1WithTaxAmount()), (BigDecimal)GetterUtil.get((Object)orderItem.getDiscountPercentageLevel2(), (Number)commerceOrderItem.getDiscountPercentageLevel2()), (BigDecimal)GetterUtil.get((Object)orderItem.getDiscountPercentageLevel2WithTaxAmount(), (Number)commerceOrderItem.getDiscountPercentageLevel2WithTaxAmount()), (BigDecimal)GetterUtil.get((Object)orderItem.getDiscountPercentageLevel3(), (Number)commerceOrderItem.getDiscountPercentageLevel3()), (BigDecimal)GetterUtil.get((Object)orderItem.getDiscountPercentageLevel3WithTaxAmount(), (Number)commerceOrderItem.getDiscountPercentageLevel3WithTaxAmount()), (BigDecimal)GetterUtil.get((Object)orderItem.getDiscountPercentageLevel4(), (Number)commerceOrderItem.getDiscountPercentageLevel4()), (BigDecimal)GetterUtil.get((Object)orderItem.getDiscountPercentageLevel4WithTaxAmount(), (Number)commerceOrderItem.getDiscountPercentageLevel4WithTaxAmount()), (BigDecimal)GetterUtil.get((Object)orderItem.getFinalPrice(), (Number)commerceOrderItem.getFinalPrice()), (BigDecimal)GetterUtil.get((Object)orderItem.getFinalPriceWithTaxAmount(), (Number)commerceOrderItem.getFinalPriceWithTaxAmount()), (BigDecimal)GetterUtil.get((Object)orderItem.getPromoPrice(), (Number)commerceOrderItem.getPromoPrice()), (BigDecimal)GetterUtil.get((Object)orderItem.getPromoPriceWithTaxAmount(), (Number)commerceOrderItem.getPromoPriceWithTaxAmount()), (BigDecimal)GetterUtil.get((Object)orderItem.getUnitPrice(), (Number)commerceOrderItem.getUnitPrice()), (BigDecimal)GetterUtil.get((Object)orderItem.getUnitPriceWithTaxAmount(), (Number)commerceOrderItem.getUnitPriceWithTaxAmount()));
        }
        if ((customFields = this._getExpandoBridgeAttributes(orderItem)) != null && !customFields.isEmpty()) {
            ExpandoUtil.updateExpando((long)this.contextCompany.getCompanyId(), CommerceOrderItem.class, (long)commerceOrderItem.getPrimaryKey(), customFields);
        }
        return this._toOrderItem(commerceOrderItem.getCommerceOrderItemId());
    }

    private Map<String, Serializable> _getExpandoBridgeAttributes(OrderItem orderItem) {
        return CustomFieldsUtil.toMap(CommerceOrderItem.class.getName(), this.contextCompany.getCompanyId(), orderItem.getCustomFields(), this.contextAcceptLanguage.getPreferredLocale());
    }

    private OrderItem _toOrderItem(long commerceOrderItemId) throws Exception {
        return this._orderItemDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)commerceOrderItemId, this.contextAcceptLanguage.getPreferredLocale()));
    }

    private OrderItem _updateOrderItem(CommerceOrderItem commerceOrderItem, OrderItem orderItem) throws Exception {
        Map<String, Serializable> customFields;
        CommerceOrder commerceOrder = this._commerceOrderService.getCommerceOrder(commerceOrderItem.getCommerceOrderId());
        commerceOrderItem = this._commerceOrderItemService.updateCommerceOrderItem(commerceOrderItem.getCommerceOrderItemId(), GetterUtil.getString((String)orderItem.getOptions(), (String)commerceOrderItem.getJson()), GetterUtil.get((Object)orderItem.getQuantity(), (int)commerceOrderItem.getQuantity()), this._commerceContextFactory.create(this.contextCompany.getCompanyId(), commerceOrder.getGroupId(), this.contextUser.getUserId(), commerceOrder.getCommerceOrderId(), commerceOrder.getCommerceAccountId()), this._serviceContextHelper.getServiceContext(commerceOrderItem.getGroupId()));
        PortletResourcePermission portletResourcePermission = this._commerceOrderModelResourcePermission.getPortletResourcePermission();
        if (portletResourcePermission.contains(PermissionThreadLocal.getPermissionChecker(), commerceOrder.getGroupId(), "MANAGE_COMMERCE_ORDER_PRICES")) {
            commerceOrderItem = this._commerceOrderItemService.updateCommerceOrderItemPrices(commerceOrderItem.getCommerceOrderItemId(), (BigDecimal)GetterUtil.get((Object)orderItem.getDiscountAmount(), (Number)commerceOrderItem.getDiscountAmount()), (BigDecimal)GetterUtil.get((Object)orderItem.getDiscountWithTaxAmount(), (Number)commerceOrderItem.getDiscountWithTaxAmount()), (BigDecimal)GetterUtil.get((Object)orderItem.getDiscountPercentageLevel1(), (Number)commerceOrderItem.getDiscountPercentageLevel1()), (BigDecimal)GetterUtil.get((Object)orderItem.getDiscountPercentageLevel1WithTaxAmount(), (Number)commerceOrderItem.getDiscountPercentageLevel1WithTaxAmount()), (BigDecimal)GetterUtil.get((Object)orderItem.getDiscountPercentageLevel2(), (Number)commerceOrderItem.getDiscountPercentageLevel2()), (BigDecimal)GetterUtil.get((Object)orderItem.getDiscountPercentageLevel2WithTaxAmount(), (Number)commerceOrderItem.getDiscountPercentageLevel2WithTaxAmount()), (BigDecimal)GetterUtil.get((Object)orderItem.getDiscountPercentageLevel3(), (Number)commerceOrderItem.getDiscountPercentageLevel3()), (BigDecimal)GetterUtil.get((Object)orderItem.getDiscountPercentageLevel3WithTaxAmount(), (Number)commerceOrderItem.getDiscountPercentageLevel3WithTaxAmount()), (BigDecimal)GetterUtil.get((Object)orderItem.getDiscountPercentageLevel4(), (Number)commerceOrderItem.getDiscountPercentageLevel4()), (BigDecimal)GetterUtil.get((Object)orderItem.getDiscountPercentageLevel4WithTaxAmount(), (Number)commerceOrderItem.getDiscountPercentageLevel4WithTaxAmount()), (BigDecimal)GetterUtil.get((Object)orderItem.getFinalPrice(), (Number)commerceOrderItem.getFinalPrice()), (BigDecimal)GetterUtil.get((Object)orderItem.getFinalPriceWithTaxAmount(), (Number)commerceOrderItem.getFinalPriceWithTaxAmount()), (BigDecimal)GetterUtil.get((Object)orderItem.getPromoPrice(), (Number)commerceOrderItem.getPromoPrice()), (BigDecimal)GetterUtil.get((Object)orderItem.getPromoPriceWithTaxAmount(), (Number)commerceOrderItem.getPromoPriceWithTaxAmount()), (BigDecimal)GetterUtil.get((Object)orderItem.getUnitPrice(), (Number)commerceOrderItem.getUnitPrice()), (BigDecimal)GetterUtil.get((Object)orderItem.getUnitPriceWithTaxAmount(), (Number)commerceOrderItem.getUnitPriceWithTaxAmount()));
        }
        if ((customFields = this._getExpandoBridgeAttributes(orderItem)) != null && !customFields.isEmpty()) {
            ExpandoUtil.updateExpando((long)this.contextCompany.getCompanyId(), CommerceOrderItem.class, (long)commerceOrderItem.getPrimaryKey(), customFields);
        }
        return this._toOrderItem(commerceOrderItem.getCommerceOrderItemId());
    }
}

