/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.order.internal.resource.v1_0;

import com.liferay.commerce.exception.NoSuchOrderException;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderTypeRel;
import com.liferay.commerce.order.rule.model.COREntryRel;
import com.liferay.commerce.order.rule.service.COREntryRelService;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.service.CommerceOrderService;
import com.liferay.commerce.service.CommerceOrderTypeRelService;
import com.liferay.headless.commerce.admin.order.dto.v1_0.Channel;
import com.liferay.headless.commerce.admin.order.dto.v1_0.Order;
import com.liferay.headless.commerce.admin.order.dto.v1_0.OrderRuleChannel;
import com.liferay.headless.commerce.admin.order.dto.v1_0.OrderTypeChannel;
import com.liferay.headless.commerce.admin.order.internal.dto.v1_0.converter.ChannelDTOConverter;
import com.liferay.headless.commerce.admin.order.internal.resource.v1_0.BaseChannelResourceImpl;
import com.liferay.headless.commerce.admin.order.resource.v1_0.ChannelResource;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.fields.NestedFieldSupport;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/channel.properties"}, scope=ServiceScope.PROTOTYPE, service={ChannelResource.class, NestedFieldSupport.class})
public class ChannelResourceImpl
extends BaseChannelResourceImpl
implements NestedFieldSupport {
    @Reference
    private ChannelDTOConverter _channelDTOConverter;
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private CommerceOrderService _commerceOrderService;
    @Reference
    private CommerceOrderTypeRelService _commerceOrderTypeRelService;
    @Reference
    private COREntryRelService _corEntryRelService;

    @Override
    public Channel getOrderByExternalReferenceCodeChannel(String externalReferenceCode) throws Exception {
        CommerceOrder commerceOrder = this._commerceOrderService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commerceOrder == null) {
            throw new NoSuchOrderException("Unable to find order with external reference code " + externalReferenceCode);
        }
        CommerceChannel commerceChannel = this._commerceChannelLocalService.getCommerceChannelByOrderGroupId(commerceOrder.getGroupId());
        return this._toChannel(commerceChannel.getCommerceChannelId());
    }

    @Override
    @NestedField(parentClass=Order.class, value="channel")
    public Channel getOrderIdChannel(Long id) throws Exception {
        CommerceOrder commerceOrder = this._commerceOrderService.getCommerceOrder(id.longValue());
        CommerceChannel commerceChannel = this._commerceChannelLocalService.getCommerceChannelByOrderGroupId(commerceOrder.getGroupId());
        return this._toChannel(commerceChannel.getCommerceChannelId());
    }

    @Override
    @NestedField(parentClass=OrderRuleChannel.class, value="channel")
    public Channel getOrderRuleChannelChannel(Long id) throws Exception {
        COREntryRel corEntryRel = this._corEntryRelService.getCOREntryRel(id.longValue());
        CommerceChannel commerceChannel = this._commerceChannelLocalService.getCommerceChannel(corEntryRel.getClassPK());
        return this._toChannel(commerceChannel.getCommerceChannelId());
    }

    @Override
    @NestedField(parentClass=OrderTypeChannel.class, value="channel")
    public Channel getOrderTypeChannelChannel(Long id) throws Exception {
        CommerceOrderTypeRel commerceOrderTypeRel = this._commerceOrderTypeRelService.getCommerceOrderTypeRel(id.longValue());
        CommerceChannel commerceChannel = this._commerceChannelLocalService.getCommerceChannel(commerceOrderTypeRel.getClassPK());
        return this._toChannel(commerceChannel.getCommerceChannelId());
    }

    private Channel _toChannel(long commerceChannelId) throws Exception {
        return this._channelDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)commerceChannelId, this.contextAcceptLanguage.getPreferredLocale()));
    }
}

