/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.order.internal.resource.v1_0;

import com.liferay.commerce.exception.NoSuchOrderException;
import com.liferay.commerce.model.CommerceAddress;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.service.CommerceAddressService;
import com.liferay.commerce.service.CommerceOrderService;
import com.liferay.headless.commerce.admin.order.dto.v1_0.BillingAddress;
import com.liferay.headless.commerce.admin.order.dto.v1_0.Order;
import com.liferay.headless.commerce.admin.order.internal.dto.v1_0.converter.BillingAddressDTOConverter;
import com.liferay.headless.commerce.admin.order.internal.resource.v1_0.BaseBillingAddressResourceImpl;
import com.liferay.headless.commerce.admin.order.internal.util.v1_0.BillingAddressUtil;
import com.liferay.headless.commerce.admin.order.resource.v1_0.BillingAddressResource;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.fields.NestedFieldSupport;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/billing-address.properties"}, scope=ServiceScope.PROTOTYPE, service={BillingAddressResource.class, NestedFieldSupport.class})
public class BillingAddressResourceImpl
extends BaseBillingAddressResourceImpl
implements NestedFieldSupport {
    @Reference
    private BillingAddressDTOConverter _billingAddressDTOConverter;
    @Reference
    private CommerceAddressService _commerceAddressService;
    @Reference
    private CommerceOrderService _commerceOrderService;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    @Override
    public BillingAddress getOrderByExternalReferenceCodeBillingAddress(String externalReferenceCode) throws Exception {
        CommerceOrder commerceOrder = this._commerceOrderService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commerceOrder == null) {
            throw new NoSuchOrderException("Unable to find order with external reference code " + externalReferenceCode);
        }
        CommerceAddress commerceAddress = this._commerceAddressService.getCommerceAddress(commerceOrder.getBillingAddressId());
        return this._billingAddressDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)commerceAddress.getCommerceAddressId(), this.contextAcceptLanguage.getPreferredLocale()));
    }

    @Override
    @NestedField(parentClass=Order.class, value="billingAddress")
    public BillingAddress getOrderIdBillingAddress(Long id) throws Exception {
        CommerceOrder commerceOrder = this._commerceOrderService.getCommerceOrder(id.longValue());
        CommerceAddress commerceAddress = this._commerceAddressService.fetchCommerceAddress(commerceOrder.getBillingAddressId());
        if (commerceAddress == null) {
            return new BillingAddress();
        }
        return this._billingAddressDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)commerceAddress.getCommerceAddressId(), this.contextAcceptLanguage.getPreferredLocale()));
    }

    @Override
    public Response patchOrderByExternalReferenceCodeBillingAddress(String externalReferenceCode, BillingAddress billingAddress) throws Exception {
        CommerceOrder commerceOrder = this._commerceOrderService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commerceOrder == null) {
            throw new NoSuchOrderException("Unable to find order with external reference code " + externalReferenceCode);
        }
        BillingAddressUtil.addOrUpdateBillingAddress(this._commerceAddressService, this._commerceOrderService, commerceOrder, billingAddress, this._serviceContextHelper.getServiceContext());
        Response.ResponseBuilder responseBuilder = Response.noContent();
        return responseBuilder.build();
    }

    @Override
    public Response patchOrderIdBillingAddress(Long id, BillingAddress billingAddress) throws Exception {
        BillingAddressUtil.addOrUpdateBillingAddress(this._commerceAddressService, this._commerceOrderService, this._commerceOrderService.getCommerceOrder(id.longValue()), billingAddress, this._serviceContextHelper.getServiceContext());
        Response.ResponseBuilder responseBuilder = Response.noContent();
        return responseBuilder.build();
    }
}

