/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.order.internal.dto.v1_0.converter;

import com.liferay.commerce.order.rule.model.COREntry;
import com.liferay.commerce.order.rule.service.COREntryService;
import com.liferay.headless.commerce.admin.order.dto.v1_0.OrderRule;
import com.liferay.headless.commerce.admin.order.dto.v1_0.Status;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.workflow.WorkflowConstants;
import com.liferay.portal.language.LanguageResources;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.commerce.order.rule.model.COREntry"}, service={DTOConverter.class, OrderRuleDTOConverter.class})
public class OrderRuleDTOConverter
implements DTOConverter<COREntry, OrderRule> {
    @Reference
    private COREntryService _corEntryService;
    @Reference
    private Language _language;

    public String getContentType() {
        return OrderRule.class.getSimpleName();
    }

    public OrderRule toDTO(final DTOConverterContext dtoConverterContext) throws Exception {
        final COREntry corEntry = this._corEntryService.getCOREntry(((Long)dtoConverterContext.getId()).longValue());
        return new OrderRule(){
            {
                this.actions = dtoConverterContext.getActions();
                this.active = corEntry.isActive();
                this.description = corEntry.getDescription();
                this.displayDate = corEntry.getDisplayDate();
                this.expirationDate = corEntry.getExpirationDate();
                this.externalReferenceCode = corEntry.getExternalReferenceCode();
                this.id = corEntry.getCOREntryId();
                this.name = corEntry.getName();
                this.type = corEntry.getType();
                this.typeSettings = corEntry.getTypeSettings();
                this.workflowStatusInfo = OrderRuleDTOConverter.this._toStatus(WorkflowConstants.getStatusLabel((int)corEntry.getStatus()), OrderRuleDTOConverter.this._language.get(LanguageResources.getResourceBundle((Locale)dtoConverterContext.getLocale()), WorkflowConstants.getStatusLabel((int)corEntry.getStatus())), corEntry.getStatus());
            }
        };
    }

    private Status _toStatus(final String orderTypeStatusLabel, final String orderTypeStatusLabelI18n, final int statusCode) {
        return new Status(){
            {
                this.code = statusCode;
                this.label = orderTypeStatusLabel;
                this.label_i18n = orderTypeStatusLabelI18n;
            }
        };
    }
}

