/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.order.internal.dto.v1_0.converter;

import com.liferay.commerce.account.model.CommerceAccount;
import com.liferay.commerce.constants.CommerceOrderConstants;
import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.currency.model.CommerceMoney;
import com.liferay.commerce.currency.util.CommercePriceFormatter;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderType;
import com.liferay.commerce.model.CommerceShippingMethod;
import com.liferay.commerce.order.status.CommerceOrderStatus;
import com.liferay.commerce.order.status.CommerceOrderStatusRegistry;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.service.CommerceOrderService;
import com.liferay.commerce.service.CommerceOrderTypeService;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.headless.commerce.admin.order.dto.v1_0.Order;
import com.liferay.headless.commerce.admin.order.dto.v1_0.Status;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowConstants;
import com.liferay.portal.language.LanguageResources;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import java.math.BigDecimal;
import java.util.Locale;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"application.name=Liferay.Headless.Commerce.Admin.Order", "dto.class.name=com.liferay.commerce.model.CommerceOrder", "version=v1.0"}, service={DTOConverter.class, OrderDTOConverter.class})
public class OrderDTOConverter
implements DTOConverter<CommerceOrder, Order> {
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private CommerceOrderService _commerceOrderService;
    @Reference
    private CommerceOrderStatusRegistry _commerceOrderStatusRegistry;
    @Reference
    private CommerceOrderTypeService _commerceOrderTypeService;
    @Reference
    private CommercePriceFormatter _commercePriceFormatter;
    @Reference
    private Language _language;

    public String getContentType() {
        return Order.class.getSimpleName();
    }

    public Order toDTO(final DTOConverterContext dtoConverterContext) throws Exception {
        final CommerceOrder commerceOrder = this._commerceOrderService.getCommerceOrder(((Long)dtoConverterContext.getId()).longValue());
        final CommerceAccount commerceAccount = commerceOrder.getCommerceAccount();
        final CommerceCurrency commerceCurrency = commerceOrder.getCommerceCurrency();
        final CommerceShippingMethod commerceShippingMethod = commerceOrder.getCommerceShippingMethod();
        final ExpandoBridge expandoBridge = commerceOrder.getExpandoBridge();
        Locale locale = dtoConverterContext.getLocale();
        ResourceBundle resourceBundle = LanguageResources.getResourceBundle((Locale)locale);
        final String commerceOrderStatusLabel = this._getCommerceOrderStatusLabel(commerceOrder.getOrderStatus(), locale);
        final String commerceOrderStatusLabelI18n = this._getCommerceOrderStatusLabelI18n(commerceOrder.getOrderStatus(), locale);
        final String commerceOrderWorkflowStatusLabel = WorkflowConstants.getStatusLabel((int)commerceOrder.getStatus());
        final String commerceOrderWorkflowStatusLabelI18n = this._language.get(resourceBundle, WorkflowConstants.getStatusLabel((int)commerceOrder.getStatus()));
        final String commerceOrderPaymentStatusLabel = CommerceOrderConstants.getPaymentStatusLabel((int)commerceOrder.getPaymentStatus());
        final String commerceOrderPaymentStatusLabelI18n = this._language.get(resourceBundle, CommerceOrderConstants.getPaymentStatusLabel((int)commerceOrder.getPaymentStatus()));
        final CommerceChannel commerceChannel = this._commerceChannelLocalService.getCommerceChannelByOrderGroupId(commerceOrder.getGroupId());
        Order order = new Order(){
            {
                this.accountExternalReferenceCode = commerceAccount.getExternalReferenceCode();
                this.accountId = commerceOrder.getCommerceAccountId();
                this.actions = dtoConverterContext.getActions();
                this.advanceStatus = commerceOrder.getAdvanceStatus();
                this.billingAddressId = commerceOrder.getBillingAddressId();
                this.channelExternalReferenceCode = commerceChannel.getExternalReferenceCode();
                this.channelId = commerceChannel.getCommerceChannelId();
                this.couponCode = commerceOrder.getCouponCode();
                this.createDate = commerceOrder.getCreateDate();
                this.currencyCode = commerceCurrency.getCode();
                this.customFields = expandoBridge.getAttributes();
                this.deliveryTermDescription = commerceOrder.getDeliveryCommerceTermEntryDescription();
                this.deliveryTermId = commerceOrder.getDeliveryCommerceTermEntryId();
                this.deliveryTermName = commerceOrder.getDeliveryCommerceTermEntryName();
                this.externalReferenceCode = commerceOrder.getExternalReferenceCode();
                this.id = commerceOrder.getCommerceOrderId();
                this.lastPriceUpdateDate = commerceOrder.getLastPriceUpdateDate();
                this.modifiedDate = commerceOrder.getModifiedDate();
                this.orderDate = commerceOrder.getOrderDate();
                this.orderStatus = commerceOrder.getOrderStatus();
                this.orderStatusInfo = OrderDTOConverter.this._getOrderStatusInfo(commerceOrder.getOrderStatus(), commerceOrderStatusLabel, commerceOrderStatusLabelI18n);
                this.orderTypeExternalReferenceCode = OrderDTOConverter.this._getOrderTypeExternalReferenceCode(commerceOrder.getCommerceOrderTypeId());
                this.orderTypeId = commerceOrder.getCommerceOrderTypeId();
                this.paymentMethod = commerceOrder.getCommercePaymentMethodKey();
                this.paymentStatus = commerceOrder.getPaymentStatus();
                this.paymentStatusInfo = OrderDTOConverter.this._getPaymentStatusInfo(commerceOrder.getPaymentStatus(), commerceOrderPaymentStatusLabel, commerceOrderPaymentStatusLabelI18n);
                this.paymentTermDescription = commerceOrder.getPaymentCommerceTermEntryDescription();
                this.paymentTermId = commerceOrder.getPaymentCommerceTermEntryId();
                this.paymentTermName = commerceOrder.getPaymentCommerceTermEntryName();
                this.printedNote = commerceOrder.getPrintedNote();
                this.purchaseOrderNumber = commerceOrder.getPurchaseOrderNumber();
                this.requestedDeliveryDate = commerceOrder.getRequestedDeliveryDate();
                this.shippingAddressId = commerceOrder.getShippingAddressId();
                this.shippingMethod = OrderDTOConverter.this._getShippingMethodEngineKey(commerceShippingMethod);
                this.shippingOption = commerceOrder.getShippingOptionName();
                this.transactionId = commerceOrder.getTransactionId();
                this.workflowStatusInfo = OrderDTOConverter.this._toStatus(commerceOrder.getStatus(), commerceOrderWorkflowStatusLabel, commerceOrderWorkflowStatusLabelI18n);
            }
        };
        this._setOrderSubtotal(commerceCurrency, commerceOrder, order, locale);
        this._setOrderShipping(commerceCurrency, commerceOrder, order, locale);
        BigDecimal taxAmount = commerceOrder.getTaxAmount();
        if (taxAmount != null) {
            order.setTaxAmount(taxAmount);
            order.setTaxAmountFormatted(this._formatPrice(taxAmount, commerceCurrency, locale));
            order.setTaxAmountValue(Double.valueOf(taxAmount.doubleValue()));
        }
        this._setOrderTotal(commerceCurrency, commerceOrder, order, locale);
        return order;
    }

    private String _formatPrice(BigDecimal price, CommerceCurrency commerceCurrency, Locale locale) throws Exception {
        if (price == null) {
            price = BigDecimal.ZERO;
        }
        return this._commercePriceFormatter.format(commerceCurrency, price, locale);
    }

    private String _getCommerceOrderStatusLabel(int orderStatus, Locale locale) {
        String commerceOrderStatusLabel = CommerceOrderConstants.getOrderStatusLabel((int)orderStatus);
        if (!Validator.isBlank((String)commerceOrderStatusLabel)) {
            return commerceOrderStatusLabel;
        }
        CommerceOrderStatus commerceOrderStatus = this._commerceOrderStatusRegistry.getCommerceOrderStatus(orderStatus);
        if (commerceOrderStatus != null) {
            return commerceOrderStatus.getLabel(locale);
        }
        return commerceOrderStatusLabel;
    }

    private String _getCommerceOrderStatusLabelI18n(int orderStatus, Locale locale) {
        String commerceOrderStatusLabelI18n = this._language.get(locale, CommerceOrderConstants.getOrderStatusLabel((int)orderStatus));
        if (!Validator.isBlank((String)commerceOrderStatusLabelI18n)) {
            return commerceOrderStatusLabelI18n;
        }
        return this._getCommerceOrderStatusLabel(orderStatus, locale);
    }

    private Status _getOrderStatusInfo(final int orderStatus, final String commerceOrderStatusLabel, final String commerceOrderStatusLabelI18n) {
        return new Status(){
            {
                this.code = orderStatus;
                this.label = commerceOrderStatusLabel;
                this.label_i18n = commerceOrderStatusLabelI18n;
            }
        };
    }

    private String _getOrderTypeExternalReferenceCode(long commerceOrderTypeId) throws Exception {
        CommerceOrderType commerceOrderType = this._commerceOrderTypeService.fetchCommerceOrderType(commerceOrderTypeId);
        if (commerceOrderType == null) {
            return null;
        }
        return commerceOrderType.getExternalReferenceCode();
    }

    private Status _getPaymentStatusInfo(final int paymentStatus, final String commerceOrderPaymentStatusLabel, final String commerceOrderPaymentStatusLabelI18n) {
        return new Status(){
            {
                this.code = paymentStatus;
                this.label = commerceOrderPaymentStatusLabel;
                this.label_i18n = commerceOrderPaymentStatusLabelI18n;
            }
        };
    }

    private String _getShippingMethodEngineKey(CommerceShippingMethod commerceShippingMethod) {
        if (commerceShippingMethod == null) {
            return null;
        }
        return commerceShippingMethod.getEngineKey();
    }

    private void _setOrderShipping(CommerceCurrency commerceCurrency, CommerceOrder commerceOrder, Order order, Locale locale) throws Exception {
        BigDecimal shippingDiscountWithTaxAmount;
        BigDecimal shippingDiscountAmount;
        CommerceMoney commerceOrderShippingWithTaxAmountCommerceMoney;
        CommerceMoney commerceOrderShippingAmountCommerceMoney = commerceOrder.getShippingMoney();
        order.setShippingAmountFormatted(commerceOrderShippingAmountCommerceMoney.format(locale));
        BigDecimal commerceOrderShippingValue = commerceOrderShippingAmountCommerceMoney.getPrice();
        if (commerceOrderShippingValue != null) {
            order.setShippingAmountValue(Double.valueOf(commerceOrderShippingValue.doubleValue()));
        }
        if ((commerceOrderShippingWithTaxAmountCommerceMoney = commerceOrder.getShippingWithTaxAmountMoney()) != null) {
            order.setShippingWithTaxAmountFormatted(commerceOrderShippingWithTaxAmountCommerceMoney.format(locale));
            BigDecimal commerceOrderShippingWithTaxAmountValue = commerceOrderShippingWithTaxAmountCommerceMoney.getPrice();
            if (commerceOrderShippingWithTaxAmountValue != null) {
                order.setShippingWithTaxAmountValue(Double.valueOf(commerceOrderShippingWithTaxAmountValue.doubleValue()));
            }
        }
        if ((shippingDiscountAmount = commerceOrder.getShippingDiscountAmount()) != null) {
            order.setShippingDiscountAmount(shippingDiscountAmount);
            order.setShippingDiscountAmountFormatted(this._formatPrice(shippingDiscountAmount, commerceCurrency, locale));
            order.setShippingDiscountPercentageLevel1(commerceOrder.getShippingDiscountPercentageLevel1());
            order.setShippingDiscountPercentageLevel2(commerceOrder.getShippingDiscountPercentageLevel2());
            order.setShippingDiscountPercentageLevel3(commerceOrder.getShippingDiscountPercentageLevel3());
            order.setShippingDiscountPercentageLevel4(commerceOrder.getShippingDiscountPercentageLevel4());
        }
        if ((shippingDiscountWithTaxAmount = commerceOrder.getShippingDiscountWithTaxAmount()) != null) {
            order.setShippingDiscountWithTaxAmount(shippingDiscountWithTaxAmount);
            order.setShippingDiscountWithTaxAmountFormatted(this._formatPrice(shippingDiscountWithTaxAmount, commerceCurrency, locale));
            order.setShippingDiscountPercentageLevel1WithTaxAmount(commerceOrder.getShippingDiscountPercentageLevel1WithTaxAmount());
            order.setShippingDiscountPercentageLevel2WithTaxAmount(commerceOrder.getShippingDiscountPercentageLevel2WithTaxAmount());
            order.setShippingDiscountPercentageLevel3WithTaxAmount(commerceOrder.getShippingDiscountPercentageLevel3WithTaxAmount());
            order.setShippingDiscountPercentageLevel4WithTaxAmount(commerceOrder.getShippingDiscountPercentageLevel4WithTaxAmount());
        }
    }

    private void _setOrderSubtotal(CommerceCurrency commerceCurrency, CommerceOrder commerceOrder, Order order, Locale locale) throws Exception {
        BigDecimal subtotalDiscountWithTaxAmount;
        BigDecimal subtotalDiscountAmount;
        CommerceMoney commerceOrderSubtotalWithTaxAmountCommerceMoney;
        CommerceMoney commerceOrderSubtotalCommerceMoney = commerceOrder.getSubtotalMoney();
        if (commerceOrderSubtotalCommerceMoney != null) {
            order.setSubtotalFormatted(commerceOrderSubtotalCommerceMoney.format(locale));
            BigDecimal commerceOrderSubtotalValue = commerceOrderSubtotalCommerceMoney.getPrice();
            if (commerceOrderSubtotalValue != null) {
                order.setSubtotalAmount(Double.valueOf(commerceOrderSubtotalValue.doubleValue()));
            }
        }
        if ((commerceOrderSubtotalWithTaxAmountCommerceMoney = commerceOrder.getSubtotalWithTaxAmountMoney()) != null) {
            order.setSubtotalWithTaxAmountFormatted(commerceOrderSubtotalWithTaxAmountCommerceMoney.format(locale));
            BigDecimal commerceOrderSubtotalWithTaxAmountValue = commerceOrderSubtotalWithTaxAmountCommerceMoney.getPrice();
            if (commerceOrderSubtotalWithTaxAmountValue != null) {
                order.setSubtotalWithTaxAmountValue(Double.valueOf(commerceOrderSubtotalWithTaxAmountValue.doubleValue()));
            }
        }
        if ((subtotalDiscountAmount = commerceOrder.getSubtotalDiscountAmount()) != null) {
            order.setSubtotalDiscountAmount(subtotalDiscountAmount);
            order.setSubtotalDiscountAmountFormatted(this._formatPrice(subtotalDiscountAmount, commerceCurrency, locale));
            order.setSubtotalDiscountPercentageLevel1(commerceOrder.getSubtotalDiscountPercentageLevel1());
            order.setSubtotalDiscountPercentageLevel2(commerceOrder.getSubtotalDiscountPercentageLevel2());
            order.setSubtotalDiscountPercentageLevel3(commerceOrder.getSubtotalDiscountPercentageLevel3());
            order.setSubtotalDiscountPercentageLevel4(commerceOrder.getSubtotalDiscountPercentageLevel4());
        }
        if ((subtotalDiscountWithTaxAmount = commerceOrder.getSubtotalDiscountWithTaxAmount()) != null) {
            order.setSubtotalDiscountWithTaxAmount(subtotalDiscountWithTaxAmount);
            order.setSubtotalDiscountWithTaxAmountFormatted(this._formatPrice(subtotalDiscountWithTaxAmount, commerceCurrency, locale));
            order.setSubtotalDiscountPercentageLevel1WithTaxAmount(commerceOrder.getSubtotalDiscountPercentageLevel1WithTaxAmount());
            order.setSubtotalDiscountPercentageLevel2WithTaxAmount(commerceOrder.getSubtotalDiscountPercentageLevel2WithTaxAmount());
            order.setSubtotalDiscountPercentageLevel3WithTaxAmount(commerceOrder.getSubtotalDiscountPercentageLevel3WithTaxAmount());
            order.setSubtotalDiscountPercentageLevel4WithTaxAmount(commerceOrder.getSubtotalDiscountPercentageLevel4WithTaxAmount());
        }
    }

    private void _setOrderTotal(CommerceCurrency commerceCurrency, CommerceOrder commerceOrder, Order order, Locale locale) throws Exception {
        BigDecimal totalDiscountWithTaxAmount;
        BigDecimal totalDiscountAmount;
        CommerceMoney commerceOrderTotalWithTaxAmountMoney;
        CommerceMoney commerceOrderTotalCommerceMoney = commerceOrder.getTotalMoney();
        if (commerceOrderTotalCommerceMoney != null) {
            order.setTotalFormatted(commerceOrderTotalCommerceMoney.format(locale));
            BigDecimal commerceOrderTotalValue = commerceOrderTotalCommerceMoney.getPrice();
            if (commerceOrderTotalValue != null) {
                order.setTotalAmount(Double.valueOf(commerceOrderTotalValue.doubleValue()));
            }
        }
        if ((commerceOrderTotalWithTaxAmountMoney = commerceOrder.getTotalWithTaxAmountMoney()) != null) {
            order.setTotalWithTaxAmountFormatted(commerceOrderTotalWithTaxAmountMoney.format(locale));
            BigDecimal commerceOrderTotalWithTaxAmountValue = commerceOrderTotalWithTaxAmountMoney.getPrice();
            if (commerceOrderTotalWithTaxAmountValue != null) {
                order.setTotalWithTaxAmountValue(Double.valueOf(commerceOrderTotalWithTaxAmountValue.doubleValue()));
            }
        }
        if ((totalDiscountAmount = commerceOrder.getTotalDiscountAmount()) != null) {
            order.setTotalDiscountAmount(totalDiscountAmount);
            order.setTotalDiscountAmountFormatted(this._formatPrice(totalDiscountAmount, commerceCurrency, locale));
            order.setTotalDiscountPercentageLevel1(commerceOrder.getTotalDiscountPercentageLevel1());
            order.setTotalDiscountPercentageLevel2(commerceOrder.getTotalDiscountPercentageLevel2());
            order.setTotalDiscountPercentageLevel3(commerceOrder.getTotalDiscountPercentageLevel3());
            order.setTotalDiscountPercentageLevel4(commerceOrder.getTotalDiscountPercentageLevel4());
        }
        if ((totalDiscountWithTaxAmount = commerceOrder.getTotalDiscountWithTaxAmount()) != null) {
            order.setTotalDiscountWithTaxAmount(totalDiscountWithTaxAmount);
            order.setTotalDiscountWithTaxAmountFormatted(this._formatPrice(totalDiscountWithTaxAmount, commerceCurrency, locale));
            order.setSubtotalDiscountPercentageLevel1WithTaxAmount(commerceOrder.getTotalDiscountPercentageLevel1WithTaxAmount());
            order.setSubtotalDiscountPercentageLevel2WithTaxAmount(commerceOrder.getTotalDiscountPercentageLevel2WithTaxAmount());
            order.setSubtotalDiscountPercentageLevel3WithTaxAmount(commerceOrder.getTotalDiscountPercentageLevel3WithTaxAmount());
            order.setSubtotalDiscountPercentageLevel4WithTaxAmount(commerceOrder.getTotalDiscountPercentageLevel4WithTaxAmount());
        }
    }

    private Status _toStatus(final int orderStatus, final String commerceOrderWorkflowStatusLabel, final String commerceOrderWorkflowStatusLabelI18n) {
        return new Status(){
            {
                this.code = orderStatus;
                this.label = commerceOrderWorkflowStatusLabel;
                this.label_i18n = commerceOrderWorkflowStatusLabelI18n;
            }
        };
    }
}

