/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.order.internal.util.v1_0;

import com.liferay.commerce.model.CommerceAddress;
import com.liferay.commerce.model.CommerceCountry;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceRegion;
import com.liferay.commerce.service.CommerceAddressService;
import com.liferay.commerce.service.CommerceCountryServiceUtil;
import com.liferay.commerce.service.CommerceOrderService;
import com.liferay.commerce.service.CommerceRegionLocalServiceUtil;
import com.liferay.headless.commerce.admin.order.dto.v1_0.ShippingAddress;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;

public class ShippingAddressUtil {
    public static CommerceOrder upsertShippingAddress(CommerceAddressService commerceAddressService, CommerceOrderService commerceOrderService, CommerceOrder commerceOrder, ShippingAddress shippingAddress, ServiceContext serviceContext) throws Exception {
        if (commerceOrder.getShippingAddressId() > 0L) {
            return ShippingAddressUtil._updateCommerceOrderShippingAddress(commerceAddressService, commerceOrderService, commerceOrder, shippingAddress, serviceContext);
        }
        CommerceAddress commerceAddress = ShippingAddressUtil._addCommerceAddress(commerceAddressService, commerceOrder, shippingAddress, serviceContext);
        return commerceOrderService.updateShippingAddress(commerceOrder.getCommerceOrderId(), commerceAddress.getName(), commerceAddress.getDescription(), commerceAddress.getStreet1(), commerceAddress.getStreet2(), commerceAddress.getStreet3(), commerceAddress.getCity(), commerceAddress.getZip(), commerceAddress.getCommerceRegionId(), commerceAddress.getCommerceCountryId(), commerceAddress.getPhoneNumber(), serviceContext);
    }

    private static CommerceAddress _addCommerceAddress(CommerceAddressService commerceAddressService, CommerceOrder commerceOrder, ShippingAddress shippingAddress, ServiceContext serviceContext) throws Exception {
        CommerceCountry commerceCountry = CommerceCountryServiceUtil.getCommerceCountry((long)commerceOrder.getCompanyId(), (String)shippingAddress.getCountryISOCode());
        return commerceAddressService.addCommerceAddress(commerceOrder.getModelClassName(), commerceOrder.getCommerceOrderId(), shippingAddress.getName(), shippingAddress.getDescription(), shippingAddress.getStreet1(), shippingAddress.getStreet2(), shippingAddress.getStreet3(), shippingAddress.getCity(), shippingAddress.getZip(), ShippingAddressUtil._getCommerceRegionId(null, commerceCountry, shippingAddress), commerceCountry.getCommerceCountryId(), shippingAddress.getPhoneNumber(), false, false, serviceContext);
    }

    private static long _getCommerceCountryId(CommerceCountry commerceCountry) {
        if (commerceCountry == null) {
            return 0L;
        }
        return commerceCountry.getCommerceCountryId();
    }

    private static long _getCommerceRegionId(CommerceAddress commerceAddress, CommerceCountry commerceCountry, ShippingAddress shippingAddress) throws Exception {
        if (Validator.isNull((String)shippingAddress.getRegionISOCode()) && commerceAddress != null) {
            return commerceAddress.getCommerceRegionId();
        }
        if (commerceCountry == null) {
            return 0L;
        }
        CommerceRegion commerceRegion = CommerceRegionLocalServiceUtil.getCommerceRegion((long)commerceCountry.getCommerceCountryId(), (String)shippingAddress.getRegionISOCode());
        return commerceRegion.getCommerceRegionId();
    }

    private static String _getDescription(CommerceAddress commerceAddress) {
        if (commerceAddress == null) {
            return null;
        }
        return commerceAddress.getDescription();
    }

    private static String _getPhoneNumber(CommerceAddress commerceAddress) {
        if (commerceAddress == null) {
            return null;
        }
        return commerceAddress.getPhoneNumber();
    }

    private static String _getStreet2(CommerceAddress commerceAddress) {
        if (commerceAddress == null) {
            return null;
        }
        return commerceAddress.getStreet2();
    }

    private static String _getStreet3(CommerceAddress commerceAddress) {
        if (commerceAddress == null) {
            return null;
        }
        return commerceAddress.getStreet3();
    }

    private static String _getZip(CommerceAddress commerceAddress) {
        if (commerceAddress == null) {
            return null;
        }
        return commerceAddress.getZip();
    }

    private static CommerceOrder _updateCommerceOrderShippingAddress(CommerceAddressService commerceAddressService, CommerceOrderService commerceOrderService, CommerceOrder commerceOrder, ShippingAddress shippingAddress, ServiceContext serviceContext) throws Exception {
        CommerceAddress commerceAddress = commerceAddressService.fetchCommerceAddress(commerceOrder.getShippingAddressId());
        CommerceCountry commerceCountry = null;
        if (commerceAddress != null) {
            commerceCountry = commerceAddress.getCommerceCountry();
        }
        return commerceOrderService.updateShippingAddress(commerceOrder.getCommerceOrderId(), shippingAddress.getName(), GetterUtil.get((String)shippingAddress.getDescription(), (String)ShippingAddressUtil._getDescription(commerceAddress)), shippingAddress.getStreet1(), GetterUtil.get((String)shippingAddress.getStreet2(), (String)ShippingAddressUtil._getStreet2(commerceAddress)), GetterUtil.get((String)shippingAddress.getStreet3(), (String)ShippingAddressUtil._getStreet3(commerceAddress)), shippingAddress.getCity(), GetterUtil.get((String)shippingAddress.getZip(), (String)ShippingAddressUtil._getZip(commerceAddress)), ShippingAddressUtil._getCommerceRegionId(commerceAddress, commerceCountry, shippingAddress), ShippingAddressUtil._getCommerceCountryId(commerceCountry), GetterUtil.get((String)shippingAddress.getPhoneNumber(), (String)ShippingAddressUtil._getPhoneNumber(commerceAddress)), serviceContext);
    }
}

