/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.order.internal.resource.v1_0;

import com.liferay.commerce.context.CommerceContextFactory;
import com.liferay.commerce.exception.NoSuchOrderException;
import com.liferay.commerce.exception.NoSuchOrderItemException;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.product.service.CPInstanceService;
import com.liferay.commerce.service.CommerceOrderItemService;
import com.liferay.commerce.service.CommerceOrderService;
import com.liferay.headless.commerce.admin.order.dto.v1_0.Order;
import com.liferay.headless.commerce.admin.order.dto.v1_0.OrderItem;
import com.liferay.headless.commerce.admin.order.internal.dto.v1_0.converter.OrderItemDTOConverter;
import com.liferay.headless.commerce.admin.order.internal.helper.v1_0.OrderItemHelper;
import com.liferay.headless.commerce.admin.order.internal.resource.v1_0.BaseOrderItemResourceImpl;
import com.liferay.headless.commerce.admin.order.internal.util.v1_0.OrderItemUtil;
import com.liferay.headless.commerce.admin.order.resource.v1_0.OrderItemResource;
import com.liferay.headless.commerce.core.util.ExpandoUtil;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.permission.PortalPermissionUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(enabled=false, properties={"OSGI-INF/liferay/rest/v1_0/order-item.properties"}, scope=ServiceScope.PROTOTYPE, service={OrderItemResource.class})
public class OrderItemResourceImpl
extends BaseOrderItemResourceImpl {
    @Reference
    private CommerceContextFactory _commerceContextFactory;
    @Reference
    private CommerceOrderItemService _commerceOrderItemService;
    @Reference
    private CommerceOrderService _commerceOrderService;
    @Reference
    private CPInstanceService _cpInstanceService;
    @Reference
    private OrderItemDTOConverter _orderItemDTOConverter;
    @Reference
    private OrderItemHelper _orderItemHelper;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    @Override
    public Response deleteOrderItem(Long id) throws Exception {
        CommerceOrderItem commerceOrderItem = this._commerceOrderItemService.getCommerceOrderItem(id.longValue());
        CommerceOrder commerceOrder = this._commerceOrderService.getCommerceOrder(commerceOrderItem.getCommerceOrderId());
        this._commerceOrderItemService.deleteCommerceOrderItem(commerceOrderItem.getCommerceOrderItemId(), this._commerceContextFactory.create(this.contextCompany.getCompanyId(), commerceOrder.getGroupId(), this.contextUser.getUserId(), commerceOrder.getCommerceOrderId(), commerceOrder.getCommerceAccountId()));
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Response deleteOrderItemByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CommerceOrderItem commerceOrderItem = this._commerceOrderItemService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceOrderItem == null) {
            throw new NoSuchOrderItemException("Unable to find OrderItem with externalReferenceCode: " + externalReferenceCode);
        }
        CommerceOrder commerceOrder = this._commerceOrderService.getCommerceOrder(commerceOrderItem.getCommerceOrderId());
        this._commerceOrderItemService.deleteCommerceOrderItem(commerceOrderItem.getCommerceOrderItemId(), this._commerceContextFactory.create(this.contextCompany.getCompanyId(), commerceOrder.getGroupId(), this.contextUser.getUserId(), commerceOrder.getCommerceOrderId(), commerceOrder.getCommerceAccountId()));
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Page<OrderItem> getOrderByExternalReferenceCodeOrderItemsPage(String externalReferenceCode, Pagination pagination) throws Exception {
        CommerceOrder commerceOrder = this._commerceOrderService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceOrder == null) {
            throw new NoSuchOrderException("Unable to find Order with externalReferenceCode: " + externalReferenceCode);
        }
        List commerceOrderItems = this._commerceOrderItemService.getCommerceOrderItems(commerceOrder.getCommerceOrderId(), pagination.getStartPosition(), pagination.getEndPosition());
        int totalItems = this._commerceOrderItemService.getCommerceOrderItemsCount(commerceOrder.getCommerceOrderId());
        return Page.of(this._orderItemHelper.toOrderItems(commerceOrderItems, this.contextAcceptLanguage.getPreferredLocale()), (Pagination)pagination, (long)totalItems);
    }

    @Override
    @NestedField(parentClass=Order.class, value="orderItems")
    public Page<OrderItem> getOrderIdOrderItemsPage(Long id, Pagination pagination) throws Exception {
        return this._orderItemHelper.getOrderItemsPage(id, this.contextAcceptLanguage.getPreferredLocale(), pagination);
    }

    @Override
    public OrderItem getOrderItem(Long id) throws Exception {
        return this._toOrderItem(GetterUtil.getLong((Object)id));
    }

    @Override
    public OrderItem getOrderItemByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CommerceOrderItem commerceOrderItem = this._commerceOrderItemService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceOrderItem == null) {
            throw new NoSuchOrderItemException("Unable to find OrderItem with externalReferenceCode: " + externalReferenceCode);
        }
        return this._toOrderItem(commerceOrderItem.getCommerceOrderItemId());
    }

    @Override
    public Response patchOrderItem(Long id, OrderItem orderItem) throws Exception {
        this._updateOrderItem(this._commerceOrderItemService.getCommerceOrderItem(id.longValue()), orderItem);
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Response patchOrderItemByExternalReferenceCode(String externalReferenceCode, OrderItem orderItem) throws Exception {
        CommerceOrderItem commerceOrderItem = this._commerceOrderItemService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceOrderItem == null) {
            throw new NoSuchOrderItemException("Unable to find OrderItem with externalReferenceCode: " + externalReferenceCode);
        }
        this._updateOrderItem(commerceOrderItem, orderItem);
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public OrderItem postOrderByExternalReferenceCodeOrderItem(String externalReferenceCode, OrderItem orderItem) throws Exception {
        CommerceOrder commerceOrder = this._commerceOrderService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceOrder == null) {
            throw new NoSuchOrderException("Unable to find Order with externalReferenceCode: " + externalReferenceCode);
        }
        return this._upsertOrderItem(commerceOrder, orderItem);
    }

    @Override
    public OrderItem postOrderIdOrderItem(Long id, OrderItem orderItem) throws Exception {
        return this._upsertOrderItem(this._commerceOrderService.getCommerceOrder(id.longValue()), orderItem);
    }

    private OrderItem _toOrderItem(long commerceOrderItemId) throws Exception {
        return this._orderItemDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)commerceOrderItemId, this.contextAcceptLanguage.getPreferredLocale()));
    }

    private OrderItem _updateOrderItem(CommerceOrderItem commerceOrderItem, OrderItem orderItem) throws Exception {
        Map customFields;
        CommerceOrder commerceOrder = this._commerceOrderService.getCommerceOrder(commerceOrderItem.getCommerceOrderId());
        commerceOrderItem = this._commerceOrderItemService.updateCommerceOrderItem(commerceOrderItem.getCommerceOrderItemId(), GetterUtil.get((Object)orderItem.getQuantity(), (int)commerceOrderItem.getQuantity()), this._commerceContextFactory.create(this.contextCompany.getCompanyId(), commerceOrder.getGroupId(), this.contextUser.getUserId(), commerceOrder.getCommerceOrderId(), commerceOrder.getCommerceAccountId()), this._serviceContextHelper.getServiceContext(commerceOrderItem.getGroupId()));
        if (PortalPermissionUtil.contains((PermissionChecker)PermissionThreadLocal.getPermissionChecker(), (String)"MANAGE_COMMERCE_ORDER_PRICES")) {
            commerceOrderItem = this._commerceOrderItemService.updateCommerceOrderItemPrices(commerceOrderItem.getCommerceOrderItemId(), (BigDecimal)GetterUtil.get((Object)orderItem.getUnitPrice(), (Number)commerceOrderItem.getUnitPrice()), (BigDecimal)GetterUtil.get((Object)orderItem.getPromoPrice(), (Number)commerceOrderItem.getPromoPrice()), (BigDecimal)GetterUtil.get((Object)orderItem.getDiscountAmount(), (Number)commerceOrderItem.getDiscountAmount()), (BigDecimal)GetterUtil.get((Object)orderItem.getFinalPrice(), (Number)commerceOrderItem.getFinalPrice()), (BigDecimal)GetterUtil.get((Object)orderItem.getDiscountPercentageLevel1(), (Number)commerceOrderItem.getDiscountPercentageLevel1()), (BigDecimal)GetterUtil.get((Object)orderItem.getDiscountPercentageLevel2(), (Number)commerceOrderItem.getDiscountPercentageLevel2()), (BigDecimal)GetterUtil.get((Object)orderItem.getDiscountPercentageLevel3(), (Number)commerceOrderItem.getDiscountPercentageLevel3()), (BigDecimal)GetterUtil.get((Object)orderItem.getDiscountPercentageLevel4(), (Number)commerceOrderItem.getDiscountPercentageLevel4()), (BigDecimal)GetterUtil.get((Object)orderItem.getUnitPriceWithTaxAmount(), (Number)commerceOrderItem.getUnitPriceWithTaxAmount()), (BigDecimal)GetterUtil.get((Object)orderItem.getPromoPriceWithTaxAmount(), (Number)commerceOrderItem.getPromoPriceWithTaxAmount()), (BigDecimal)GetterUtil.get((Object)orderItem.getDiscountWithTaxAmount(), (Number)commerceOrderItem.getDiscountWithTaxAmount()), (BigDecimal)GetterUtil.get((Object)orderItem.getFinalPriceWithTaxAmount(), (Number)commerceOrderItem.getFinalPriceWithTaxAmount()), (BigDecimal)GetterUtil.get((Object)orderItem.getDiscountPercentageLevel1WithTaxAmount(), (Number)commerceOrderItem.getDiscountPercentageLevel1WithTaxAmount()), (BigDecimal)GetterUtil.get((Object)orderItem.getDiscountPercentageLevel2WithTaxAmount(), (Number)commerceOrderItem.getDiscountPercentageLevel2WithTaxAmount()), (BigDecimal)GetterUtil.get((Object)orderItem.getDiscountPercentageLevel3WithTaxAmount(), (Number)commerceOrderItem.getDiscountPercentageLevel3WithTaxAmount()), (BigDecimal)GetterUtil.get((Object)orderItem.getDiscountPercentageLevel4WithTaxAmount(), (Number)commerceOrderItem.getDiscountPercentageLevel4WithTaxAmount()));
        }
        if ((customFields = orderItem.getCustomFields()) != null && !customFields.isEmpty()) {
            ExpandoUtil.updateExpando((long)this.contextCompany.getCompanyId(), CommerceOrderItem.class, (long)commerceOrderItem.getPrimaryKey(), (Map)customFields);
        }
        return this._toOrderItem(commerceOrderItem.getCommerceOrderItemId());
    }

    private OrderItem _upsertOrderItem(CommerceOrder commerceOrder, OrderItem orderItem) throws Exception {
        Map customFields;
        CommerceOrderItem commerceOrderItem = OrderItemUtil.upsertCommerceOrderItem(this._cpInstanceService, this._commerceOrderItemService, orderItem, commerceOrder, this._commerceContextFactory.create(this.contextCompany.getCompanyId(), commerceOrder.getGroupId(), this.contextUser.getUserId(), commerceOrder.getCommerceOrderId(), commerceOrder.getCommerceAccountId()), this._serviceContextHelper.getServiceContext(commerceOrder.getGroupId()));
        if (PortalPermissionUtil.contains((PermissionChecker)PermissionThreadLocal.getPermissionChecker(), (String)"MANAGE_COMMERCE_ORDER_PRICES")) {
            commerceOrderItem = this._commerceOrderItemService.updateCommerceOrderItemPrices(commerceOrderItem.getCommerceOrderItemId(), (BigDecimal)GetterUtil.get((Object)orderItem.getUnitPrice(), (Number)commerceOrderItem.getUnitPrice()), (BigDecimal)GetterUtil.get((Object)orderItem.getPromoPrice(), (Number)commerceOrderItem.getPromoPrice()), (BigDecimal)GetterUtil.get((Object)orderItem.getDiscountAmount(), (Number)commerceOrderItem.getDiscountAmount()), (BigDecimal)GetterUtil.get((Object)orderItem.getFinalPrice(), (Number)commerceOrderItem.getFinalPrice()), (BigDecimal)GetterUtil.get((Object)orderItem.getDiscountPercentageLevel1(), (Number)commerceOrderItem.getDiscountPercentageLevel1()), (BigDecimal)GetterUtil.get((Object)orderItem.getDiscountPercentageLevel2(), (Number)commerceOrderItem.getDiscountPercentageLevel2()), (BigDecimal)GetterUtil.get((Object)orderItem.getDiscountPercentageLevel3(), (Number)commerceOrderItem.getDiscountPercentageLevel3()), (BigDecimal)GetterUtil.get((Object)orderItem.getDiscountPercentageLevel4(), (Number)commerceOrderItem.getDiscountPercentageLevel4()), (BigDecimal)GetterUtil.get((Object)orderItem.getUnitPriceWithTaxAmount(), (Number)commerceOrderItem.getUnitPriceWithTaxAmount()), (BigDecimal)GetterUtil.get((Object)orderItem.getPromoPriceWithTaxAmount(), (Number)commerceOrderItem.getPromoPriceWithTaxAmount()), (BigDecimal)GetterUtil.get((Object)orderItem.getDiscountWithTaxAmount(), (Number)commerceOrderItem.getDiscountWithTaxAmount()), (BigDecimal)GetterUtil.get((Object)orderItem.getFinalPriceWithTaxAmount(), (Number)commerceOrderItem.getFinalPriceWithTaxAmount()), (BigDecimal)GetterUtil.get((Object)orderItem.getDiscountPercentageLevel1WithTaxAmount(), (Number)commerceOrderItem.getDiscountPercentageLevel1WithTaxAmount()), (BigDecimal)GetterUtil.get((Object)orderItem.getDiscountPercentageLevel2WithTaxAmount(), (Number)commerceOrderItem.getDiscountPercentageLevel2WithTaxAmount()), (BigDecimal)GetterUtil.get((Object)orderItem.getDiscountPercentageLevel3WithTaxAmount(), (Number)commerceOrderItem.getDiscountPercentageLevel3WithTaxAmount()), (BigDecimal)GetterUtil.get((Object)orderItem.getDiscountPercentageLevel4WithTaxAmount(), (Number)commerceOrderItem.getDiscountPercentageLevel4WithTaxAmount()));
        }
        if ((customFields = orderItem.getCustomFields()) != null && !customFields.isEmpty()) {
            ExpandoUtil.updateExpando((long)this.contextCompany.getCompanyId(), CommerceOrderItem.class, (long)commerceOrderItem.getPrimaryKey(), (Map)customFields);
        }
        return this._toOrderItem(commerceOrderItem.getCommerceOrderItemId());
    }
}

