/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.order.internal.helper.v1_0;

import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.service.CommerceOrderItemService;
import com.liferay.commerce.service.CommerceOrderService;
import com.liferay.headless.commerce.admin.order.dto.v1_0.OrderItem;
import com.liferay.headless.commerce.admin.order.internal.dto.v1_0.converter.OrderItemDTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, service={OrderItemHelper.class})
public class OrderItemHelper {
    @Reference
    private CommerceOrderItemService _commerceOrderItemService;
    @Reference
    private CommerceOrderService _commerceOrderService;
    @Reference
    private OrderItemDTOConverter _orderItemDTOConverter;

    public Page<OrderItem> getOrderItemsPage(Long id, Locale locale, Pagination pagination) throws Exception {
        CommerceOrder commerceOrder = this._commerceOrderService.fetchCommerceOrder(id.longValue());
        if (commerceOrder == null) {
            return Page.of(Collections.emptyList());
        }
        List commerceOrderItems = this._commerceOrderItemService.getCommerceOrderItems(id.longValue(), pagination.getStartPosition(), pagination.getEndPosition());
        int totalItems = this._commerceOrderItemService.getCommerceOrderItemsCount(id.longValue());
        return Page.of(this.toOrderItems(commerceOrderItems, locale), (Pagination)pagination, (long)totalItems);
    }

    public List<OrderItem> toOrderItems(List<CommerceOrderItem> commerceOrderItems, Locale locale) throws Exception {
        ArrayList<OrderItem> orderItems = new ArrayList<OrderItem>();
        for (CommerceOrderItem commerceOrderItem : commerceOrderItems) {
            orderItems.add(this._orderItemDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)commerceOrderItem.getCommerceOrderItemId(), locale)));
        }
        return orderItems;
    }
}

