/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.order.internal.dto.v1_0.converter;

import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.service.CommerceOrderItemService;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.headless.commerce.admin.order.dto.v1_0.OrderItem;
import com.liferay.headless.commerce.admin.order.dto.v1_0.ShippingAddress;
import com.liferay.headless.commerce.admin.order.internal.dto.v1_0.converter.ShippingAddressDTOConverter;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, property={"model.class.name=com.liferay.commerce.model.CommerceOrderItem"}, service={DTOConverter.class, OrderItemDTOConverter.class})
public class OrderItemDTOConverter
implements DTOConverter<CommerceOrderItem, OrderItem> {
    @Reference
    private CommerceOrderItemService _commerceOrderItemService;
    @Reference
    private ShippingAddressDTOConverter _shippingAddressDTOConverter;

    public String getContentType() {
        return OrderItem.class.getSimpleName();
    }

    public OrderItem toDTO(final DTOConverterContext dtoConverterContext) throws Exception {
        final CommerceOrderItem commerceOrderItem = this._commerceOrderItemService.getCommerceOrderItem(((Long)dtoConverterContext.getId()).longValue());
        final CommerceOrder commerceOrder = commerceOrderItem.getCommerceOrder();
        final CPInstance cpInstance = commerceOrderItem.fetchCPInstance();
        final ExpandoBridge expandoBridge = commerceOrderItem.getExpandoBridge();
        return new OrderItem(){
            {
                this.bookedQuantityId = commerceOrderItem.getBookedQuantityId();
                this.customFields = expandoBridge.getAttributes();
                this.deliveryGroup = commerceOrderItem.getDeliveryGroup();
                this.discountAmount = commerceOrderItem.getDiscountAmount();
                this.discountPercentageLevel1 = commerceOrderItem.getDiscountPercentageLevel1();
                this.discountPercentageLevel1WithTaxAmount = commerceOrderItem.getDiscountPercentageLevel1WithTaxAmount();
                this.discountPercentageLevel2 = commerceOrderItem.getDiscountPercentageLevel2();
                this.discountPercentageLevel2WithTaxAmount = commerceOrderItem.getDiscountPercentageLevel2WithTaxAmount();
                this.discountPercentageLevel3 = commerceOrderItem.getDiscountPercentageLevel3();
                this.discountPercentageLevel3WithTaxAmount = commerceOrderItem.getDiscountPercentageLevel3WithTaxAmount();
                this.discountPercentageLevel4 = commerceOrderItem.getDiscountPercentageLevel4();
                this.discountPercentageLevel4WithTaxAmount = commerceOrderItem.getDiscountPercentageLevel4WithTaxAmount();
                this.discountWithTaxAmount = commerceOrderItem.getDiscountWithTaxAmount();
                this.externalReferenceCode = commerceOrderItem.getExternalReferenceCode();
                this.finalPrice = commerceOrderItem.getFinalPrice();
                this.finalPriceWithTaxAmount = commerceOrderItem.getFinalPriceWithTaxAmount();
                this.id = commerceOrderItem.getCommerceOrderItemId();
                this.name = LanguageUtils.getLanguageIdMap((Map)commerceOrderItem.getNameMap());
                this.orderExternalReferenceCode = commerceOrder.getExternalReferenceCode();
                this.orderId = commerceOrder.getCommerceOrderId();
                this.printedNote = commerceOrderItem.getPrintedNote();
                this.promoPrice = commerceOrderItem.getPromoPrice();
                this.promoPriceWithTaxAmount = commerceOrderItem.getPromoPriceWithTaxAmount();
                this.quantity = commerceOrderItem.getQuantity();
                this.requestedDeliveryDate = commerceOrderItem.getRequestedDeliveryDate();
                this.shippedQuantity = commerceOrderItem.getShippedQuantity();
                this.shippingAddress = OrderItemDTOConverter.this._getShippingAddress(dtoConverterContext.getLocale(), commerceOrderItem.getShippingAddressId());
                this.shippingAddressId = commerceOrderItem.getShippingAddressId();
                this.sku = commerceOrderItem.getSku();
                this.skuExternalReferenceCode = OrderItemDTOConverter.this._getSkuExternalReferenceCode(cpInstance);
                this.skuId = OrderItemDTOConverter.this._getSkuId(cpInstance);
                this.subscription = commerceOrderItem.isSubscription();
                this.unitPrice = commerceOrderItem.getUnitPrice();
                this.unitPriceWithTaxAmount = commerceOrderItem.getUnitPriceWithTaxAmount();
            }
        };
    }

    private ShippingAddress _getShippingAddress(Locale locale, long shippingAddressId) throws Exception {
        if (shippingAddressId <= 0L) {
            return new ShippingAddress();
        }
        return this._shippingAddressDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)shippingAddressId, locale));
    }

    private String _getSkuExternalReferenceCode(CPInstance cpInstance) {
        if (cpInstance == null) {
            return "";
        }
        return cpInstance.getExternalReferenceCode();
    }

    private Long _getSkuId(CPInstance cpInstance) {
        if (cpInstance == null) {
            return 0L;
        }
        return cpInstance.getCPInstanceId();
    }
}

