/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.order.internal.dto.v1_0.converter;

import com.liferay.commerce.account.model.CommerceAccount;
import com.liferay.commerce.constants.CommerceOrderConstants;
import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.currency.model.CommerceMoney;
import com.liferay.commerce.currency.util.CommercePriceFormatter;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceShippingMethod;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.service.CommerceOrderService;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.headless.commerce.admin.order.dto.v1_0.Order;
import com.liferay.headless.commerce.admin.order.dto.v1_0.Status;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.workflow.WorkflowConstants;
import com.liferay.portal.language.LanguageResources;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import java.math.BigDecimal;
import java.util.Locale;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, property={"model.class.name=com.liferay.commerce.model.CommerceOrder"}, service={DTOConverter.class, OrderDTOConverter.class})
public class OrderDTOConverter
implements DTOConverter<CommerceOrder, Order> {
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private CommerceOrderService _commerceOrderService;
    @Reference
    private CommercePriceFormatter _commercePriceFormatter;

    public String getContentType() {
        return Order.class.getSimpleName();
    }

    public Order toDTO(final DTOConverterContext dtoConverterContext) throws Exception {
        final CommerceOrder commerceOrder = this._commerceOrderService.getCommerceOrder(((Long)dtoConverterContext.getId()).longValue());
        final CommerceAccount commerceAccount = commerceOrder.getCommerceAccount();
        final CommerceCurrency commerceCurrency = commerceOrder.getCommerceCurrency();
        final CommerceShippingMethod commerceShippingMethod = commerceOrder.getCommerceShippingMethod();
        final ExpandoBridge expandoBridge = commerceOrder.getExpandoBridge();
        Locale locale = dtoConverterContext.getLocale();
        ResourceBundle resourceBundle = LanguageResources.getResourceBundle((Locale)locale);
        final String commerceOrderStatusLabel = CommerceOrderConstants.getOrderStatusLabel((int)commerceOrder.getOrderStatus());
        final String commerceOrderStatusLabelI18n = LanguageUtil.get((ResourceBundle)resourceBundle, (String)CommerceOrderConstants.getOrderStatusLabel((int)commerceOrder.getOrderStatus()));
        final String commerceOrderWorkflowStatusLabel = WorkflowConstants.getStatusLabel((int)commerceOrder.getStatus());
        final String commerceOrderWorkflowStatusLabelI18n = LanguageUtil.get((ResourceBundle)resourceBundle, (String)WorkflowConstants.getStatusLabel((int)commerceOrder.getStatus()));
        final String commerceOrderPaymentStatusLabel = CommerceOrderConstants.getPaymentStatusLabel((int)commerceOrder.getPaymentStatus());
        final String commerceOrderPaymentStatusLabelI18n = LanguageUtil.get((ResourceBundle)resourceBundle, (String)CommerceOrderConstants.getPaymentStatusLabel((int)commerceOrder.getPaymentStatus()));
        final CommerceChannel commerceChannel = this._commerceChannelLocalService.getCommerceChannelByOrderGroupId(commerceOrder.getGroupId());
        Order order = new Order(){
            {
                this.accountExternalReferenceCode = commerceAccount.getExternalReferenceCode();
                this.accountId = commerceOrder.getCommerceAccountId();
                this.actions = dtoConverterContext.getActions();
                this.advanceStatus = commerceOrder.getAdvanceStatus();
                this.billingAddressId = commerceOrder.getBillingAddressId();
                this.channelExternalReferenceCode = commerceChannel.getExternalReferenceCode();
                this.channelId = commerceChannel.getCommerceChannelId();
                this.couponCode = commerceOrder.getCouponCode();
                this.createDate = commerceOrder.getCreateDate();
                this.currencyCode = commerceCurrency.getName(dtoConverterContext.getLocale());
                this.customFields = expandoBridge.getAttributes();
                this.externalReferenceCode = commerceOrder.getExternalReferenceCode();
                this.id = commerceOrder.getCommerceOrderId();
                this.lastPriceUpdateDate = commerceOrder.getLastPriceUpdateDate();
                this.modifiedDate = commerceOrder.getModifiedDate();
                this.orderStatus = commerceOrder.getOrderStatus();
                this.orderStatusInfo = OrderDTOConverter.this._getOrderStatusInfo(commerceOrder.getOrderStatus(), commerceOrderStatusLabel, commerceOrderStatusLabelI18n);
                this.paymentMethod = commerceOrder.getCommercePaymentMethodKey();
                this.paymentStatus = commerceOrder.getPaymentStatus();
                this.paymentStatusInfo = OrderDTOConverter.this._getPaymentStatusInfo(commerceOrder.getPaymentStatus(), commerceOrderPaymentStatusLabel, commerceOrderPaymentStatusLabelI18n);
                this.printedNote = commerceOrder.getPrintedNote();
                this.purchaseOrderNumber = commerceOrder.getPurchaseOrderNumber();
                this.requestedDeliveryDate = commerceOrder.getRequestedDeliveryDate();
                this.shippingAddressId = commerceOrder.getShippingAddressId();
                this.shippingMethod = OrderDTOConverter.this._getShippingMethodEngineKey(commerceShippingMethod);
                this.shippingOption = commerceOrder.getShippingOptionName();
                this.transactionId = commerceOrder.getTransactionId();
                this.workflowStatusInfo = OrderDTOConverter.this._getWorkflowStatusInfo(commerceOrder.getStatus(), commerceOrderWorkflowStatusLabel, commerceOrderWorkflowStatusLabelI18n);
            }
        };
        this._setOrderSubtotal(commerceCurrency, commerceOrder, order, locale);
        this._setOrderShipping(commerceCurrency, commerceOrder, order, locale);
        BigDecimal taxAmount = commerceOrder.getTaxAmount();
        if (taxAmount != null) {
            order.setTaxAmount(Double.valueOf(taxAmount.doubleValue()));
            order.setTaxAmountFormatted(this._formatPrice(taxAmount, commerceCurrency, locale));
        }
        this._setOrderTotal(commerceCurrency, commerceOrder, order, locale);
        return order;
    }

    private String _formatPrice(BigDecimal price, CommerceCurrency commerceCurrency, Locale locale) throws Exception {
        if (price == null) {
            price = BigDecimal.ZERO;
        }
        return this._commercePriceFormatter.format(commerceCurrency, price, locale);
    }

    private Status _getOrderStatusInfo(final int orderStatus, final String commerceOrderStatusLabel, final String commerceOrderStatusLabelI18n) {
        return new Status(){
            {
                this.code = orderStatus;
                this.label = commerceOrderStatusLabel;
                this.label_i18n = commerceOrderStatusLabelI18n;
            }
        };
    }

    private Status _getPaymentStatusInfo(final int paymentStatus, final String commerceOrderPaymentStatusLabel, final String commerceOrderPaymentStatusLabelI18n) {
        return new Status(){
            {
                this.code = paymentStatus;
                this.label = commerceOrderPaymentStatusLabel;
                this.label_i18n = commerceOrderPaymentStatusLabelI18n;
            }
        };
    }

    private String _getShippingMethodEngineKey(CommerceShippingMethod commerceShippingMethod) {
        if (commerceShippingMethod == null) {
            return null;
        }
        return commerceShippingMethod.getEngineKey();
    }

    private Status _getWorkflowStatusInfo(final int orderStatus, final String commerceOrderWorkflowStatusLabel, final String commerceOrderWorkflowStatusLabelI18n) {
        return new Status(){
            {
                this.code = orderStatus;
                this.label = commerceOrderWorkflowStatusLabel;
                this.label_i18n = commerceOrderWorkflowStatusLabelI18n;
            }
        };
    }

    private void _setOrderShipping(CommerceCurrency commerceCurrency, CommerceOrder commerceOrder, Order order, Locale locale) throws Exception {
        BigDecimal shippingDiscountWithTaxAmount;
        BigDecimal shippingDiscountAmount;
        CommerceMoney commerceOrderShippingWithTaxAmountMoney;
        CommerceMoney commerceOrderShippingAmountMoney = commerceOrder.getShippingMoney();
        order.setShippingAmountFormatted(commerceOrderShippingAmountMoney.format(locale));
        BigDecimal commerceOrderShippingValue = commerceOrderShippingAmountMoney.getPrice();
        if (commerceOrderShippingValue != null) {
            order.setShippingAmountValue(Double.valueOf(commerceOrderShippingValue.doubleValue()));
        }
        if ((commerceOrderShippingWithTaxAmountMoney = commerceOrder.getShippingWithTaxAmountMoney()) != null) {
            order.setShippingWithTaxAmountFormatted(commerceOrderShippingWithTaxAmountMoney.format(locale));
            BigDecimal commerceOrderShippingWithTaxAmountValue = commerceOrderShippingWithTaxAmountMoney.getPrice();
            if (commerceOrderShippingWithTaxAmountValue != null) {
                order.setShippingWithTaxAmountValue(Double.valueOf(commerceOrderShippingWithTaxAmountValue.doubleValue()));
            }
        }
        if ((shippingDiscountAmount = commerceOrder.getShippingDiscountAmount()) != null) {
            order.setShippingDiscountAmount(Double.valueOf(shippingDiscountAmount.doubleValue()));
            order.setShippingDiscountAmountFormatted(this._formatPrice(shippingDiscountAmount, commerceCurrency, locale));
            BigDecimal shippingDiscountPercentageLevel1 = commerceOrder.getShippingDiscountPercentageLevel1();
            order.setShippingDiscountPercentageLevel1(Double.valueOf(shippingDiscountPercentageLevel1.doubleValue()));
            BigDecimal shippingDiscountPercentageLevel2 = commerceOrder.getShippingDiscountPercentageLevel2();
            order.setShippingDiscountPercentageLevel2(Double.valueOf(shippingDiscountPercentageLevel2.doubleValue()));
            BigDecimal shippingDiscountPercentageLevel3 = commerceOrder.getShippingDiscountPercentageLevel3();
            order.setShippingDiscountPercentageLevel3(Double.valueOf(shippingDiscountPercentageLevel3.doubleValue()));
            BigDecimal shippingDiscountPercentageLevel4 = commerceOrder.getShippingDiscountPercentageLevel4();
            order.setShippingDiscountPercentageLevel4(Double.valueOf(shippingDiscountPercentageLevel4.doubleValue()));
        }
        if ((shippingDiscountWithTaxAmount = commerceOrder.getShippingDiscountWithTaxAmount()) != null) {
            order.setShippingDiscountWithTaxAmount(Double.valueOf(shippingDiscountWithTaxAmount.doubleValue()));
            order.setShippingDiscountWithTaxAmountFormatted(this._formatPrice(shippingDiscountWithTaxAmount, commerceCurrency, locale));
            BigDecimal shippingDiscountPercentageLevel1WithTaxAmount = commerceOrder.getShippingDiscountPercentageLevel1WithTaxAmount();
            order.setShippingDiscountPercentageLevel1WithTaxAmount(Double.valueOf(shippingDiscountPercentageLevel1WithTaxAmount.doubleValue()));
            BigDecimal shippingDiscountPercentageLevel2WithTaxAmount = commerceOrder.getShippingDiscountPercentageLevel2WithTaxAmount();
            order.setShippingDiscountPercentageLevel2WithTaxAmount(Double.valueOf(shippingDiscountPercentageLevel2WithTaxAmount.doubleValue()));
            BigDecimal shippingDiscountPercentageLevel3WithTaxAmount = commerceOrder.getShippingDiscountPercentageLevel3WithTaxAmount();
            order.setShippingDiscountPercentageLevel3WithTaxAmount(Double.valueOf(shippingDiscountPercentageLevel3WithTaxAmount.doubleValue()));
            BigDecimal shippingDiscountPercentageLevel4WithTaxAmount = commerceOrder.getShippingDiscountPercentageLevel4WithTaxAmount();
            order.setShippingDiscountPercentageLevel4WithTaxAmount(Double.valueOf(shippingDiscountPercentageLevel4WithTaxAmount.doubleValue()));
        }
    }

    private void _setOrderSubtotal(CommerceCurrency commerceCurrency, CommerceOrder commerceOrder, Order order, Locale locale) throws Exception {
        BigDecimal subtotalDiscountWithTaxAmount;
        BigDecimal subtotalDiscountAmount;
        CommerceMoney commerceOrderSubtotalWithTaxAmountMoney;
        CommerceMoney commerceOrderSubtotalMoney = commerceOrder.getSubtotalMoney();
        if (commerceOrderSubtotalMoney != null) {
            order.setSubtotalFormatted(commerceOrderSubtotalMoney.format(locale));
            BigDecimal commerceOrderSubtotalValue = commerceOrderSubtotalMoney.getPrice();
            if (commerceOrderSubtotalValue != null) {
                order.setSubtotalAmount(Double.valueOf(commerceOrderSubtotalValue.doubleValue()));
            }
        }
        if ((commerceOrderSubtotalWithTaxAmountMoney = commerceOrder.getSubtotalWithTaxAmountMoney()) != null) {
            order.setSubtotalWithTaxAmountFormatted(commerceOrderSubtotalWithTaxAmountMoney.format(locale));
            BigDecimal commerceOrderSubtotalWithTaxAmountValue = commerceOrderSubtotalWithTaxAmountMoney.getPrice();
            if (commerceOrderSubtotalWithTaxAmountValue != null) {
                order.setSubtotalWithTaxAmountValue(Double.valueOf(commerceOrderSubtotalWithTaxAmountValue.doubleValue()));
            }
        }
        if ((subtotalDiscountAmount = commerceOrder.getSubtotalDiscountAmount()) != null) {
            order.setSubtotalDiscountAmount(Double.valueOf(subtotalDiscountAmount.doubleValue()));
            order.setSubtotalDiscountAmountFormatted(this._formatPrice(subtotalDiscountAmount, commerceCurrency, locale));
            BigDecimal subtotalDiscountPercentageLevel1 = commerceOrder.getSubtotalDiscountPercentageLevel1();
            order.setSubtotalDiscountPercentageLevel1(Double.valueOf(subtotalDiscountPercentageLevel1.doubleValue()));
            BigDecimal subtotalDiscountPercentageLevel2 = commerceOrder.getSubtotalDiscountPercentageLevel2();
            order.setSubtotalDiscountPercentageLevel2(Double.valueOf(subtotalDiscountPercentageLevel2.doubleValue()));
            BigDecimal subtotalDiscountPercentageLevel3 = commerceOrder.getSubtotalDiscountPercentageLevel3();
            order.setSubtotalDiscountPercentageLevel3(Double.valueOf(subtotalDiscountPercentageLevel3.doubleValue()));
            BigDecimal subtotalDiscountPercentageLevel4 = commerceOrder.getSubtotalDiscountPercentageLevel4();
            order.setSubtotalDiscountPercentageLevel4(Double.valueOf(subtotalDiscountPercentageLevel4.doubleValue()));
        }
        if ((subtotalDiscountWithTaxAmount = commerceOrder.getSubtotalDiscountWithTaxAmount()) != null) {
            order.setSubtotalDiscountWithTaxAmount(Double.valueOf(subtotalDiscountWithTaxAmount.doubleValue()));
            order.setSubtotalDiscountWithTaxAmountFormatted(this._formatPrice(subtotalDiscountWithTaxAmount, commerceCurrency, locale));
            BigDecimal subtotalDiscountPercentageLevel1WithTaxAmount = commerceOrder.getSubtotalDiscountPercentageLevel1WithTaxAmount();
            order.setSubtotalDiscountPercentageLevel1WithTaxAmount(Double.valueOf(subtotalDiscountPercentageLevel1WithTaxAmount.doubleValue()));
            BigDecimal subtotalDiscountPercentageLevel2WithTaxAmount = commerceOrder.getSubtotalDiscountPercentageLevel2WithTaxAmount();
            order.setSubtotalDiscountPercentageLevel2WithTaxAmount(Double.valueOf(subtotalDiscountPercentageLevel2WithTaxAmount.doubleValue()));
            BigDecimal subtotalDiscountPercentageLevel3WithTaxAmount = commerceOrder.getSubtotalDiscountPercentageLevel3WithTaxAmount();
            order.setSubtotalDiscountPercentageLevel3WithTaxAmount(Double.valueOf(subtotalDiscountPercentageLevel3WithTaxAmount.doubleValue()));
            BigDecimal subtotalDiscountPercentageLevel4WithTaxAmount = commerceOrder.getSubtotalDiscountPercentageLevel4WithTaxAmount();
            order.setSubtotalDiscountPercentageLevel4WithTaxAmount(Double.valueOf(subtotalDiscountPercentageLevel4WithTaxAmount.doubleValue()));
        }
    }

    private void _setOrderTotal(CommerceCurrency commerceCurrency, CommerceOrder commerceOrder, Order order, Locale locale) throws Exception {
        BigDecimal totalDiscountWithTaxAmount;
        BigDecimal totalDiscountAmount;
        CommerceMoney commerceOrderTotalWithTaxAmountMoney;
        CommerceMoney commerceOrderTotalMoney = commerceOrder.getTotalMoney();
        if (commerceOrderTotalMoney != null) {
            order.setTotalFormatted(commerceOrderTotalMoney.format(locale));
            BigDecimal commerceOrderTotalValue = commerceOrderTotalMoney.getPrice();
            if (commerceOrderTotalValue != null) {
                order.setTotalAmount(Double.valueOf(commerceOrderTotalValue.doubleValue()));
            }
        }
        if ((commerceOrderTotalWithTaxAmountMoney = commerceOrder.getTotalWithTaxAmountMoney()) != null) {
            order.setTotalWithTaxAmountFormatted(commerceOrderTotalWithTaxAmountMoney.format(locale));
            BigDecimal commerceOrderTotalWithTaxAmountValue = commerceOrderTotalWithTaxAmountMoney.getPrice();
            if (commerceOrderTotalWithTaxAmountValue != null) {
                order.setTotalWithTaxAmountValue(Double.valueOf(commerceOrderTotalWithTaxAmountValue.doubleValue()));
            }
        }
        if ((totalDiscountAmount = commerceOrder.getTotalDiscountAmount()) != null) {
            order.setTotalDiscountAmount(Double.valueOf(totalDiscountAmount.doubleValue()));
            order.setTotalDiscountAmountFormatted(this._formatPrice(totalDiscountAmount, commerceCurrency, locale));
            BigDecimal totalDiscountPercentageLevel1 = commerceOrder.getTotalDiscountPercentageLevel1();
            order.setTotalDiscountPercentageLevel1(Double.valueOf(totalDiscountPercentageLevel1.doubleValue()));
            BigDecimal totalDiscountPercentageLevel2 = commerceOrder.getTotalDiscountPercentageLevel2();
            order.setTotalDiscountPercentageLevel2(Double.valueOf(totalDiscountPercentageLevel2.doubleValue()));
            BigDecimal totalDiscountPercentageLevel3 = commerceOrder.getTotalDiscountPercentageLevel3();
            order.setTotalDiscountPercentageLevel3(Double.valueOf(totalDiscountPercentageLevel3.doubleValue()));
            BigDecimal totalDiscountPercentageLevel4 = commerceOrder.getTotalDiscountPercentageLevel4();
            order.setTotalDiscountPercentageLevel4(Double.valueOf(totalDiscountPercentageLevel4.doubleValue()));
        }
        if ((totalDiscountWithTaxAmount = commerceOrder.getTotalDiscountWithTaxAmount()) != null) {
            order.setTotalDiscountWithTaxAmount(Double.valueOf(totalDiscountWithTaxAmount.doubleValue()));
            order.setTotalDiscountWithTaxAmountFormatted(this._formatPrice(totalDiscountWithTaxAmount, commerceCurrency, locale));
            BigDecimal totalDiscountPercentageLevel1WithTaxAmount = commerceOrder.getTotalDiscountPercentageLevel1WithTaxAmount();
            order.setSubtotalDiscountPercentageLevel1WithTaxAmount(Double.valueOf(totalDiscountPercentageLevel1WithTaxAmount.doubleValue()));
            BigDecimal totalDiscountPercentageLevel2WithTaxAmount = commerceOrder.getTotalDiscountPercentageLevel2WithTaxAmount();
            order.setSubtotalDiscountPercentageLevel2WithTaxAmount(Double.valueOf(totalDiscountPercentageLevel2WithTaxAmount.doubleValue()));
            BigDecimal totalDiscountPercentageLevel3WithTaxAmount = commerceOrder.getTotalDiscountPercentageLevel3WithTaxAmount();
            order.setSubtotalDiscountPercentageLevel3WithTaxAmount(Double.valueOf(totalDiscountPercentageLevel3WithTaxAmount.doubleValue()));
            BigDecimal totalDiscountPercentageLevel4WithTaxAmount = commerceOrder.getTotalDiscountPercentageLevel4WithTaxAmount();
            order.setSubtotalDiscountPercentageLevel4WithTaxAmount(Double.valueOf(totalDiscountPercentageLevel4WithTaxAmount.doubleValue()));
        }
    }
}

