/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.order.internal.dto.v1_0.converter;

import com.liferay.commerce.model.CommerceAddress;
import com.liferay.commerce.model.CommerceCountry;
import com.liferay.commerce.model.CommerceRegion;
import com.liferay.commerce.service.CommerceAddressService;
import com.liferay.headless.commerce.admin.order.dto.v1_0.BillingAddress;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, property={"model.class.name=BillingAddress"}, service={BillingAddressDTOConverter.class, DTOConverter.class})
public class BillingAddressDTOConverter
implements DTOConverter<CommerceAddress, BillingAddress> {
    @Reference
    private CommerceAddressService _commerceAddressService;

    public String getContentType() {
        return BillingAddress.class.getSimpleName();
    }

    public BillingAddress toDTO(DTOConverterContext dtoConverterContext) throws Exception {
        final CommerceAddress commerceAddress = this._commerceAddressService.getCommerceAddress(((Long)dtoConverterContext.getId()).longValue());
        final CommerceCountry commerceCountry = commerceAddress.getCommerceCountry();
        return new BillingAddress(){
            {
                this.city = commerceAddress.getCity();
                this.countryISOCode = commerceCountry.getTwoLettersISOCode();
                this.description = commerceAddress.getDescription();
                this.externalReferenceCode = commerceAddress.getExternalReferenceCode();
                this.id = commerceAddress.getCommerceAddressId();
                this.latitude = commerceAddress.getLatitude();
                this.longitude = commerceAddress.getLongitude();
                this.name = commerceAddress.getName();
                this.phoneNumber = commerceAddress.getPhoneNumber();
                this.regionISOCode = BillingAddressDTOConverter.this._getRegionISOCode(commerceAddress);
                this.street1 = commerceAddress.getStreet1();
                this.street2 = commerceAddress.getStreet2();
                this.street3 = commerceAddress.getStreet3();
                this.zip = commerceAddress.getZip();
            }
        };
    }

    private String _getRegionISOCode(CommerceAddress commerceAddress) throws Exception {
        CommerceRegion commerceRegion = commerceAddress.getCommerceRegion();
        if (commerceRegion == null) {
            return "";
        }
        return commerceRegion.getCode();
    }
}

