/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.order.client.serdes.v1_0;

import com.liferay.headless.commerce.admin.order.client.dto.v1_0.Account;
import com.liferay.headless.commerce.admin.order.client.json.BaseJSONParser;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;

public class AccountSerDes {
    public static Account toDTO(String json) {
        AccountJSONParser accountJSONParser = new AccountJSONParser();
        return (Account)accountJSONParser.parseToDTO(json);
    }

    public static Account[] toDTOs(String json) {
        AccountJSONParser accountJSONParser = new AccountJSONParser();
        return (Account[])accountJSONParser.parseToDTOs(json);
    }

    public static String toJSON(Account account) {
        if (account == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (account.getCustomFields() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"customFields\": ");
            sb.append(AccountSerDes._toJSON(account.getCustomFields()));
        }
        if (account.getEmailAddress() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"emailAddress\": ");
            sb.append("\"");
            sb.append(AccountSerDes._escape(account.getEmailAddress()));
            sb.append("\"");
        }
        if (account.getExternalReferenceCode() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"externalReferenceCode\": ");
            sb.append("\"");
            sb.append(AccountSerDes._escape(account.getExternalReferenceCode()));
            sb.append("\"");
        }
        if (account.getId() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"id\": ");
            sb.append(account.getId());
        }
        if (account.getLogoId() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"logoId\": ");
            sb.append(account.getLogoId());
        }
        if (account.getName() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"name\": ");
            sb.append("\"");
            sb.append(AccountSerDes._escape(account.getName()));
            sb.append("\"");
        }
        if (account.getRoot() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"root\": ");
            sb.append(account.getRoot());
        }
        if (account.getTaxId() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"taxId\": ");
            sb.append("\"");
            sb.append(AccountSerDes._escape(account.getTaxId()));
            sb.append("\"");
        }
        if (account.getType() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"type\": ");
            sb.append(account.getType());
        }
        sb.append("}");
        return sb.toString();
    }

    public static Map<String, Object> toMap(String json) {
        AccountJSONParser accountJSONParser = new AccountJSONParser();
        return accountJSONParser.parseToMap(json);
    }

    public static Map<String, String> toMap(Account account) {
        if (account == null) {
            return null;
        }
        TreeMap<String, String> map = new TreeMap<String, String>();
        if (account.getCustomFields() == null) {
            map.put("customFields", null);
        } else {
            map.put("customFields", String.valueOf(account.getCustomFields()));
        }
        if (account.getEmailAddress() == null) {
            map.put("emailAddress", null);
        } else {
            map.put("emailAddress", String.valueOf(account.getEmailAddress()));
        }
        if (account.getExternalReferenceCode() == null) {
            map.put("externalReferenceCode", null);
        } else {
            map.put("externalReferenceCode", String.valueOf(account.getExternalReferenceCode()));
        }
        if (account.getId() == null) {
            map.put("id", null);
        } else {
            map.put("id", String.valueOf(account.getId()));
        }
        if (account.getLogoId() == null) {
            map.put("logoId", null);
        } else {
            map.put("logoId", String.valueOf(account.getLogoId()));
        }
        if (account.getName() == null) {
            map.put("name", null);
        } else {
            map.put("name", String.valueOf(account.getName()));
        }
        if (account.getRoot() == null) {
            map.put("root", null);
        } else {
            map.put("root", String.valueOf(account.getRoot()));
        }
        if (account.getTaxId() == null) {
            map.put("taxId", null);
        } else {
            map.put("taxId", String.valueOf(account.getTaxId()));
        }
        if (account.getType() == null) {
            map.put("type", null);
        } else {
            map.put("type", String.valueOf(account.getType()));
        }
        return map;
    }

    private static String _escape(Object object) {
        String string = String.valueOf(object);
        for (String[] strings : BaseJSONParser.JSON_ESCAPE_STRINGS) {
            string = string.replace(strings[0], strings[1]);
        }
        return string;
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(entry.getKey());
            sb.append("\":");
            Object value = entry.getValue();
            Class<?> valueClass = value.getClass();
            if (value instanceof Map) {
                sb.append(AccountSerDes._toJSON((Map)value));
            } else if (valueClass.isArray()) {
                Object[] values = (Object[])value;
                sb.append("[");
                for (int i = 0; i < values.length; ++i) {
                    sb.append("\"");
                    sb.append(AccountSerDes._escape(values[i]));
                    sb.append("\"");
                    if (i + 1 >= values.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(AccountSerDes._escape(entry.getValue()));
                sb.append("\"");
            } else {
                sb.append(String.valueOf(entry.getValue()));
            }
            if (!iterator.hasNext()) continue;
            sb.append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public static class AccountJSONParser
    extends BaseJSONParser<Account> {
        @Override
        protected Account createDTO() {
            return new Account();
        }

        protected Account[] createDTOArray(int size) {
            return new Account[size];
        }

        @Override
        protected void setField(Account account, String jsonParserFieldName, Object jsonParserFieldValue) {
            if (Objects.equals(jsonParserFieldName, "customFields")) {
                if (jsonParserFieldValue != null) {
                    account.setCustomFields(AccountSerDes.toMap((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "emailAddress")) {
                if (jsonParserFieldValue != null) {
                    account.setEmailAddress((String)jsonParserFieldValue);
                }
            } else if (Objects.equals(jsonParserFieldName, "externalReferenceCode")) {
                if (jsonParserFieldValue != null) {
                    account.setExternalReferenceCode((String)jsonParserFieldValue);
                }
            } else if (Objects.equals(jsonParserFieldName, "id")) {
                if (jsonParserFieldValue != null) {
                    account.setId(Long.valueOf((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "logoId")) {
                if (jsonParserFieldValue != null) {
                    account.setLogoId(Long.valueOf((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "name")) {
                if (jsonParserFieldValue != null) {
                    account.setName((String)jsonParserFieldValue);
                }
            } else if (Objects.equals(jsonParserFieldName, "root")) {
                if (jsonParserFieldValue != null) {
                    account.setRoot((Boolean)jsonParserFieldValue);
                }
            } else if (Objects.equals(jsonParserFieldName, "taxId")) {
                if (jsonParserFieldValue != null) {
                    account.setTaxId((String)jsonParserFieldValue);
                }
            } else if (Objects.equals(jsonParserFieldName, "type")) {
                if (jsonParserFieldValue != null) {
                    account.setType(Integer.valueOf((String)jsonParserFieldValue));
                }
            } else if (jsonParserFieldName.equals("status")) {
                throw new IllegalArgumentException();
            }
        }
    }
}

