/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.order.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.validation.constraints.DecimalMin;
import javax.xml.bind.annotation.XmlRootElement;

@GraphQLName(value="OrderNote")
@JsonFilter(value="Liferay.Vulcan")
@XmlRootElement(name="OrderNote")
public class OrderNote
implements Serializable {
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String author;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String content;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String externalReferenceCode;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Long id;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String orderExternalReferenceCode;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Long orderId;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Boolean restricted;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.commerce.admin.order.dto.v1_0.OrderNote", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};

    public static OrderNote toDTO(String json) {
        return (OrderNote)ObjectMapperUtil.readValue(OrderNote.class, (String)json);
    }

    public static OrderNote unsafeToDTO(String json) {
        return (OrderNote)ObjectMapperUtil.unsafeReadValue(OrderNote.class, (String)json);
    }

    @Schema(example="Alessio Antonio Rendina")
    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    @JsonIgnore
    public void setAuthor(UnsafeSupplier<String, Exception> authorUnsafeSupplier) {
        try {
            this.author = (String)authorUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(example="This order will be shipped separately")
    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    @JsonIgnore
    public void setContent(UnsafeSupplier<String, Exception> contentUnsafeSupplier) {
        try {
            this.content = (String)contentUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(example="AB-34098-789-N")
    public String getExternalReferenceCode() {
        return this.externalReferenceCode;
    }

    public void setExternalReferenceCode(String externalReferenceCode) {
        this.externalReferenceCode = externalReferenceCode;
    }

    @JsonIgnore
    public void setExternalReferenceCode(UnsafeSupplier<String, Exception> externalReferenceCodeUnsafeSupplier) {
        try {
            this.externalReferenceCode = (String)externalReferenceCodeUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @DecimalMin(value="0")
    @Schema(example="30130")
    public @DecimalMin(value="0") Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @JsonIgnore
    public void setId(UnsafeSupplier<Long, Exception> idUnsafeSupplier) {
        try {
            this.id = (Long)idUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(example="CAB-34098-789-N")
    public String getOrderExternalReferenceCode() {
        return this.orderExternalReferenceCode;
    }

    public void setOrderExternalReferenceCode(String orderExternalReferenceCode) {
        this.orderExternalReferenceCode = orderExternalReferenceCode;
    }

    @JsonIgnore
    public void setOrderExternalReferenceCode(UnsafeSupplier<String, Exception> orderExternalReferenceCodeUnsafeSupplier) {
        try {
            this.orderExternalReferenceCode = (String)orderExternalReferenceCodeUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @DecimalMin(value="0")
    @Schema(example="30128")
    public @DecimalMin(value="0") Long getOrderId() {
        return this.orderId;
    }

    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }

    @JsonIgnore
    public void setOrderId(UnsafeSupplier<Long, Exception> orderIdUnsafeSupplier) {
        try {
            this.orderId = (Long)orderIdUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(example="true")
    public Boolean getRestricted() {
        return this.restricted;
    }

    public void setRestricted(Boolean restricted) {
        this.restricted = restricted;
    }

    @JsonIgnore
    public void setRestricted(UnsafeSupplier<Boolean, Exception> restrictedUnsafeSupplier) {
        try {
            this.restricted = (Boolean)restrictedUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof OrderNote)) {
            return false;
        }
        OrderNote orderNote = (OrderNote)object;
        return Objects.equals(this.toString(), orderNote.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        StringBundler sb = new StringBundler();
        sb.append("{");
        if (this.author != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"author\": ");
            sb.append("\"");
            sb.append(OrderNote._escape(this.author));
            sb.append("\"");
        }
        if (this.content != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"content\": ");
            sb.append("\"");
            sb.append(OrderNote._escape(this.content));
            sb.append("\"");
        }
        if (this.externalReferenceCode != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"externalReferenceCode\": ");
            sb.append("\"");
            sb.append(OrderNote._escape(this.externalReferenceCode));
            sb.append("\"");
        }
        if (this.id != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"id\": ");
            sb.append((Object)this.id);
        }
        if (this.orderExternalReferenceCode != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"orderExternalReferenceCode\": ");
            sb.append("\"");
            sb.append(OrderNote._escape(this.orderExternalReferenceCode));
            sb.append("\"");
        }
        if (this.orderId != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"orderId\": ");
            sb.append((Object)this.orderId);
        }
        if (this.restricted != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"restricted\": ");
            sb.append((Object)this.restricted);
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(OrderNote._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (OrderNote._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(OrderNote._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(OrderNote._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }
}

