/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.order.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.liferay.headless.commerce.admin.order.dto.v1_0.CustomField;
import com.liferay.headless.commerce.admin.order.dto.v1_0.ShippingAddress;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.DecimalMin;
import javax.xml.bind.annotation.XmlRootElement;

@GraphQLName(value="OrderItem")
@JsonFilter(value="Liferay.Vulcan")
@XmlRootElement(name="OrderItem")
public class OrderItem
implements Serializable {
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Long bookedQuantityId;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected CustomField[] customFields;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected BigDecimal decimalQuantity;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String deliveryGroup;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected BigDecimal discountAmount;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected BigDecimal discountPercentageLevel1;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected BigDecimal discountPercentageLevel1WithTaxAmount;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected BigDecimal discountPercentageLevel2;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected BigDecimal discountPercentageLevel2WithTaxAmount;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected BigDecimal discountPercentageLevel3;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected BigDecimal discountPercentageLevel3WithTaxAmount;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected BigDecimal discountPercentageLevel4;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected BigDecimal discountPercentageLevel4WithTaxAmount;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected BigDecimal discountWithTaxAmount;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String externalReferenceCode;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected BigDecimal finalPrice;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected BigDecimal finalPriceWithTaxAmount;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected String formattedQuantity;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Long id;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Map<String, String> name;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String options;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String orderExternalReferenceCode;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Long orderId;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String printedNote;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected BigDecimal promoPrice;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected BigDecimal promoPriceWithTaxAmount;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Integer quantity;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Date requestedDeliveryDate;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Integer shippedQuantity;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected ShippingAddress shippingAddress;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Long shippingAddressId;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String sku;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String skuExternalReferenceCode;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Long skuId;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Boolean subscription;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String unitOfMeasure;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected BigDecimal unitPrice;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected BigDecimal unitPriceWithTaxAmount;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.commerce.admin.order.dto.v1_0.OrderItem", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};

    public static OrderItem toDTO(String json) {
        return (OrderItem)ObjectMapperUtil.readValue(OrderItem.class, (String)json);
    }

    public static OrderItem unsafeToDTO(String json) {
        return (OrderItem)ObjectMapperUtil.unsafeReadValue(OrderItem.class, (String)json);
    }

    @DecimalMin(value="0")
    @Schema(example="32144")
    public @DecimalMin(value="0") Long getBookedQuantityId() {
        return this.bookedQuantityId;
    }

    public void setBookedQuantityId(Long bookedQuantityId) {
        this.bookedQuantityId = bookedQuantityId;
    }

    @JsonIgnore
    public void setBookedQuantityId(UnsafeSupplier<Long, Exception> bookedQuantityIdUnsafeSupplier) {
        try {
            this.bookedQuantityId = (Long)bookedQuantityIdUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema
    @Valid
    public CustomField[] getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(CustomField[] customFields) {
        this.customFields = customFields;
    }

    @JsonIgnore
    public void setCustomFields(UnsafeSupplier<CustomField[], Exception> customFieldsUnsafeSupplier) {
        try {
            this.customFields = (CustomField[])customFieldsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @DecimalMin(value="0")
    @Schema(example="10.1")
    @Valid
    public @DecimalMin(value="0") @Valid BigDecimal getDecimalQuantity() {
        return this.decimalQuantity;
    }

    public void setDecimalQuantity(BigDecimal decimalQuantity) {
        this.decimalQuantity = decimalQuantity;
    }

    @JsonIgnore
    public void setDecimalQuantity(UnsafeSupplier<BigDecimal, Exception> decimalQuantityUnsafeSupplier) {
        try {
            this.decimalQuantity = (BigDecimal)decimalQuantityUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(example="separate package")
    public String getDeliveryGroup() {
        return this.deliveryGroup;
    }

    public void setDeliveryGroup(String deliveryGroup) {
        this.deliveryGroup = deliveryGroup;
    }

    @JsonIgnore
    public void setDeliveryGroup(UnsafeSupplier<String, Exception> deliveryGroupUnsafeSupplier) {
        try {
            this.deliveryGroup = (String)deliveryGroupUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @DecimalMin(value="0")
    @Schema(example="2")
    @Valid
    public @DecimalMin(value="0") @Valid BigDecimal getDiscountAmount() {
        return this.discountAmount;
    }

    public void setDiscountAmount(BigDecimal discountAmount) {
        this.discountAmount = discountAmount;
    }

    @JsonIgnore
    public void setDiscountAmount(UnsafeSupplier<BigDecimal, Exception> discountAmountUnsafeSupplier) {
        try {
            this.discountAmount = (BigDecimal)discountAmountUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @DecimalMin(value="0")
    @Schema(example="20")
    @Valid
    public @DecimalMin(value="0") @Valid BigDecimal getDiscountPercentageLevel1() {
        return this.discountPercentageLevel1;
    }

    public void setDiscountPercentageLevel1(BigDecimal discountPercentageLevel1) {
        this.discountPercentageLevel1 = discountPercentageLevel1;
    }

    @JsonIgnore
    public void setDiscountPercentageLevel1(UnsafeSupplier<BigDecimal, Exception> discountPercentageLevel1UnsafeSupplier) {
        try {
            this.discountPercentageLevel1 = (BigDecimal)discountPercentageLevel1UnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @DecimalMin(value="0")
    @Schema(example="20")
    @Valid
    public @DecimalMin(value="0") @Valid BigDecimal getDiscountPercentageLevel1WithTaxAmount() {
        return this.discountPercentageLevel1WithTaxAmount;
    }

    public void setDiscountPercentageLevel1WithTaxAmount(BigDecimal discountPercentageLevel1WithTaxAmount) {
        this.discountPercentageLevel1WithTaxAmount = discountPercentageLevel1WithTaxAmount;
    }

    @JsonIgnore
    public void setDiscountPercentageLevel1WithTaxAmount(UnsafeSupplier<BigDecimal, Exception> discountPercentageLevel1WithTaxAmountUnsafeSupplier) {
        try {
            this.discountPercentageLevel1WithTaxAmount = (BigDecimal)discountPercentageLevel1WithTaxAmountUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @DecimalMin(value="0")
    @Schema(example="0")
    @Valid
    public @DecimalMin(value="0") @Valid BigDecimal getDiscountPercentageLevel2() {
        return this.discountPercentageLevel2;
    }

    public void setDiscountPercentageLevel2(BigDecimal discountPercentageLevel2) {
        this.discountPercentageLevel2 = discountPercentageLevel2;
    }

    @JsonIgnore
    public void setDiscountPercentageLevel2(UnsafeSupplier<BigDecimal, Exception> discountPercentageLevel2UnsafeSupplier) {
        try {
            this.discountPercentageLevel2 = (BigDecimal)discountPercentageLevel2UnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @DecimalMin(value="0")
    @Schema(example="0")
    @Valid
    public @DecimalMin(value="0") @Valid BigDecimal getDiscountPercentageLevel2WithTaxAmount() {
        return this.discountPercentageLevel2WithTaxAmount;
    }

    public void setDiscountPercentageLevel2WithTaxAmount(BigDecimal discountPercentageLevel2WithTaxAmount) {
        this.discountPercentageLevel2WithTaxAmount = discountPercentageLevel2WithTaxAmount;
    }

    @JsonIgnore
    public void setDiscountPercentageLevel2WithTaxAmount(UnsafeSupplier<BigDecimal, Exception> discountPercentageLevel2WithTaxAmountUnsafeSupplier) {
        try {
            this.discountPercentageLevel2WithTaxAmount = (BigDecimal)discountPercentageLevel2WithTaxAmountUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @DecimalMin(value="0")
    @Schema(example="0")
    @Valid
    public @DecimalMin(value="0") @Valid BigDecimal getDiscountPercentageLevel3() {
        return this.discountPercentageLevel3;
    }

    public void setDiscountPercentageLevel3(BigDecimal discountPercentageLevel3) {
        this.discountPercentageLevel3 = discountPercentageLevel3;
    }

    @JsonIgnore
    public void setDiscountPercentageLevel3(UnsafeSupplier<BigDecimal, Exception> discountPercentageLevel3UnsafeSupplier) {
        try {
            this.discountPercentageLevel3 = (BigDecimal)discountPercentageLevel3UnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @DecimalMin(value="0")
    @Schema(example="0")
    @Valid
    public @DecimalMin(value="0") @Valid BigDecimal getDiscountPercentageLevel3WithTaxAmount() {
        return this.discountPercentageLevel3WithTaxAmount;
    }

    public void setDiscountPercentageLevel3WithTaxAmount(BigDecimal discountPercentageLevel3WithTaxAmount) {
        this.discountPercentageLevel3WithTaxAmount = discountPercentageLevel3WithTaxAmount;
    }

    @JsonIgnore
    public void setDiscountPercentageLevel3WithTaxAmount(UnsafeSupplier<BigDecimal, Exception> discountPercentageLevel3WithTaxAmountUnsafeSupplier) {
        try {
            this.discountPercentageLevel3WithTaxAmount = (BigDecimal)discountPercentageLevel3WithTaxAmountUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @DecimalMin(value="0")
    @Schema(example="0")
    @Valid
    public @DecimalMin(value="0") @Valid BigDecimal getDiscountPercentageLevel4() {
        return this.discountPercentageLevel4;
    }

    public void setDiscountPercentageLevel4(BigDecimal discountPercentageLevel4) {
        this.discountPercentageLevel4 = discountPercentageLevel4;
    }

    @JsonIgnore
    public void setDiscountPercentageLevel4(UnsafeSupplier<BigDecimal, Exception> discountPercentageLevel4UnsafeSupplier) {
        try {
            this.discountPercentageLevel4 = (BigDecimal)discountPercentageLevel4UnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @DecimalMin(value="0")
    @Schema(example="0")
    @Valid
    public @DecimalMin(value="0") @Valid BigDecimal getDiscountPercentageLevel4WithTaxAmount() {
        return this.discountPercentageLevel4WithTaxAmount;
    }

    public void setDiscountPercentageLevel4WithTaxAmount(BigDecimal discountPercentageLevel4WithTaxAmount) {
        this.discountPercentageLevel4WithTaxAmount = discountPercentageLevel4WithTaxAmount;
    }

    @JsonIgnore
    public void setDiscountPercentageLevel4WithTaxAmount(UnsafeSupplier<BigDecimal, Exception> discountPercentageLevel4WithTaxAmountUnsafeSupplier) {
        try {
            this.discountPercentageLevel4WithTaxAmount = (BigDecimal)discountPercentageLevel4WithTaxAmountUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @DecimalMin(value="0")
    @Schema(example="2")
    @Valid
    public @DecimalMin(value="0") @Valid BigDecimal getDiscountWithTaxAmount() {
        return this.discountWithTaxAmount;
    }

    public void setDiscountWithTaxAmount(BigDecimal discountWithTaxAmount) {
        this.discountWithTaxAmount = discountWithTaxAmount;
    }

    @JsonIgnore
    public void setDiscountWithTaxAmount(UnsafeSupplier<BigDecimal, Exception> discountWithTaxAmountUnsafeSupplier) {
        try {
            this.discountWithTaxAmount = (BigDecimal)discountWithTaxAmountUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(example="AB-34098-789-N")
    public String getExternalReferenceCode() {
        return this.externalReferenceCode;
    }

    public void setExternalReferenceCode(String externalReferenceCode) {
        this.externalReferenceCode = externalReferenceCode;
    }

    @JsonIgnore
    public void setExternalReferenceCode(UnsafeSupplier<String, Exception> externalReferenceCodeUnsafeSupplier) {
        try {
            this.externalReferenceCode = (String)externalReferenceCodeUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @DecimalMin(value="0")
    @Schema(example="200")
    @Valid
    public @DecimalMin(value="0") @Valid BigDecimal getFinalPrice() {
        return this.finalPrice;
    }

    public void setFinalPrice(BigDecimal finalPrice) {
        this.finalPrice = finalPrice;
    }

    @JsonIgnore
    public void setFinalPrice(UnsafeSupplier<BigDecimal, Exception> finalPriceUnsafeSupplier) {
        try {
            this.finalPrice = (BigDecimal)finalPriceUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @DecimalMin(value="0")
    @Schema(example="200")
    @Valid
    public @DecimalMin(value="0") @Valid BigDecimal getFinalPriceWithTaxAmount() {
        return this.finalPriceWithTaxAmount;
    }

    public void setFinalPriceWithTaxAmount(BigDecimal finalPriceWithTaxAmount) {
        this.finalPriceWithTaxAmount = finalPriceWithTaxAmount;
    }

    @JsonIgnore
    public void setFinalPriceWithTaxAmount(UnsafeSupplier<BigDecimal, Exception> finalPriceWithTaxAmountUnsafeSupplier) {
        try {
            this.finalPriceWithTaxAmount = (BigDecimal)finalPriceWithTaxAmountUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema
    public String getFormattedQuantity() {
        return this.formattedQuantity;
    }

    public void setFormattedQuantity(String formattedQuantity) {
        this.formattedQuantity = formattedQuantity;
    }

    @JsonIgnore
    public void setFormattedQuantity(UnsafeSupplier<String, Exception> formattedQuantityUnsafeSupplier) {
        try {
            this.formattedQuantity = (String)formattedQuantityUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @DecimalMin(value="0")
    @Schema(example="30130")
    public @DecimalMin(value="0") Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @JsonIgnore
    public void setId(UnsafeSupplier<Long, Exception> idUnsafeSupplier) {
        try {
            this.id = (Long)idUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(example="{en_US=Hand Saw, hr_HR=Product Name HR, hu_HU=Product Name HU}")
    @Valid
    public Map<String, String> getName() {
        return this.name;
    }

    public void setName(Map<String, String> name) {
        this.name = name;
    }

    @JsonIgnore
    public void setName(UnsafeSupplier<Map<String, String>, Exception> nameUnsafeSupplier) {
        try {
            this.name = (Map)nameUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema
    public String getOptions() {
        return this.options;
    }

    public void setOptions(String options) {
        this.options = options;
    }

    @JsonIgnore
    public void setOptions(UnsafeSupplier<String, Exception> optionsUnsafeSupplier) {
        try {
            this.options = (String)optionsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(example="CAB-34098-789-N")
    public String getOrderExternalReferenceCode() {
        return this.orderExternalReferenceCode;
    }

    public void setOrderExternalReferenceCode(String orderExternalReferenceCode) {
        this.orderExternalReferenceCode = orderExternalReferenceCode;
    }

    @JsonIgnore
    public void setOrderExternalReferenceCode(UnsafeSupplier<String, Exception> orderExternalReferenceCodeUnsafeSupplier) {
        try {
            this.orderExternalReferenceCode = (String)orderExternalReferenceCodeUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @DecimalMin(value="0")
    @Schema(example="30128")
    public @DecimalMin(value="0") Long getOrderId() {
        return this.orderId;
    }

    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }

    @JsonIgnore
    public void setOrderId(UnsafeSupplier<Long, Exception> orderIdUnsafeSupplier) {
        try {
            this.orderId = (Long)orderIdUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(example="Order item printed note")
    public String getPrintedNote() {
        return this.printedNote;
    }

    public void setPrintedNote(String printedNote) {
        this.printedNote = printedNote;
    }

    @JsonIgnore
    public void setPrintedNote(UnsafeSupplier<String, Exception> printedNoteUnsafeSupplier) {
        try {
            this.printedNote = (String)printedNoteUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @DecimalMin(value="0")
    @Schema(example="101")
    @Valid
    public @DecimalMin(value="0") @Valid BigDecimal getPromoPrice() {
        return this.promoPrice;
    }

    public void setPromoPrice(BigDecimal promoPrice) {
        this.promoPrice = promoPrice;
    }

    @JsonIgnore
    public void setPromoPrice(UnsafeSupplier<BigDecimal, Exception> promoPriceUnsafeSupplier) {
        try {
            this.promoPrice = (BigDecimal)promoPriceUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @DecimalMin(value="0")
    @Schema(example="101")
    @Valid
    public @DecimalMin(value="0") @Valid BigDecimal getPromoPriceWithTaxAmount() {
        return this.promoPriceWithTaxAmount;
    }

    public void setPromoPriceWithTaxAmount(BigDecimal promoPriceWithTaxAmount) {
        this.promoPriceWithTaxAmount = promoPriceWithTaxAmount;
    }

    @JsonIgnore
    public void setPromoPriceWithTaxAmount(UnsafeSupplier<BigDecimal, Exception> promoPriceWithTaxAmountUnsafeSupplier) {
        try {
            this.promoPriceWithTaxAmount = (BigDecimal)promoPriceWithTaxAmountUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @DecimalMin(value="0")
    @Schema(example="2")
    public @DecimalMin(value="0") Integer getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    @JsonIgnore
    public void setQuantity(UnsafeSupplier<Integer, Exception> quantityUnsafeSupplier) {
        try {
            this.quantity = (Integer)quantityUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(example="2017-07-21")
    public Date getRequestedDeliveryDate() {
        return this.requestedDeliveryDate;
    }

    public void setRequestedDeliveryDate(Date requestedDeliveryDate) {
        this.requestedDeliveryDate = requestedDeliveryDate;
    }

    @JsonIgnore
    public void setRequestedDeliveryDate(UnsafeSupplier<Date, Exception> requestedDeliveryDateUnsafeSupplier) {
        try {
            this.requestedDeliveryDate = (Date)requestedDeliveryDateUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @DecimalMin(value="0")
    @Schema(example="1")
    public @DecimalMin(value="0") Integer getShippedQuantity() {
        return this.shippedQuantity;
    }

    public void setShippedQuantity(Integer shippedQuantity) {
        this.shippedQuantity = shippedQuantity;
    }

    @JsonIgnore
    public void setShippedQuantity(UnsafeSupplier<Integer, Exception> shippedQuantityUnsafeSupplier) {
        try {
            this.shippedQuantity = (Integer)shippedQuantityUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema
    @Valid
    public ShippingAddress getShippingAddress() {
        return this.shippingAddress;
    }

    public void setShippingAddress(ShippingAddress shippingAddress) {
        this.shippingAddress = shippingAddress;
    }

    @JsonIgnore
    public void setShippingAddress(UnsafeSupplier<ShippingAddress, Exception> shippingAddressUnsafeSupplier) {
        try {
            this.shippingAddress = (ShippingAddress)shippingAddressUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @DecimalMin(value="0")
    @Schema(example="31130")
    public @DecimalMin(value="0") Long getShippingAddressId() {
        return this.shippingAddressId;
    }

    public void setShippingAddressId(Long shippingAddressId) {
        this.shippingAddressId = shippingAddressId;
    }

    @JsonIgnore
    public void setShippingAddressId(UnsafeSupplier<Long, Exception> shippingAddressIdUnsafeSupplier) {
        try {
            this.shippingAddressId = (Long)shippingAddressIdUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(example="12341234")
    public String getSku() {
        return this.sku;
    }

    public void setSku(String sku) {
        this.sku = sku;
    }

    @JsonIgnore
    public void setSku(UnsafeSupplier<String, Exception> skuUnsafeSupplier) {
        try {
            this.sku = (String)skuUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(example="CAB-34098-789-N")
    public String getSkuExternalReferenceCode() {
        return this.skuExternalReferenceCode;
    }

    public void setSkuExternalReferenceCode(String skuExternalReferenceCode) {
        this.skuExternalReferenceCode = skuExternalReferenceCode;
    }

    @JsonIgnore
    public void setSkuExternalReferenceCode(UnsafeSupplier<String, Exception> skuExternalReferenceCodeUnsafeSupplier) {
        try {
            this.skuExternalReferenceCode = (String)skuExternalReferenceCodeUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @DecimalMin(value="0")
    @Schema(example="30128")
    public @DecimalMin(value="0") Long getSkuId() {
        return this.skuId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    @JsonIgnore
    public void setSkuId(UnsafeSupplier<Long, Exception> skuIdUnsafeSupplier) {
        try {
            this.skuId = (Long)skuIdUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(example="true")
    public Boolean getSubscription() {
        return this.subscription;
    }

    public void setSubscription(Boolean subscription) {
        this.subscription = subscription;
    }

    @JsonIgnore
    public void setSubscription(UnsafeSupplier<Boolean, Exception> subscriptionUnsafeSupplier) {
        try {
            this.subscription = (Boolean)subscriptionUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(example="pc")
    public String getUnitOfMeasure() {
        return this.unitOfMeasure;
    }

    public void setUnitOfMeasure(String unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
    }

    @JsonIgnore
    public void setUnitOfMeasure(UnsafeSupplier<String, Exception> unitOfMeasureUnsafeSupplier) {
        try {
            this.unitOfMeasure = (String)unitOfMeasureUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @DecimalMin(value="0")
    @Schema(example="101")
    @Valid
    public @DecimalMin(value="0") @Valid BigDecimal getUnitPrice() {
        return this.unitPrice;
    }

    public void setUnitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
    }

    @JsonIgnore
    public void setUnitPrice(UnsafeSupplier<BigDecimal, Exception> unitPriceUnsafeSupplier) {
        try {
            this.unitPrice = (BigDecimal)unitPriceUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @DecimalMin(value="0")
    @Schema(example="101")
    @Valid
    public @DecimalMin(value="0") @Valid BigDecimal getUnitPriceWithTaxAmount() {
        return this.unitPriceWithTaxAmount;
    }

    public void setUnitPriceWithTaxAmount(BigDecimal unitPriceWithTaxAmount) {
        this.unitPriceWithTaxAmount = unitPriceWithTaxAmount;
    }

    @JsonIgnore
    public void setUnitPriceWithTaxAmount(UnsafeSupplier<BigDecimal, Exception> unitPriceWithTaxAmountUnsafeSupplier) {
        try {
            this.unitPriceWithTaxAmount = (BigDecimal)unitPriceWithTaxAmountUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof OrderItem)) {
            return false;
        }
        OrderItem orderItem = (OrderItem)object;
        return Objects.equals(this.toString(), orderItem.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        StringBundler sb = new StringBundler();
        sb.append("{");
        SimpleDateFormat liferayToJSONDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        if (this.bookedQuantityId != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"bookedQuantityId\": ");
            sb.append((Object)this.bookedQuantityId);
        }
        if (this.customFields != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"customFields\": ");
            sb.append("[");
            for (int i = 0; i < this.customFields.length; ++i) {
                sb.append(String.valueOf(this.customFields[i]));
                if (i + 1 >= this.customFields.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if (this.decimalQuantity != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"decimalQuantity\": ");
            sb.append((Object)this.decimalQuantity);
        }
        if (this.deliveryGroup != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"deliveryGroup\": ");
            sb.append("\"");
            sb.append(OrderItem._escape(this.deliveryGroup));
            sb.append("\"");
        }
        if (this.discountAmount != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"discountAmount\": ");
            sb.append((Object)this.discountAmount);
        }
        if (this.discountPercentageLevel1 != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"discountPercentageLevel1\": ");
            sb.append((Object)this.discountPercentageLevel1);
        }
        if (this.discountPercentageLevel1WithTaxAmount != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"discountPercentageLevel1WithTaxAmount\": ");
            sb.append((Object)this.discountPercentageLevel1WithTaxAmount);
        }
        if (this.discountPercentageLevel2 != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"discountPercentageLevel2\": ");
            sb.append((Object)this.discountPercentageLevel2);
        }
        if (this.discountPercentageLevel2WithTaxAmount != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"discountPercentageLevel2WithTaxAmount\": ");
            sb.append((Object)this.discountPercentageLevel2WithTaxAmount);
        }
        if (this.discountPercentageLevel3 != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"discountPercentageLevel3\": ");
            sb.append((Object)this.discountPercentageLevel3);
        }
        if (this.discountPercentageLevel3WithTaxAmount != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"discountPercentageLevel3WithTaxAmount\": ");
            sb.append((Object)this.discountPercentageLevel3WithTaxAmount);
        }
        if (this.discountPercentageLevel4 != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"discountPercentageLevel4\": ");
            sb.append((Object)this.discountPercentageLevel4);
        }
        if (this.discountPercentageLevel4WithTaxAmount != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"discountPercentageLevel4WithTaxAmount\": ");
            sb.append((Object)this.discountPercentageLevel4WithTaxAmount);
        }
        if (this.discountWithTaxAmount != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"discountWithTaxAmount\": ");
            sb.append((Object)this.discountWithTaxAmount);
        }
        if (this.externalReferenceCode != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"externalReferenceCode\": ");
            sb.append("\"");
            sb.append(OrderItem._escape(this.externalReferenceCode));
            sb.append("\"");
        }
        if (this.finalPrice != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"finalPrice\": ");
            sb.append((Object)this.finalPrice);
        }
        if (this.finalPriceWithTaxAmount != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"finalPriceWithTaxAmount\": ");
            sb.append((Object)this.finalPriceWithTaxAmount);
        }
        if (this.formattedQuantity != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"formattedQuantity\": ");
            sb.append("\"");
            sb.append(OrderItem._escape(this.formattedQuantity));
            sb.append("\"");
        }
        if (this.id != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"id\": ");
            sb.append((Object)this.id);
        }
        if (this.name != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"name\": ");
            sb.append(OrderItem._toJSON(this.name));
        }
        if (this.options != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"options\": ");
            sb.append("\"");
            sb.append(OrderItem._escape(this.options));
            sb.append("\"");
        }
        if (this.orderExternalReferenceCode != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"orderExternalReferenceCode\": ");
            sb.append("\"");
            sb.append(OrderItem._escape(this.orderExternalReferenceCode));
            sb.append("\"");
        }
        if (this.orderId != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"orderId\": ");
            sb.append((Object)this.orderId);
        }
        if (this.printedNote != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"printedNote\": ");
            sb.append("\"");
            sb.append(OrderItem._escape(this.printedNote));
            sb.append("\"");
        }
        if (this.promoPrice != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"promoPrice\": ");
            sb.append((Object)this.promoPrice);
        }
        if (this.promoPriceWithTaxAmount != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"promoPriceWithTaxAmount\": ");
            sb.append((Object)this.promoPriceWithTaxAmount);
        }
        if (this.quantity != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"quantity\": ");
            sb.append((Object)this.quantity);
        }
        if (this.requestedDeliveryDate != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"requestedDeliveryDate\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(this.requestedDeliveryDate));
            sb.append("\"");
        }
        if (this.shippedQuantity != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"shippedQuantity\": ");
            sb.append((Object)this.shippedQuantity);
        }
        if (this.shippingAddress != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"shippingAddress\": ");
            sb.append(String.valueOf(this.shippingAddress));
        }
        if (this.shippingAddressId != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"shippingAddressId\": ");
            sb.append((Object)this.shippingAddressId);
        }
        if (this.sku != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"sku\": ");
            sb.append("\"");
            sb.append(OrderItem._escape(this.sku));
            sb.append("\"");
        }
        if (this.skuExternalReferenceCode != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"skuExternalReferenceCode\": ");
            sb.append("\"");
            sb.append(OrderItem._escape(this.skuExternalReferenceCode));
            sb.append("\"");
        }
        if (this.skuId != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"skuId\": ");
            sb.append((Object)this.skuId);
        }
        if (this.subscription != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"subscription\": ");
            sb.append((Object)this.subscription);
        }
        if (this.unitOfMeasure != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"unitOfMeasure\": ");
            sb.append("\"");
            sb.append(OrderItem._escape(this.unitOfMeasure));
            sb.append("\"");
        }
        if (this.unitPrice != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"unitPrice\": ");
            sb.append((Object)this.unitPrice);
        }
        if (this.unitPriceWithTaxAmount != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"unitPriceWithTaxAmount\": ");
            sb.append((Object)this.unitPriceWithTaxAmount);
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(OrderItem._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (OrderItem._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(OrderItem._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(OrderItem._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }
}

