/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.inventory.internal.resource.v1_0;

import com.liferay.commerce.inventory.exception.NoSuchInventoryWarehouseException;
import com.liferay.commerce.inventory.model.CommerceInventoryWarehouse;
import com.liferay.commerce.inventory.model.CommerceInventoryWarehouseRel;
import com.liferay.commerce.inventory.service.CommerceInventoryWarehouseRelService;
import com.liferay.commerce.inventory.service.CommerceInventoryWarehouseService;
import com.liferay.commerce.model.CommerceOrderType;
import com.liferay.commerce.service.CommerceOrderTypeService;
import com.liferay.headless.commerce.admin.inventory.dto.v1_0.Warehouse;
import com.liferay.headless.commerce.admin.inventory.dto.v1_0.WarehouseOrderType;
import com.liferay.headless.commerce.admin.inventory.internal.dto.v1_0.WarehouseOrderTypeDTOConverter;
import com.liferay.headless.commerce.admin.inventory.internal.resource.v1_0.BaseWarehouseOrderTypeResourceImpl;
import com.liferay.headless.commerce.admin.inventory.resource.v1_0.WarehouseOrderTypeResource;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.fields.NestedFieldSupport;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/warehouse-order-type.properties"}, scope=ServiceScope.PROTOTYPE, service={NestedFieldSupport.class, WarehouseOrderTypeResource.class})
public class WarehouseOrderTypeResourceImpl
extends BaseWarehouseOrderTypeResourceImpl
implements NestedFieldSupport {
    @Reference(target="(model.class.name=com.liferay.commerce.inventory.model.CommerceInventoryWarehouse)")
    private ModelResourcePermission<CommerceInventoryWarehouse> _commerceInventoryWarehouseModelResourcePermission;
    @Reference
    private CommerceInventoryWarehouseRelService _commerceInventoryWarehouseRelService;
    @Reference
    private CommerceInventoryWarehouseService _commerceInventoryWarehouseService;
    @Reference
    private CommerceOrderTypeService _commerceOrderTypeService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private WarehouseOrderTypeDTOConverter _warehouseOrderTypeDTOConverter;

    @Override
    public void deleteWarehouseOrderType(Long id) throws Exception {
        this._commerceInventoryWarehouseRelService.deleteCommerceInventoryWarehouseRel(id.longValue());
    }

    @Override
    public Page<WarehouseOrderType> getWarehouseByExternalReferenceCodeWarehouseOrderTypesPage(String externalReferenceCode, Pagination pagination) throws Exception {
        CommerceInventoryWarehouse commerceInventoryWarehouse = this._commerceInventoryWarehouseService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commerceInventoryWarehouse == null) {
            throw new NoSuchInventoryWarehouseException("Unable to find warehouse with external reference code " + externalReferenceCode);
        }
        return Page.of(this.transform(this._commerceInventoryWarehouseRelService.getCommerceOrderTypeCommerceInventoryWarehouseRels(commerceInventoryWarehouse.getCommerceInventoryWarehouseId(), null, pagination.getStartPosition(), pagination.getEndPosition()), commerceInventoryWarehouseRel -> this._toWarehouseOrderType((CommerceInventoryWarehouseRel)commerceInventoryWarehouseRel)), (Pagination)pagination, (long)this._commerceInventoryWarehouseRelService.getCommerceOrderTypeCommerceInventoryWarehouseRelsCount(commerceInventoryWarehouse.getCommerceInventoryWarehouseId(), null));
    }

    @Override
    @NestedField(parentClass=Warehouse.class, value="warehouseOrderTypes")
    public Page<WarehouseOrderType> getWarehouseIdWarehouseOrderTypesPage(Long id, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        CommerceInventoryWarehouse commerceInventoryWarehouse = this._commerceInventoryWarehouseService.fetchByCommerceInventoryWarehouse(id.longValue());
        if (commerceInventoryWarehouse == null) {
            throw new NoSuchInventoryWarehouseException("Unable to find warehouse with ID " + id);
        }
        return Page.of(this.transform(this._commerceInventoryWarehouseRelService.getCommerceOrderTypeCommerceInventoryWarehouseRels(id.longValue(), search, pagination.getStartPosition(), pagination.getEndPosition()), commerceInventoryWarehouseRel -> this._toWarehouseOrderType((CommerceInventoryWarehouseRel)commerceInventoryWarehouseRel)), (Pagination)pagination, (long)this._commerceInventoryWarehouseRelService.getCommerceOrderTypeCommerceInventoryWarehouseRelsCount(id.longValue(), search));
    }

    @Override
    public WarehouseOrderType postWarehouseByExternalReferenceCodeWarehouseOrderType(String externalReferenceCode, WarehouseOrderType warehouseOrderType) throws Exception {
        CommerceInventoryWarehouse commerceInventoryWarehouse = this._commerceInventoryWarehouseService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commerceInventoryWarehouse == null) {
            throw new NoSuchInventoryWarehouseException("Unable to find warehouse with external reference code " + externalReferenceCode);
        }
        CommerceOrderType commerceOrderType = this._getCommerceOrderType(warehouseOrderType);
        return this._toWarehouseOrderType(this._commerceInventoryWarehouseRelService.addCommerceInventoryWarehouseRel(CommerceOrderType.class.getName(), commerceOrderType.getCommerceOrderTypeId(), commerceInventoryWarehouse.getCommerceInventoryWarehouseId()));
    }

    @Override
    public WarehouseOrderType postWarehouseIdWarehouseOrderType(Long id, WarehouseOrderType warehouseOrderType) throws Exception {
        CommerceOrderType commerceOrderType = this._getCommerceOrderType(warehouseOrderType);
        return this._toWarehouseOrderType(this._commerceInventoryWarehouseRelService.addCommerceInventoryWarehouseRel(CommerceOrderType.class.getName(), commerceOrderType.getCommerceOrderTypeId(), id.longValue()));
    }

    private Map<String, Map<String, String>> _getActions(CommerceInventoryWarehouseRel commerceInventoryWarehouseRel) {
        return HashMapBuilder.put((Object)"delete", this.addAction("UPDATE", commerceInventoryWarehouseRel.getCommerceInventoryWarehouseId(), "deleteWarehouseOrderType", this._commerceInventoryWarehouseModelResourcePermission)).build();
    }

    private CommerceOrderType _getCommerceOrderType(WarehouseOrderType warehouseOrderType) throws Exception {
        CommerceOrderType commerceOrderType = null;
        commerceOrderType = warehouseOrderType.getOrderTypeId() > 0L ? this._commerceOrderTypeService.getCommerceOrderType(warehouseOrderType.getOrderTypeId().longValue()) : this._commerceOrderTypeService.fetchByExternalReferenceCode(warehouseOrderType.getOrderTypeExternalReferenceCode(), this.contextCompany.getCompanyId());
        return commerceOrderType;
    }

    private WarehouseOrderType _toWarehouseOrderType(CommerceInventoryWarehouseRel commerceInventoryWarehouseRel) throws Exception {
        return this._warehouseOrderTypeDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), this._getActions(commerceInventoryWarehouseRel), this._dtoConverterRegistry, (Object)commerceInventoryWarehouseRel.getCommerceInventoryWarehouseRelId(), this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser));
    }
}

