/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.inventory.internal.resource.v1_0;

import com.liferay.commerce.exception.NoSuchWarehouseException;
import com.liferay.commerce.inventory.model.CommerceInventoryWarehouse;
import com.liferay.commerce.inventory.service.CommerceInventoryWarehouseService;
import com.liferay.commerce.product.exception.NoSuchChannelException;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.model.CommerceChannelRel;
import com.liferay.commerce.product.service.CommerceChannelRelService;
import com.liferay.commerce.product.service.CommerceChannelService;
import com.liferay.headless.commerce.admin.inventory.dto.v1_0.Warehouse;
import com.liferay.headless.commerce.admin.inventory.dto.v1_0.WarehouseChannel;
import com.liferay.headless.commerce.admin.inventory.internal.dto.v1_0.WarehouseChannelDTOConverter;
import com.liferay.headless.commerce.admin.inventory.internal.resource.v1_0.BaseWarehouseChannelResourceImpl;
import com.liferay.headless.commerce.admin.inventory.resource.v1_0.WarehouseChannelResource;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.fields.NestedFieldSupport;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/warehouse-channel.properties"}, scope=ServiceScope.PROTOTYPE, service={NestedFieldSupport.class, WarehouseChannelResource.class})
public class WarehouseChannelResourceImpl
extends BaseWarehouseChannelResourceImpl
implements NestedFieldSupport {
    @Reference(target="(model.class.name=com.liferay.commerce.product.model.CommerceChannelRel)")
    private ModelResourcePermission<CommerceChannelRel> _commerceChannelRelModelResourcePermission;
    @Reference
    private CommerceChannelRelService _commerceChannelRelService;
    @Reference
    private CommerceChannelService _commerceChannelService;
    @Reference(target="(model.class.name=com.liferay.commerce.inventory.model.CommerceInventoryWarehouse)")
    private ModelResourcePermission<CommerceInventoryWarehouse> _commerceInventoryWarehouseModelResourcePermission;
    @Reference
    private CommerceInventoryWarehouseService _commerceInventoryWarehouseService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private ServiceContextHelper _serviceContextHelper;
    @Reference
    private WarehouseChannelDTOConverter _warehouseChannelDTOConverter;

    @Override
    public void deleteWarehouseChannel(Long id) throws Exception {
        this._commerceChannelRelService.deleteCommerceChannelRel(id.longValue());
    }

    @Override
    public Page<WarehouseChannel> getWarehouseByExternalReferenceCodeWarehouseChannelsPage(String externalReferenceCode, Pagination pagination) throws Exception {
        CommerceInventoryWarehouse commerceInventoryWarehouse = this._commerceInventoryWarehouseService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commerceInventoryWarehouse == null) {
            throw new NoSuchWarehouseException("Unable to find warehouse with external reference code " + externalReferenceCode);
        }
        List commerceChannelRels = this._commerceChannelRelService.getCommerceChannelRels(CommerceInventoryWarehouse.class.getName(), commerceInventoryWarehouse.getCommerceInventoryWarehouseId(), null, pagination.getStartPosition(), pagination.getEndPosition());
        int totalItems = this._commerceChannelRelService.getCommerceChannelRelsCount(CommerceInventoryWarehouse.class.getName(), commerceInventoryWarehouse.getCommerceInventoryWarehouseId());
        return Page.of(this._toWarehouseChannels(commerceChannelRels), (Pagination)pagination, (long)totalItems);
    }

    @Override
    @NestedField(parentClass=Warehouse.class, value="warehouseChannels")
    public Page<WarehouseChannel> getWarehouseIdWarehouseChannelsPage(Long id, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        CommerceInventoryWarehouse commerceInventoryWarehouse = this._commerceInventoryWarehouseService.fetchByCommerceInventoryWarehouse(id.longValue());
        if (commerceInventoryWarehouse == null) {
            return Page.of(Collections.emptyList());
        }
        List commerceChannelRel = this._commerceChannelRelService.getCommerceChannelRels(CommerceInventoryWarehouse.class.getName(), id.longValue(), search, pagination.getStartPosition(), pagination.getEndPosition());
        int totalItems = this._commerceChannelRelService.getCommerceChannelRelsCount(CommerceInventoryWarehouse.class.getName(), id.longValue(), search);
        return Page.of(this._toWarehouseChannels(commerceChannelRel), (Pagination)pagination, (long)totalItems);
    }

    @Override
    public WarehouseChannel postWarehouseByExternalReferenceCodeWarehouseChannel(String externalReferenceCode, WarehouseChannel warehouseChannel) throws Exception {
        CommerceInventoryWarehouse commerceInventoryWarehouse = this._commerceInventoryWarehouseService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commerceInventoryWarehouse == null) {
            throw new NoSuchWarehouseException("Unable to find warehouse with external reference code " + externalReferenceCode);
        }
        CommerceChannelRel commerceChannelRel = this._addCommerceInventoryWarehouseChannelRel(commerceInventoryWarehouse.getCommerceInventoryWarehouseId(), warehouseChannel);
        return this._toWarehouseChannel(commerceChannelRel.getCommerceChannelRelId());
    }

    @Override
    public WarehouseChannel postWarehouseIdWarehouseChannel(Long id, WarehouseChannel warehouseChannel) throws Exception {
        CommerceChannelRel commerceChannelRel = this._addCommerceInventoryWarehouseChannelRel(id, warehouseChannel);
        return this._toWarehouseChannel(commerceChannelRel.getCommerceChannelRelId());
    }

    private CommerceChannelRel _addCommerceInventoryWarehouseChannelRel(long commerceInventoryWarehouseId, WarehouseChannel warehouseChannel) throws Exception {
        CommerceChannel commerceChannel;
        ServiceContext serviceContext = this._serviceContextHelper.getServiceContext();
        if (Validator.isNull((String)warehouseChannel.getChannelExternalReferenceCode())) {
            commerceChannel = this._commerceChannelService.fetchCommerceChannel(warehouseChannel.getChannelId().longValue());
            if (commerceChannel == null) {
                throw new NoSuchChannelException("Unable to find channel with commerce channel id " + warehouseChannel.getChannelId());
            }
        } else {
            commerceChannel = this._commerceChannelService.fetchByExternalReferenceCode(warehouseChannel.getChannelExternalReferenceCode(), serviceContext.getCompanyId());
            if (commerceChannel == null) {
                throw new NoSuchChannelException("Unable to find channel with external reference code " + warehouseChannel.getChannelExternalReferenceCode());
            }
        }
        return this._commerceChannelRelService.addCommerceChannelRel(CommerceInventoryWarehouse.class.getName(), commerceInventoryWarehouseId, commerceChannel.getCommerceChannelId(), serviceContext);
    }

    private Map<String, Map<String, String>> _getActions(CommerceChannelRel commerceChannelRel) {
        return HashMapBuilder.put((Object)"delete", this.addAction("UPDATE", commerceChannelRel.getCommerceChannelRelId(), "deleteWarehouseChannel", this._commerceChannelRelModelResourcePermission)).build();
    }

    private WarehouseChannel _toWarehouseChannel(Long commerceChannelRelId) throws Exception {
        CommerceChannelRel commerceChannelRel = this._commerceChannelRelService.getCommerceChannelRel(commerceChannelRelId.longValue());
        return this._warehouseChannelDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), this._getActions(commerceChannelRel), this._dtoConverterRegistry, (Object)commerceChannelRelId, this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser));
    }

    private List<WarehouseChannel> _toWarehouseChannels(List<CommerceChannelRel> commerceChannelRels) throws Exception {
        ArrayList<WarehouseChannel> warehouseChannels = new ArrayList<WarehouseChannel>();
        for (CommerceChannelRel commerceChannelRel : commerceChannelRels) {
            warehouseChannels.add(this._toWarehouseChannel(commerceChannelRel.getCommerceChannelRelId()));
        }
        return warehouseChannels;
    }
}

