/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.inventory.internal.resource.v1_0;

import com.liferay.commerce.inventory.exception.NoSuchInventoryReplenishmentItemException;
import com.liferay.commerce.inventory.model.CommerceInventoryReplenishmentItem;
import com.liferay.commerce.inventory.model.CommerceInventoryWarehouseItem;
import com.liferay.commerce.inventory.service.CommerceInventoryReplenishmentItemService;
import com.liferay.commerce.inventory.service.CommerceInventoryWarehouseItemService;
import com.liferay.headless.commerce.admin.inventory.dto.v1_0.ReplenishmentItem;
import com.liferay.headless.commerce.admin.inventory.internal.dto.v1_0.ReplenishmentItemDTOConverter;
import com.liferay.headless.commerce.admin.inventory.internal.resource.v1_0.BaseReplenishmentItemResourceImpl;
import com.liferay.headless.commerce.admin.inventory.resource.v1_0.ReplenishmentItemResource;
import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/replenishment-item.properties"}, scope=ServiceScope.PROTOTYPE, service={ReplenishmentItemResource.class})
public class ReplenishmentItemResourceImpl
extends BaseReplenishmentItemResourceImpl {
    @Reference
    private CommerceInventoryReplenishmentItemService _commerceInventoryReplenishmentItemService;
    @Reference
    private CommerceInventoryWarehouseItemService _commerceInventoryWarehouseItemService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private ReplenishmentItemDTOConverter _replenishmentItemDTOConverter;

    @Override
    public void deleteReplenishmentItem(Long replenishmentItemId) throws Exception {
        this._commerceInventoryReplenishmentItemService.deleteCommerceInventoryReplenishmentItem(replenishmentItemId.longValue());
    }

    @Override
    public void deleteReplenishmentItemByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CommerceInventoryReplenishmentItem commerceInventoryReplenishmentItem = this._commerceInventoryReplenishmentItemService.fetchCommerceInventoryReplenishmentItemByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commerceInventoryReplenishmentItem == null) {
            throw new NoSuchInventoryReplenishmentItemException("Unable to find replenishment item with external reference code " + externalReferenceCode);
        }
        this._commerceInventoryReplenishmentItemService.deleteCommerceInventoryReplenishmentItem(commerceInventoryReplenishmentItem.getCommerceInventoryReplenishmentItemId());
    }

    @Override
    public ReplenishmentItem getReplenishmentItem(Long replenishmentItemId) throws Exception {
        return this._toReplenishmentItem(this._commerceInventoryReplenishmentItemService.getCommerceInventoryReplenishmentItem(replenishmentItemId.longValue()));
    }

    @Override
    public ReplenishmentItem getReplenishmentItemByExternalReferenceCode(String externalReferenceCode) throws Exception {
        return this._toReplenishmentItem(this._fetchCommerceInventoryReplenishmentItemByExternalReferenceCode(externalReferenceCode));
    }

    @Override
    public Page<ReplenishmentItem> getReplenishmentItemsPage(String sku, Pagination pagination) throws Exception {
        return Page.of(this.transform(this._commerceInventoryReplenishmentItemService.getCommerceInventoryReplenishmentItemsByCompanyIdAndSku(this.contextCompany.getCompanyId(), sku, pagination.getStartPosition(), pagination.getEndPosition()), this::_toReplenishmentItem), (Pagination)pagination, (long)this._commerceInventoryReplenishmentItemService.getCommerceInventoryReplenishmentItemsCountByCompanyIdAndSku(this.contextCompany.getCompanyId(), sku));
    }

    @Override
    public Page<ReplenishmentItem> getWarehouseIdReplenishmentItemsPage(Long warehouseId, Pagination pagination) throws Exception {
        return Page.of(this.transform(this._commerceInventoryReplenishmentItemService.getCommerceInventoryReplenishmentItemsByCommerceInventoryWarehouseId(warehouseId.longValue(), pagination.getStartPosition(), pagination.getEndPosition()), this::_toReplenishmentItem), (Pagination)pagination, (long)this._commerceInventoryReplenishmentItemService.getCommerceInventoryReplenishmentItemsCountByCommerceInventoryWarehouseId(warehouseId.longValue()));
    }

    @Override
    public ReplenishmentItem patchReplenishmentItem(Long replenishmentItemId, ReplenishmentItem replenishmentItem) throws Exception {
        return this._toReplenishmentItem(this._updateCommerceInventoryReplenishmentItem(replenishmentItem, this._commerceInventoryReplenishmentItemService.getCommerceInventoryReplenishmentItem(replenishmentItemId.longValue())));
    }

    @Override
    public ReplenishmentItem patchReplenishmentItemByExternalReferenceCode(String externalReferenceCode, ReplenishmentItem replenishmentItem) throws Exception {
        return this._toReplenishmentItem(this._updateCommerceInventoryReplenishmentItem(replenishmentItem, this._fetchCommerceInventoryReplenishmentItemByExternalReferenceCode(externalReferenceCode)));
    }

    @Override
    public ReplenishmentItem postReplenishmentItem(Long warehouseId, String sku, ReplenishmentItem replenishmentItem) throws Exception {
        CommerceInventoryWarehouseItem commerceInventoryWarehouseItem = this._commerceInventoryWarehouseItemService.getCommerceInventoryWarehouseItem(warehouseId.longValue(), sku);
        return this._toReplenishmentItem(this._commerceInventoryReplenishmentItemService.addCommerceInventoryReplenishmentItem(replenishmentItem.getExternalReferenceCode(), commerceInventoryWarehouseItem.getCommerceInventoryWarehouseId(), commerceInventoryWarehouseItem.getSku(), GetterUtil.getDate((Object)replenishmentItem.getAvailabilityDate(), (DateFormat)DateFormatFactoryUtil.getDate((Locale)this.contextAcceptLanguage.getPreferredLocale(), (TimeZone)this.contextUser.getTimeZone())), GetterUtil.getInteger((Object)replenishmentItem.getQuantity())));
    }

    private CommerceInventoryReplenishmentItem _fetchCommerceInventoryReplenishmentItemByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CommerceInventoryReplenishmentItem commerceInventoryReplenishmentItem = this._commerceInventoryReplenishmentItemService.fetchCommerceInventoryReplenishmentItemByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commerceInventoryReplenishmentItem == null) {
            throw new NoSuchInventoryReplenishmentItemException("Unable to find replenishment item with external reference code " + externalReferenceCode);
        }
        return commerceInventoryReplenishmentItem;
    }

    private ReplenishmentItem _toReplenishmentItem(CommerceInventoryReplenishmentItem commerceInventoryReplenishmentItem) throws Exception {
        return this._replenishmentItemDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), null, this._dtoConverterRegistry, (Object)commerceInventoryReplenishmentItem.getCommerceInventoryReplenishmentItemId(), this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser));
    }

    private CommerceInventoryReplenishmentItem _updateCommerceInventoryReplenishmentItem(ReplenishmentItem replenishmentItem, CommerceInventoryReplenishmentItem commerceInventoryReplenishmentItem) throws Exception {
        return this._commerceInventoryReplenishmentItemService.updateCommerceInventoryReplenishmentItem(replenishmentItem.getExternalReferenceCode(), commerceInventoryReplenishmentItem.getCommerceInventoryReplenishmentItemId(), GetterUtil.getDate((Object)replenishmentItem.getAvailabilityDate(), (DateFormat)DateFormatFactoryUtil.getDate((Locale)this.contextAcceptLanguage.getPreferredLocale(), (TimeZone)this.contextUser.getTimeZone()), (Date)commerceInventoryReplenishmentItem.getAvailabilityDate()), GetterUtil.getInteger((Object)replenishmentItem.getQuantity(), (int)commerceInventoryReplenishmentItem.getQuantity()), commerceInventoryReplenishmentItem.getMvccVersion());
    }
}

