/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.inventory.internal.dto.v1_0;

import com.liferay.commerce.inventory.model.CommerceInventoryWarehouse;
import com.liferay.commerce.inventory.service.CommerceInventoryWarehouseService;
import com.liferay.headless.commerce.admin.inventory.dto.v1_0.Warehouse;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.commerce.inventory.model.CommerceInventoryWarehouse"}, service={DTOConverter.class, WarehouseDTOConverter.class})
public class WarehouseDTOConverter
implements DTOConverter<CommerceInventoryWarehouse, Warehouse> {
    @Reference
    private CommerceInventoryWarehouseService _commerceInventoryWarehouseService;

    public String getContentType() {
        return Warehouse.class.getSimpleName();
    }

    public Warehouse toDTO(final DTOConverterContext dtoConverterContext) throws Exception {
        final CommerceInventoryWarehouse commerceInventoryWarehouse = this._commerceInventoryWarehouseService.getCommerceInventoryWarehouse(((Long)dtoConverterContext.getId()).longValue());
        return new Warehouse(){
            {
                this.actions = dtoConverterContext.getActions();
                this.active = commerceInventoryWarehouse.isActive();
                this.city = commerceInventoryWarehouse.getCity();
                this.countryISOCode = commerceInventoryWarehouse.getCountryTwoLettersISOCode();
                this.description = LanguageUtils.getLanguageIdMap((Map)commerceInventoryWarehouse.getDescriptionMap());
                this.externalReferenceCode = commerceInventoryWarehouse.getExternalReferenceCode();
                this.id = commerceInventoryWarehouse.getCommerceInventoryWarehouseId();
                this.latitude = commerceInventoryWarehouse.getLatitude();
                this.longitude = commerceInventoryWarehouse.getLongitude();
                this.name = LanguageUtils.getLanguageIdMap((Map)commerceInventoryWarehouse.getNameMap());
                this.regionISOCode = commerceInventoryWarehouse.getCommerceRegionCode();
                this.street1 = commerceInventoryWarehouse.getStreet1();
                this.street2 = commerceInventoryWarehouse.getStreet2();
                this.street3 = commerceInventoryWarehouse.getStreet3();
                this.type = commerceInventoryWarehouse.getType();
                this.zip = commerceInventoryWarehouse.getZip();
            }
        };
    }
}

