/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.inventory.internal.resource.v1_0;

import com.liferay.commerce.inventory.exception.NoSuchInventoryWarehouseException;
import com.liferay.commerce.inventory.model.CommerceInventoryWarehouse;
import com.liferay.commerce.inventory.service.CommerceInventoryWarehouseItemService;
import com.liferay.commerce.inventory.service.CommerceInventoryWarehouseService;
import com.liferay.headless.commerce.admin.inventory.dto.v1_0.Warehouse;
import com.liferay.headless.commerce.admin.inventory.dto.v1_0.WarehouseItem;
import com.liferay.headless.commerce.admin.inventory.internal.dto.v1_0.WarehouseDTOConverter;
import com.liferay.headless.commerce.admin.inventory.internal.odata.entity.v1_0.WarehouseEntityModel;
import com.liferay.headless.commerce.admin.inventory.internal.resource.v1_0.BaseWarehouseResourceImpl;
import com.liferay.headless.commerce.admin.inventory.resource.v1_0.WarehouseResource;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.SearchUtil;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(enabled=false, properties={"OSGI-INF/liferay/rest/v1_0/warehouse.properties"}, scope=ServiceScope.PROTOTYPE, service={WarehouseResource.class})
public class WarehouseResourceImpl
extends BaseWarehouseResourceImpl
implements EntityModelResource {
    private static final EntityModel _entityModel = new WarehouseEntityModel();
    @Reference
    private CommerceInventoryWarehouseItemService _commerceInventoryWarehouseItemService;
    @Reference
    private CommerceInventoryWarehouseService _commerceInventoryWarehouseService;
    @Reference
    private ServiceContextHelper _serviceContextHelper;
    @Reference
    private WarehouseDTOConverter _warehouseDTOConverter;

    @Override
    public Response deleteWarehousByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CommerceInventoryWarehouse commerceInventoryWarehouse = this._commerceInventoryWarehouseService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceInventoryWarehouse == null) {
            throw new NoSuchInventoryWarehouseException("Unable to find Warehouse with externalReferenceCode: " + externalReferenceCode);
        }
        this._commerceInventoryWarehouseService.deleteCommerceInventoryWarehouse(commerceInventoryWarehouse.getCommerceInventoryWarehouseId());
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Response deleteWarehousId(Long id) throws Exception {
        this._commerceInventoryWarehouseService.deleteCommerceInventoryWarehouse(id.longValue());
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return _entityModel;
    }

    @Override
    public Warehouse getWarehousByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CommerceInventoryWarehouse commerceInventoryWarehouse = this._commerceInventoryWarehouseService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceInventoryWarehouse == null) {
            throw new NoSuchInventoryWarehouseException("Unable to find Warehouse with externalReferenceCode: " + externalReferenceCode);
        }
        return this._warehouseDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)commerceInventoryWarehouse.getCommerceInventoryWarehouseId(), this.contextAcceptLanguage.getPreferredLocale()));
    }

    @Override
    public Page<Warehouse> getWarehousesPage(Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return SearchUtil.search(booleanQuery -> booleanQuery.getPreBooleanFilter(), (Filter)filter, CommerceInventoryWarehouse.class, (String)"", (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), (UnsafeConsumer)new UnsafeConsumer(){

            public void accept(Object object) throws Exception {
                SearchContext searchContext = (SearchContext)object;
                searchContext.setCompanyId(WarehouseResourceImpl.this.contextCompany.getCompanyId());
            }
        }, document -> this._toWarehouse(this._commerceInventoryWarehouseService.getCommerceInventoryWarehouse(GetterUtil.getLong((String)document.get("entryClassPK")))), (Sort[])sorts);
    }

    @Override
    public Warehouse getWarehousId(Long id) throws Exception {
        return this._warehouseDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)GetterUtil.getLong((Object)id), this.contextAcceptLanguage.getPreferredLocale()));
    }

    @Override
    public Response patchWarehousByExternalReferenceCode(String externalReferenceCode, Warehouse warehouse) throws Exception {
        CommerceInventoryWarehouse commerceInventoryWarehouse = this._commerceInventoryWarehouseService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceInventoryWarehouse == null) {
            throw new NoSuchInventoryWarehouseException("Unable to find Warehouse with externalReferenceCode: " + externalReferenceCode);
        }
        this._updateWarehouse(commerceInventoryWarehouse, warehouse);
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Response patchWarehousId(Long id, Warehouse warehouse) throws Exception {
        this._updateWarehouse(this._commerceInventoryWarehouseService.getCommerceInventoryWarehouse(id.longValue()), warehouse);
        Response.ResponseBuilder responseBuilder = Response.noContent();
        return responseBuilder.build();
    }

    @Override
    public Warehouse postWarehous(Warehouse warehouse) throws Exception {
        CommerceInventoryWarehouse commerceInventoryWarehouse = this._commerceInventoryWarehouseService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), warehouse.getExternalReferenceCode());
        commerceInventoryWarehouse = commerceInventoryWarehouse == null ? this._commerceInventoryWarehouseService.addCommerceInventoryWarehouse(warehouse.getName(), warehouse.getDescription(), GetterUtil.get((Object)warehouse.getActive(), (boolean)true), warehouse.getStreet1(), warehouse.getStreet2(), warehouse.getStreet3(), warehouse.getCity(), warehouse.getZip(), warehouse.getRegionISOCode(), warehouse.getCountryISOCode(), GetterUtil.get((Object)warehouse.getLatitude(), (double)0.0), GetterUtil.get((Object)warehouse.getLongitude(), (double)0.0), warehouse.getExternalReferenceCode(), this._serviceContextHelper.getServiceContext()) : this._updateWarehouse(commerceInventoryWarehouse, warehouse);
        this._updateNestedResources(warehouse, commerceInventoryWarehouse);
        return this._warehouseDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)commerceInventoryWarehouse.getCommerceInventoryWarehouseId(), this.contextAcceptLanguage.getPreferredLocale()));
    }

    private Warehouse _toWarehouse(CommerceInventoryWarehouse commerceInventoryWarehouse) throws Exception {
        return this._warehouseDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)commerceInventoryWarehouse.getCommerceInventoryWarehouseId(), this.contextAcceptLanguage.getPreferredLocale()));
    }

    private void _updateNestedResources(Warehouse warehouse, CommerceInventoryWarehouse commerceInventoryWarehouse) throws Exception {
        WarehouseItem[] warehouseItems = warehouse.getWarehouseItems();
        if (warehouseItems != null) {
            for (WarehouseItem warehouseItem : warehouseItems) {
                this._commerceInventoryWarehouseItemService.upsertCommerceInventoryWarehouseItem(this.contextUser.getUserId(), commerceInventoryWarehouse.getCommerceInventoryWarehouseId(), warehouseItem.getSku(), warehouseItem.getQuantity().intValue());
            }
        }
    }

    private CommerceInventoryWarehouse _updateWarehouse(CommerceInventoryWarehouse commerceInventoryWarehouse, Warehouse warehouse) throws Exception {
        commerceInventoryWarehouse = this._commerceInventoryWarehouseService.updateCommerceInventoryWarehouse(commerceInventoryWarehouse.getCommerceInventoryWarehouseId(), GetterUtil.get((String)warehouse.getName(), (String)commerceInventoryWarehouse.getName()), GetterUtil.get((String)warehouse.getDescription(), (String)commerceInventoryWarehouse.getDescription()), GetterUtil.get((Object)warehouse.getActive(), (boolean)commerceInventoryWarehouse.isActive()), GetterUtil.get((String)warehouse.getStreet1(), (String)commerceInventoryWarehouse.getStreet1()), GetterUtil.get((String)warehouse.getStreet2(), (String)commerceInventoryWarehouse.getStreet2()), GetterUtil.get((String)warehouse.getStreet3(), (String)commerceInventoryWarehouse.getStreet3()), GetterUtil.get((String)warehouse.getCity(), (String)commerceInventoryWarehouse.getCity()), GetterUtil.get((String)warehouse.getZip(), (String)commerceInventoryWarehouse.getZip()), GetterUtil.get((String)warehouse.getRegionISOCode(), (String)commerceInventoryWarehouse.getCommerceRegionCode()), GetterUtil.get((String)warehouse.getCountryISOCode(), (String)commerceInventoryWarehouse.getCountryTwoLettersISOCode()), GetterUtil.get((Object)warehouse.getLatitude(), (double)commerceInventoryWarehouse.getLatitude()), GetterUtil.get((Object)warehouse.getLongitude(), (double)commerceInventoryWarehouse.getLongitude()), GetterUtil.get((Object)warehouse.getMvccVersion(), (long)commerceInventoryWarehouse.getMvccVersion()), this._serviceContextHelper.getServiceContext());
        this._updateNestedResources(warehouse, commerceInventoryWarehouse);
        return commerceInventoryWarehouse;
    }
}

