/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.inventory.client.resource.v1_0;

import com.liferay.headless.commerce.admin.inventory.client.dto.v1_0.Warehouse;
import com.liferay.headless.commerce.admin.inventory.client.http.HttpInvoker;
import com.liferay.headless.commerce.admin.inventory.client.pagination.Page;
import com.liferay.headless.commerce.admin.inventory.client.pagination.Pagination;
import com.liferay.headless.commerce.admin.inventory.client.problem.Problem;
import com.liferay.headless.commerce.admin.inventory.client.serdes.v1_0.WarehouseSerDes;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public interface WarehouseResource {
    public static Builder builder() {
        return new Builder();
    }

    public void deleteWarehousByExternalReferenceCode(String var1) throws Exception;

    public HttpInvoker.HttpResponse deleteWarehousByExternalReferenceCodeHttpResponse(String var1) throws Exception;

    public Warehouse getWarehousByExternalReferenceCode(String var1) throws Exception;

    public HttpInvoker.HttpResponse getWarehousByExternalReferenceCodeHttpResponse(String var1) throws Exception;

    public void patchWarehousByExternalReferenceCode(String var1, Warehouse var2) throws Exception;

    public HttpInvoker.HttpResponse patchWarehousByExternalReferenceCodeHttpResponse(String var1, Warehouse var2) throws Exception;

    public void deleteWarehousId(Long var1) throws Exception;

    public HttpInvoker.HttpResponse deleteWarehousIdHttpResponse(Long var1) throws Exception;

    public Warehouse getWarehousId(Long var1) throws Exception;

    public HttpInvoker.HttpResponse getWarehousIdHttpResponse(Long var1) throws Exception;

    public void patchWarehousId(Long var1, Warehouse var2) throws Exception;

    public HttpInvoker.HttpResponse patchWarehousIdHttpResponse(Long var1, Warehouse var2) throws Exception;

    public Page<Warehouse> getWarehousesPage(String var1, Pagination var2, String var3) throws Exception;

    public HttpInvoker.HttpResponse getWarehousesPageHttpResponse(String var1, Pagination var2, String var3) throws Exception;

    public Warehouse postWarehous(Warehouse var1) throws Exception;

    public HttpInvoker.HttpResponse postWarehousHttpResponse(Warehouse var1) throws Exception;

    public static class WarehouseResourceImpl
    implements WarehouseResource {
        private static final Logger _logger = Logger.getLogger(WarehouseResource.class.getName());
        private Builder _builder;

        @Override
        public void deleteWarehousByExternalReferenceCode(String externalReferenceCode) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.deleteWarehousByExternalReferenceCodeHttpResponse(externalReferenceCode);
            String content = httpResponse.getContent();
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
        }

        @Override
        public HttpInvoker.HttpResponse deleteWarehousByExternalReferenceCodeHttpResponse(String externalReferenceCode) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.DELETE);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + "/o/headless-commerce-admin-inventory/v1.0/warehouses/by-externalReferenceCode/{externalReferenceCode}", externalReferenceCode);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public Warehouse getWarehousByExternalReferenceCode(String externalReferenceCode) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.getWarehousByExternalReferenceCodeHttpResponse(externalReferenceCode);
            String content = httpResponse.getContent();
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return WarehouseSerDes.toDTO(content);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse getWarehousByExternalReferenceCodeHttpResponse(String externalReferenceCode) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.GET);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + "/o/headless-commerce-admin-inventory/v1.0/warehouses/by-externalReferenceCode/{externalReferenceCode}", externalReferenceCode);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public void patchWarehousByExternalReferenceCode(String externalReferenceCode, Warehouse warehouse) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.patchWarehousByExternalReferenceCodeHttpResponse(externalReferenceCode, warehouse);
            String content = httpResponse.getContent();
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
        }

        @Override
        public HttpInvoker.HttpResponse patchWarehousByExternalReferenceCodeHttpResponse(String externalReferenceCode, Warehouse warehouse) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body(warehouse.toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.PATCH);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + "/o/headless-commerce-admin-inventory/v1.0/warehouses/by-externalReferenceCode/{externalReferenceCode}", externalReferenceCode);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public void deleteWarehousId(Long id) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.deleteWarehousIdHttpResponse(id);
            String content = httpResponse.getContent();
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
        }

        @Override
        public HttpInvoker.HttpResponse deleteWarehousIdHttpResponse(Long id) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.DELETE);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + "/o/headless-commerce-admin-inventory/v1.0/warehouses/{id}", id);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public Warehouse getWarehousId(Long id) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.getWarehousIdHttpResponse(id);
            String content = httpResponse.getContent();
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return WarehouseSerDes.toDTO(content);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse getWarehousIdHttpResponse(Long id) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.GET);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + "/o/headless-commerce-admin-inventory/v1.0/warehouses/{id}", id);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public void patchWarehousId(Long id, Warehouse warehouse) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.patchWarehousIdHttpResponse(id, warehouse);
            String content = httpResponse.getContent();
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
        }

        @Override
        public HttpInvoker.HttpResponse patchWarehousIdHttpResponse(Long id, Warehouse warehouse) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body(warehouse.toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.PATCH);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + "/o/headless-commerce-admin-inventory/v1.0/warehouses/{id}", id);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public Page<Warehouse> getWarehousesPage(String filterString, Pagination pagination, String sortString) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.getWarehousesPageHttpResponse(filterString, pagination, sortString);
            String content = httpResponse.getContent();
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return Page.of(content, WarehouseSerDes::toDTO);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse getWarehousesPageHttpResponse(String filterString, Pagination pagination, String sortString) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.GET);
            if (filterString != null) {
                httpInvoker.parameter("filter", filterString);
            }
            if (pagination != null) {
                httpInvoker.parameter("page", String.valueOf(pagination.getPage()));
                httpInvoker.parameter("pageSize", String.valueOf(pagination.getPageSize()));
            }
            if (sortString != null) {
                httpInvoker.parameter("sort", sortString);
            }
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + "/o/headless-commerce-admin-inventory/v1.0/warehouses", new Object[0]);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public Warehouse postWarehous(Warehouse warehouse) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.postWarehousHttpResponse(warehouse);
            String content = httpResponse.getContent();
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return WarehouseSerDes.toDTO(content);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse postWarehousHttpResponse(Warehouse warehouse) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body(warehouse.toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.POST);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + "/o/headless-commerce-admin-inventory/v1.0/warehouses", new Object[0]);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        private WarehouseResourceImpl(Builder builder) {
            this._builder = builder;
        }
    }

    public static class Builder {
        private Map<String, String> _headers = new LinkedHashMap<String, String>();
        private String _host = "localhost";
        private Locale _locale;
        private String _login = "";
        private String _password = "";
        private Map<String, String> _parameters = new LinkedHashMap<String, String>();
        private int _port = 8080;
        private String _scheme = "http";

        public Builder authentication(String login, String password) {
            this._login = login;
            this._password = password;
            return this;
        }

        public WarehouseResource build() {
            return new WarehouseResourceImpl(this);
        }

        public Builder endpoint(String host, int port, String scheme) {
            this._host = host;
            this._port = port;
            this._scheme = scheme;
            return this;
        }

        public Builder header(String key, String value) {
            this._headers.put(key, value);
            return this;
        }

        public Builder locale(Locale locale) {
            this._locale = locale;
            return this;
        }

        public Builder parameter(String key, String value) {
            this._parameters.put(key, value);
            return this;
        }

        private Builder() {
        }
    }
}

