/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.inventory.client.http;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Base64;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class HttpInvoker {
    private static final Logger _logger = Logger.getLogger(HttpInvoker.class.getName());
    private String _body;
    private String _contentType;
    private String _encodedUserNameAndPassword;
    private Map<String, File> _files = new LinkedHashMap<String, File>();
    private Map<String, String> _headers = new LinkedHashMap<String, String>();
    private HttpMethod _httpMethod = HttpMethod.GET;
    private String _multipartBoundary;
    private Map<String, String[]> _parameters = new LinkedHashMap<String, String[]>();
    private Map<String, String> _parts = new LinkedHashMap<String, String>();
    private String _path;

    public static HttpInvoker newHttpInvoker() {
        HttpInvoker._updateHttpURLConnectionClass();
        return new HttpInvoker();
    }

    public HttpInvoker body(String body, String contentType) {
        this._body = body;
        this._contentType = contentType;
        return this;
    }

    public HttpInvoker header(String name, String value) {
        this._headers.put(name, value);
        return this;
    }

    public HttpInvoker httpMethod(HttpMethod httpMethod) {
        this._httpMethod = httpMethod;
        return this;
    }

    public HttpResponse invoke() throws IOException {
        HttpResponse httpResponse = new HttpResponse();
        HttpURLConnection httpURLConnection = this._openHttpURLConnection();
        httpResponse.setContent(this._readResponse(httpURLConnection));
        httpResponse.setMessage(httpURLConnection.getResponseMessage());
        httpResponse.setStatusCode(httpURLConnection.getResponseCode());
        httpURLConnection.disconnect();
        return httpResponse;
    }

    public HttpInvoker multipart() {
        this._contentType = "multipart/form-data; charset=utf-8; boundary=__MULTIPART_BOUNDARY__";
        this._multipartBoundary = "__MULTIPART_BOUNDARY__";
        return this;
    }

    public HttpInvoker parameter(String name, String value) {
        return this.parameter(name, new String[]{value});
    }

    public HttpInvoker parameter(String name, String[] values) {
        String[] oldValues = this._parameters.get(name);
        if (oldValues != null) {
            String[] newValues = new String[oldValues.length + values.length];
            System.arraycopy(oldValues, 0, newValues, 0, oldValues.length);
            System.arraycopy(values, 0, newValues, oldValues.length, values.length);
            this._parameters.put(name, newValues);
        } else {
            this._parameters.put(name, values);
        }
        return this;
    }

    public HttpInvoker part(String name, File file) {
        this._files.put(name, file);
        return this;
    }

    public HttpInvoker part(String name, String value) {
        this._parts.put(name, value);
        return this;
    }

    public HttpInvoker path(String path, Object ... values) {
        for (int i = 0; values != null && i < values.length; ++i) {
            path = path.replaceFirst("\\{.*?\\}", String.valueOf(values[i]));
        }
        this._path = path;
        return this;
    }

    public HttpInvoker userNameAndPassword(String userNameAndPassword) throws IOException {
        Base64.Encoder encoder = Base64.getEncoder();
        this._encodedUserNameAndPassword = new String(encoder.encode(userNameAndPassword.getBytes("UTF-8")), "UTF-8");
        return this;
    }

    private static void _updateHttpURLConnectionClass() {
        try {
            Field methodsField = HttpURLConnection.class.getDeclaredField("methods");
            methodsField.setAccessible(true);
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(methodsField, methodsField.getModifiers() & 0xFFFFFFEF);
            LinkedHashSet<String> methodsFieldValue = new LinkedHashSet<String>(Arrays.asList((String[])methodsField.get(null)));
            if (methodsFieldValue.contains("PATCH")) {
                return;
            }
            methodsFieldValue.add("PATCH");
            methodsField.set(null, methodsFieldValue.toArray(new String[0]));
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            _logger.warning("Unable to update HttpURLConnection class");
        }
    }

    private HttpInvoker() {
    }

    private void _appendPart(OutputStream outputStream, PrintWriter printWriter, String key, Object value) throws IOException {
        printWriter.append("\r\n--");
        printWriter.append(this._multipartBoundary);
        printWriter.append("\r\nContent-Disposition: form-data; name=\"");
        printWriter.append(key);
        printWriter.append("\";");
        if (value instanceof File) {
            File file = (File)value;
            printWriter.append(" filename=\"");
            printWriter.append(file.getName());
            printWriter.append("\"\r\nContent-Type: ");
            printWriter.append(URLConnection.guessContentTypeFromName(file.getName()));
            printWriter.append("\r\n\r\n");
            printWriter.flush();
            byte[] buffer = new byte[4096];
            FileInputStream fileInputStream = new FileInputStream(file);
            int read = -1;
            while ((read = fileInputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, read);
            }
            outputStream.flush();
            fileInputStream.close();
        } else {
            printWriter.append("\r\n\r\n");
            printWriter.append(value.toString());
        }
        printWriter.append("\r\n");
    }

    private String _getQueryString() throws IOException {
        StringBuilder sb = new StringBuilder();
        Set<Map.Entry<String, String[]>> set = this._parameters.entrySet();
        Iterator<Map.Entry<String, String[]>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String[]> entry = iterator.next();
            String[] values = entry.getValue();
            for (int i = 0; i < values.length; ++i) {
                String name = URLEncoder.encode(entry.getKey(), "UTF-8");
                sb.append(name);
                sb.append("=");
                String value = URLEncoder.encode(values[i], "UTF-8");
                sb.append(value);
                if (i + 1 >= values.length) continue;
                sb.append("&");
            }
            if (!iterator.hasNext()) continue;
            sb.append("&");
        }
        return sb.toString();
    }

    private HttpURLConnection _openHttpURLConnection() throws IOException {
        String urlString = this._path;
        String queryString = this._getQueryString();
        if (queryString.length() > 0) {
            if (!urlString.contains("?")) {
                urlString = urlString + "?";
            }
            urlString = urlString + queryString;
        }
        URL url = new URL(urlString);
        HttpURLConnection httpURLConnection = (HttpURLConnection)url.openConnection();
        httpURLConnection.setRequestMethod(this._httpMethod.name());
        if (this._encodedUserNameAndPassword != null) {
            httpURLConnection.setRequestProperty("Authorization", "Basic " + this._encodedUserNameAndPassword);
        }
        if (this._contentType != null) {
            httpURLConnection.setRequestProperty("Content-Type", this._contentType);
        }
        for (Map.Entry<String, String> header : this._headers.entrySet()) {
            httpURLConnection.setRequestProperty(header.getKey(), header.getValue());
        }
        this._writeBody(httpURLConnection);
        return httpURLConnection;
    }

    private String _readResponse(HttpURLConnection httpURLConnection) throws IOException {
        String line;
        StringBuilder sb = new StringBuilder();
        int responseCode = httpURLConnection.getResponseCode();
        InputStream inputStream = null;
        inputStream = responseCode > 299 ? httpURLConnection.getErrorStream() : httpURLConnection.getInputStream();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        while ((line = bufferedReader.readLine()) != null) {
            sb.append(line);
        }
        bufferedReader.close();
        return sb.toString();
    }

    private void _writeBody(HttpURLConnection httpURLConnection) throws IOException {
        if (this._body == null && this._files.isEmpty() && this._parts.isEmpty()) {
            return;
        }
        if (this._httpMethod == HttpMethod.DELETE || this._httpMethod == HttpMethod.GET) {
            throw new IllegalArgumentException("HTTP method " + (Object)((Object)this._httpMethod) + " must not contain a body");
        }
        httpURLConnection.setDoOutput(true);
        OutputStream outputStream = httpURLConnection.getOutputStream();
        try (PrintWriter printWriter = new PrintWriter((Writer)new OutputStreamWriter(outputStream, "UTF-8"), true);){
            if (this._contentType.startsWith("multipart/form-data")) {
                for (Map.Entry<String, String> entry : this._parts.entrySet()) {
                    this._appendPart(outputStream, printWriter, entry.getKey(), entry.getValue());
                }
                for (Map.Entry<String, Object> entry : this._files.entrySet()) {
                    this._appendPart(outputStream, printWriter, entry.getKey(), entry.getValue());
                }
                printWriter.append("--" + this._multipartBoundary + "--");
                printWriter.flush();
                outputStream.flush();
            } else {
                printWriter.append(this._body);
                printWriter.flush();
            }
        }
    }

    public class HttpResponse {
        private String _content;
        private String _message;
        private int _statusCode;

        public String getContent() {
            return this._content;
        }

        public String getMessage() {
            return this._message;
        }

        public int getStatusCode() {
            return this._statusCode;
        }

        public void setContent(String content) {
            this._content = content;
        }

        public void setMessage(String message) {
            this._message = message;
        }

        public void setStatusCode(int statusCode) {
            this._statusCode = statusCode;
        }
    }

    public static enum HttpMethod {
        DELETE,
        GET,
        PATCH,
        POST,
        PUT;

    }
}

