/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.inventory.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.liferay.headless.commerce.admin.inventory.dto.v1_0.Channel;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlRootElement;

@GraphQLName(value="WarehouseChannel")
@JsonFilter(value="Liferay.Vulcan")
@Schema(requiredProperties={"channelId", "warehouseId"})
@XmlRootElement(name="WarehouseChannel")
public class WarehouseChannel
implements Serializable {
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected Map<String, Map<String, String>> actions;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected Channel channel;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String channelExternalReferenceCode;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @NotNull
    protected Long channelId;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected Long warehouseChannelId;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String warehouseExternalReferenceCode;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @NotNull
    protected Long warehouseId;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.commerce.admin.inventory.dto.v1_0.WarehouseChannel", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};

    public static WarehouseChannel toDTO(String json) {
        return (WarehouseChannel)ObjectMapperUtil.readValue(WarehouseChannel.class, (String)json);
    }

    public static WarehouseChannel unsafeToDTO(String json) {
        return (WarehouseChannel)ObjectMapperUtil.unsafeReadValue(WarehouseChannel.class, (String)json);
    }

    @Schema
    @Valid
    public Map<String, Map<String, String>> getActions() {
        return this.actions;
    }

    public void setActions(Map<String, Map<String, String>> actions) {
        this.actions = actions;
    }

    @JsonIgnore
    public void setActions(UnsafeSupplier<Map<String, Map<String, String>>, Exception> actionsUnsafeSupplier) {
        try {
            this.actions = (Map)actionsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema
    @Valid
    public Channel getChannel() {
        return this.channel;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    @JsonIgnore
    public void setChannel(UnsafeSupplier<Channel, Exception> channelUnsafeSupplier) {
        try {
            this.channel = (Channel)channelUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(example="PAB-34098-789-N")
    public String getChannelExternalReferenceCode() {
        return this.channelExternalReferenceCode;
    }

    public void setChannelExternalReferenceCode(String channelExternalReferenceCode) {
        this.channelExternalReferenceCode = channelExternalReferenceCode;
    }

    @JsonIgnore
    public void setChannelExternalReferenceCode(UnsafeSupplier<String, Exception> channelExternalReferenceCodeUnsafeSupplier) {
        try {
            this.channelExternalReferenceCode = (String)channelExternalReferenceCodeUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @DecimalMin(value="0")
    @Schema(example="30130")
    public @DecimalMin(value="0") Long getChannelId() {
        return this.channelId;
    }

    public void setChannelId(Long channelId) {
        this.channelId = channelId;
    }

    @JsonIgnore
    public void setChannelId(UnsafeSupplier<Long, Exception> channelIdUnsafeSupplier) {
        try {
            this.channelId = (Long)channelIdUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @DecimalMin(value="0")
    @Schema(example="30643")
    public @DecimalMin(value="0") Long getWarehouseChannelId() {
        return this.warehouseChannelId;
    }

    public void setWarehouseChannelId(Long warehouseChannelId) {
        this.warehouseChannelId = warehouseChannelId;
    }

    @JsonIgnore
    public void setWarehouseChannelId(UnsafeSupplier<Long, Exception> warehouseChannelIdUnsafeSupplier) {
        try {
            this.warehouseChannelId = (Long)warehouseChannelIdUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(example="DAB-34098-789-N")
    public String getWarehouseExternalReferenceCode() {
        return this.warehouseExternalReferenceCode;
    }

    public void setWarehouseExternalReferenceCode(String warehouseExternalReferenceCode) {
        this.warehouseExternalReferenceCode = warehouseExternalReferenceCode;
    }

    @JsonIgnore
    public void setWarehouseExternalReferenceCode(UnsafeSupplier<String, Exception> warehouseExternalReferenceCodeUnsafeSupplier) {
        try {
            this.warehouseExternalReferenceCode = (String)warehouseExternalReferenceCodeUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @DecimalMin(value="0")
    @Schema(example="30324")
    public @DecimalMin(value="0") Long getWarehouseId() {
        return this.warehouseId;
    }

    public void setWarehouseId(Long warehouseId) {
        this.warehouseId = warehouseId;
    }

    @JsonIgnore
    public void setWarehouseId(UnsafeSupplier<Long, Exception> warehouseIdUnsafeSupplier) {
        try {
            this.warehouseId = (Long)warehouseIdUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof WarehouseChannel)) {
            return false;
        }
        WarehouseChannel warehouseChannel = (WarehouseChannel)object;
        return Objects.equals(this.toString(), warehouseChannel.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        StringBundler sb = new StringBundler();
        sb.append("{");
        if (this.actions != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"actions\": ");
            sb.append(WarehouseChannel._toJSON(this.actions));
        }
        if (this.channel != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"channel\": ");
            sb.append(String.valueOf(this.channel));
        }
        if (this.channelExternalReferenceCode != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"channelExternalReferenceCode\": ");
            sb.append("\"");
            sb.append(WarehouseChannel._escape(this.channelExternalReferenceCode));
            sb.append("\"");
        }
        if (this.channelId != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"channelId\": ");
            sb.append((Object)this.channelId);
        }
        if (this.warehouseChannelId != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"warehouseChannelId\": ");
            sb.append((Object)this.warehouseChannelId);
        }
        if (this.warehouseExternalReferenceCode != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"warehouseExternalReferenceCode\": ");
            sb.append("\"");
            sb.append(WarehouseChannel._escape(this.warehouseExternalReferenceCode));
            sb.append("\"");
        }
        if (this.warehouseId != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"warehouseId\": ");
            sb.append((Object)this.warehouseId);
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(WarehouseChannel._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (WarehouseChannel._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(WarehouseChannel._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(WarehouseChannel._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }
}

