/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.channel.internal.graphql.query.v1_0;

import com.liferay.headless.commerce.admin.channel.dto.v1_0.Channel;
import com.liferay.headless.commerce.admin.channel.dto.v1_0.TaxCategory;
import com.liferay.headless.commerce.admin.channel.resource.v1_0.ChannelResource;
import com.liferay.headless.commerce.admin.channel.resource.v1_0.TaxCategoryResource;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiFunction;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.UriInfo;
import org.osgi.service.component.ComponentServiceObjects;

public class Query {
    private static ComponentServiceObjects<ChannelResource> _channelResourceComponentServiceObjects;
    private static ComponentServiceObjects<TaxCategoryResource> _taxCategoryResourceComponentServiceObjects;
    private AcceptLanguage _acceptLanguage;
    private Company _company;
    private BiFunction<Object, String, Filter> _filterBiFunction;
    private GroupLocalService _groupLocalService;
    private HttpServletRequest _httpServletRequest;
    private HttpServletResponse _httpServletResponse;
    private RoleLocalService _roleLocalService;
    private BiFunction<Object, String, Sort[]> _sortsBiFunction;
    private UriInfo _uriInfo;
    private User _user;

    public static void setChannelResourceComponentServiceObjects(ComponentServiceObjects<ChannelResource> channelResourceComponentServiceObjects) {
        _channelResourceComponentServiceObjects = channelResourceComponentServiceObjects;
    }

    public static void setTaxCategoryResourceComponentServiceObjects(ComponentServiceObjects<TaxCategoryResource> taxCategoryResourceComponentServiceObjects) {
        _taxCategoryResourceComponentServiceObjects = taxCategoryResourceComponentServiceObjects;
    }

    @GraphQLField(description="Retrieves channels.")
    public @GraphQLField(description="Retrieves channels.") ChannelPage channels(@GraphQLName(value="search") String search, @GraphQLName(value="filter") String filterString, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page, @GraphQLName(value="sort") String sortsString) throws Exception {
        return (ChannelPage)this._applyComponentServiceObjects(_channelResourceComponentServiceObjects, this::_populateResourceContext, channelResource -> new ChannelPage(channelResource.getChannelsPage(search, this._filterBiFunction.apply(channelResource, filterString), Pagination.of((int)page, (int)pageSize), this._sortsBiFunction.apply(channelResource, sortsString))));
    }

    @GraphQLField(description="Retrive information of the given Channel.")
    public @GraphQLField(description="Retrive information of the given Channel.") Channel channel(@GraphQLName(value="channelId") Long channelId) throws Exception {
        return (Channel)this._applyComponentServiceObjects(_channelResourceComponentServiceObjects, this::_populateResourceContext, channelResource -> channelResource.getChannel(channelId));
    }

    @GraphQLField
    public TaxCategoryPage taxCategories(@GraphQLName(value="search") String search, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page) throws Exception {
        return (TaxCategoryPage)this._applyComponentServiceObjects(_taxCategoryResourceComponentServiceObjects, this::_populateResourceContext, taxCategoryResource -> new TaxCategoryPage(taxCategoryResource.getTaxCategoriesPage(search, Pagination.of((int)page, (int)pageSize))));
    }

    @GraphQLField
    public TaxCategory taxCategory(@GraphQLName(value="id") Long id) throws Exception {
        return (TaxCategory)this._applyComponentServiceObjects(_taxCategoryResourceComponentServiceObjects, this::_populateResourceContext, taxCategoryResource -> taxCategoryResource.getTaxCategory(id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T, R, E1 extends Throwable, E2 extends Throwable> R _applyComponentServiceObjects(ComponentServiceObjects<T> componentServiceObjects, UnsafeConsumer<T, E1> unsafeConsumer, UnsafeFunction<T, R, E2> unsafeFunction) throws E1, E2 {
        Object resource = componentServiceObjects.getService();
        try {
            unsafeConsumer.accept(resource);
            Object object = unsafeFunction.apply(resource);
            return (R)object;
        }
        finally {
            componentServiceObjects.ungetService(resource);
        }
    }

    private void _populateResourceContext(ChannelResource channelResource) throws Exception {
        channelResource.setContextAcceptLanguage(this._acceptLanguage);
        channelResource.setContextCompany(this._company);
        channelResource.setContextHttpServletRequest(this._httpServletRequest);
        channelResource.setContextHttpServletResponse(this._httpServletResponse);
        channelResource.setContextUriInfo(this._uriInfo);
        channelResource.setContextUser(this._user);
        channelResource.setGroupLocalService(this._groupLocalService);
        channelResource.setRoleLocalService(this._roleLocalService);
    }

    private void _populateResourceContext(TaxCategoryResource taxCategoryResource) throws Exception {
        taxCategoryResource.setContextAcceptLanguage(this._acceptLanguage);
        taxCategoryResource.setContextCompany(this._company);
        taxCategoryResource.setContextHttpServletRequest(this._httpServletRequest);
        taxCategoryResource.setContextHttpServletResponse(this._httpServletResponse);
        taxCategoryResource.setContextUriInfo(this._uriInfo);
        taxCategoryResource.setContextUser(this._user);
        taxCategoryResource.setGroupLocalService(this._groupLocalService);
        taxCategoryResource.setRoleLocalService(this._roleLocalService);
    }

    @GraphQLName(value="TaxCategoryPage")
    public class TaxCategoryPage {
        @GraphQLField
        protected Map<String, Map> actions;
        @GraphQLField
        protected Collection<TaxCategory> items;
        @GraphQLField
        protected long lastPage;
        @GraphQLField
        protected long page;
        @GraphQLField
        protected long pageSize;
        @GraphQLField
        protected long totalCount;

        public TaxCategoryPage(Page taxCategoryPage) {
            this.actions = taxCategoryPage.getActions();
            this.items = taxCategoryPage.getItems();
            this.lastPage = taxCategoryPage.getLastPage();
            this.page = taxCategoryPage.getPage();
            this.pageSize = taxCategoryPage.getPageSize();
            this.totalCount = taxCategoryPage.getTotalCount();
        }
    }

    @GraphQLName(value="ChannelPage")
    public class ChannelPage {
        @GraphQLField
        protected Map<String, Map> actions;
        @GraphQLField
        protected Collection<Channel> items;
        @GraphQLField
        protected long lastPage;
        @GraphQLField
        protected long page;
        @GraphQLField
        protected long pageSize;
        @GraphQLField
        protected long totalCount;

        public ChannelPage(Page channelPage) {
            this.actions = channelPage.getActions();
            this.items = channelPage.getItems();
            this.lastPage = channelPage.getLastPage();
            this.page = channelPage.getPage();
            this.pageSize = channelPage.getPageSize();
            this.totalCount = channelPage.getTotalCount();
        }
    }
}

