/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter;

import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.model.CPInstanceOptionValueRel;
import com.liferay.commerce.product.service.CPInstanceService;
import com.liferay.commerce.product.util.CPInstanceHelper;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Sku;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.SkuOption;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.commerce.product.model.CPInstance"}, service={DTOConverter.class, SkuDTOConverter.class})
public class SkuDTOConverter
implements DTOConverter<CPInstance, Sku> {
    @Reference
    private CPInstanceHelper _cpInstanceHelper;
    @Reference
    private CPInstanceService _cpInstanceService;

    public String getContentType() {
        return Sku.class.getSimpleName();
    }

    public Sku toDTO(DTOConverterContext dtoConverterContext) throws Exception {
        final CPInstance cpInstance = this._cpInstanceService.getCPInstance(((Long)dtoConverterContext.getId()).longValue());
        final CPDefinition cpDefinition = cpInstance.getCPDefinition();
        final CPInstance replacementCPInstance = this._cpInstanceService.fetchCProductInstance(cpInstance.getReplacementCProductId(), cpInstance.getReplacementCPInstanceUuid());
        return new Sku(){
            {
                this.cost = cpInstance.getCost();
                this.depth = cpInstance.getDepth();
                this.discontinued = cpInstance.isDiscontinued();
                this.displayDate = cpInstance.getDisplayDate();
                this.expirationDate = cpInstance.getExpirationDate();
                this.externalReferenceCode = cpInstance.getExternalReferenceCode();
                this.gtin = cpInstance.getGtin();
                this.height = cpInstance.getHeight();
                this.id = cpInstance.getCPInstanceId();
                this.manufacturerPartNumber = cpInstance.getManufacturerPartNumber();
                this.price = cpInstance.getPrice();
                this.productId = cpDefinition.getCProductId();
                this.productName = LanguageUtils.getLanguageIdMap((Map)cpDefinition.getNameMap());
                this.promoPrice = cpInstance.getPromoPrice();
                this.published = cpInstance.isPublished();
                this.purchasable = cpInstance.isPurchasable();
                this.sku = cpInstance.getSku();
                this.unspsc = cpInstance.getUnspsc();
                this.weight = cpInstance.getWeight();
                this.width = cpInstance.getWidth();
                this.setSkuOptions(() -> {
                    ArrayList<1> skuOptions = new ArrayList<1>();
                    List cpInstanceOptionValueRels = SkuDTOConverter.this._cpInstanceHelper.getCPInstanceCPInstanceOptionValueRels(cpInstance.getCPInstanceId());
                    for (final CPInstanceOptionValueRel cpInstanceOptionValueRel : cpInstanceOptionValueRels) {
                        SkuOption skuOption = new SkuOption(){
                            {
                                this.key = cpInstanceOptionValueRel.getCPDefinitionOptionRelId();
                                this.value = cpInstanceOptionValueRel.getCPDefinitionOptionValueRelId();
                            }
                        };
                        skuOptions.add(skuOption);
                    }
                    return skuOptions.toArray(new SkuOption[0]);
                });
                this.setReplacementSkuId(() -> {
                    if (replacementCPInstance != null) {
                        return replacementCPInstance.getCPInstanceId();
                    }
                    return null;
                });
                this.setReplacementSkuExternalReferenceCode(() -> {
                    if (replacementCPInstance != null) {
                        return replacementCPInstance.getExternalReferenceCode();
                    }
                    return null;
                });
            }
        };
    }
}

