/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.commerce.order.content.web.internal.constants;

import com.liferay.commerce.constants.CommercePortletKeys;

/**
 * @author Marco Leo
 * @author Alessio Antonio Rendina
 */
public class CommerceOrderFDSNames {

	public static final String BILLING_ADDRESSES =
		CommercePortletKeys.COMMERCE_ORDER_CONTENT + "-billingAddress";

	public static final String IMPORT_ORDERS =
		CommercePortletKeys.COMMERCE_OPEN_ORDER_CONTENT + "-importOrders";

	public static final String PENDING_ORDER_ITEMS =
		CommercePortletKeys.COMMERCE_OPEN_ORDER_CONTENT + "-pendingOrderItems";

	public static final String PENDING_ORDERS =
		CommercePortletKeys.COMMERCE_OPEN_ORDER_CONTENT + "-pendingOrders";

	public static final String PLACED_ORDER_ITEMS =
		CommercePortletKeys.COMMERCE_ORDER_CONTENT + "-placedOrderItems";

	public static final String PLACED_ORDERS =
		CommercePortletKeys.COMMERCE_ORDER_CONTENT + "-placedOrders";

	public static final String PREVIEW_ORDER_ITEMS =
		CommercePortletKeys.COMMERCE_OPEN_ORDER_CONTENT + "-previewOrderItems";

	public static final String SHIPPING_ADDRESSES =
		CommercePortletKeys.COMMERCE_ORDER_CONTENT + "-shippingAddress";

	public static final String WISH_LISTS =
		CommercePortletKeys.COMMERCE_OPEN_ORDER_CONTENT + "-wishLists";

}