/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.media.internal;

import com.liferay.commerce.media.CommerceMediaProvider;
import com.liferay.commerce.media.internal.configuration.CommerceMediaDefaultImageConfiguration;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.module.configuration.ConfigurationProviderUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.settings.GroupServiceSettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocator;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, service={CommerceMediaProvider.class})
public class CommerceMediaProviderImpl
implements CommerceMediaProvider {
    private static final Log _log = LogFactoryUtil.getLog(CommerceMediaProviderImpl.class);
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private DLAppLocalService _dlAppLocalService;

    public FileEntry getDefaultImageFileEntry(long companyId, long groupId) throws Exception {
        CommerceMediaDefaultImageConfiguration commerceMediaDefaultImageConfiguration = (CommerceMediaDefaultImageConfiguration)ConfigurationProviderUtil.getConfiguration(CommerceMediaDefaultImageConfiguration.class, (SettingsLocator)new GroupServiceSettingsLocator(groupId, "com.liferay.commerce.media.internal.configuration.CommerceMediaDefaultImageConfiguration"));
        FileEntry fileEntry = null;
        try {
            fileEntry = this._dlAppLocalService.getFileEntry(commerceMediaDefaultImageConfiguration.defaultFileEntryId());
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)portalException);
            }
            Company company = this._companyLocalService.getCompany(companyId);
            fileEntry = this._dlAppLocalService.fetchFileEntryByExternalReferenceCode(company.getGroupId(), "image.default.company.logo");
        }
        return fileEntry;
    }
}

