/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.media.internal.servlet;

import com.liferay.commerce.media.CommerceMediaResolver;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.servlet.PortalSessionThreadLocal;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, property={"osgi.http.whiteboard.context.path=/commerce-media", "osgi.http.whiteboard.servlet.name=com.liferay.commerce.media.servlet.CommerceMediaServlet", "osgi.http.whiteboard.servlet.pattern=/commerce-media/*"}, service={Servlet.class})
public class CommerceMediaServlet
extends HttpServlet {
    private static final Log _log = LogFactoryUtil.getLog(CommerceMediaServlet.class);
    @Reference
    private CommerceMediaResolver _commerceMediaResolver;
    @Reference
    private Portal _portal;
    @Reference
    private UserLocalService _userLocalService;

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        if (PortalSessionThreadLocal.getHttpSession() == null) {
            PortalSessionThreadLocal.setHttpSession((HttpSession)httpServletRequest.getSession());
        }
        try {
            User user = this._portal.getUser(httpServletRequest);
            if (user == null) {
                user = this._userLocalService.getDefaultUser(this._portal.getCompanyId(httpServletRequest));
            }
            PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)user);
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
            PrincipalThreadLocal.setName((long)user.getUserId());
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            httpServletResponse.sendError(404);
            return;
        }
        String contentDisposition = "inline";
        boolean download = ParamUtil.getBoolean((HttpServletRequest)httpServletRequest, (String)"download");
        if (download) {
            contentDisposition = "attachment";
        }
        this._commerceMediaResolver.sendMediaBytes(httpServletRequest, httpServletResponse, contentDisposition);
    }
}

