/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.media.internal;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.commerce.media.CommerceMediaResolver;
import com.liferay.commerce.media.internal.configuration.CommerceMediaDefaultImageConfiguration;
import com.liferay.commerce.product.model.CPAttachmentFileEntry;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CProduct;
import com.liferay.commerce.product.model.CommerceCatalog;
import com.liferay.commerce.product.service.CPAttachmentFileEntryLocalService;
import com.liferay.commerce.product.service.CPDefinitionLocalService;
import com.liferay.commerce.product.service.CProductLocalService;
import com.liferay.commerce.product.service.CommerceCatalogLocalService;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.image.ImageToolUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Image;
import com.liferay.portal.kernel.module.configuration.ConfigurationProviderUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.servlet.PortalSessionThreadLocal;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.settings.GroupServiceSettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.util.File;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Html;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.URLCodec;
import com.liferay.portlet.asset.service.permission.AssetCategoryPermission;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, service={CommerceMediaResolver.class})
public class DefaultCommerceMediaResolver
implements CommerceMediaResolver {
    private static final Log _log = LogFactoryUtil.getLog(DefaultCommerceMediaResolver.class);
    @Reference
    private AssetCategoryLocalService _assetCategoryLocalService;
    @Reference
    private CommerceCatalogLocalService _commerceCatalogLocalService;
    @Reference(target="(model.class.name=com.liferay.commerce.product.model.CommerceCatalog)")
    private ModelResourcePermission<CommerceCatalog> _commerceCatalogModelResourcePermission;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private CPAttachmentFileEntryLocalService _cpAttachmentFileEntryLocalService;
    @Reference
    private CPDefinitionLocalService _cpDefinitionLocalService;
    @Reference
    private CProductLocalService _cProductLocalService;
    @Reference
    private DLAppLocalService _dlAppLocalService;
    @Reference
    private File _file;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private Html _html;
    @Reference
    private Http _http;
    @Reference
    private Portal _portal;

    public String getDefaultUrl(long groupId) {
        StringBundler sb = new StringBundler(5);
        sb.append(this._portal.getPathModule());
        sb.append("/");
        sb.append("commerce-media");
        sb.append("/default/?groupId=");
        sb.append(groupId);
        return this._html.escape(sb.toString());
    }

    public String getDownloadUrl(long cpAttachmentFileEntryId) throws PortalException {
        return this.getUrl(cpAttachmentFileEntryId, true, false);
    }

    public byte[] getMediaBytes(HttpServletRequest httpServletRequest) throws IOException, PortalException {
        return this.getBytes(this.getFileEntry(httpServletRequest));
    }

    public String getThumbnailUrl(long cpAttachmentFileEntryId) throws PortalException {
        return this.getUrl(cpAttachmentFileEntryId, false, true);
    }

    public String getUrl(long cpAttachmentFileEntryId) throws PortalException {
        return this.getUrl(cpAttachmentFileEntryId, false, false);
    }

    public String getUrl(long cpAttachmentFileEntryId, boolean download, boolean thumbnail) throws PortalException {
        return this.getUrl(cpAttachmentFileEntryId, download, thumbnail, true);
    }

    public String getUrl(long cpAttachmentFileEntryId, boolean download, boolean thumbnail, boolean secure) throws PortalException {
        StringBundler sb = new StringBundler(10);
        sb.append(this._portal.getPathModule());
        sb.append("/");
        sb.append("commerce-media");
        CPAttachmentFileEntry cpAttachmentFileEntry = null;
        cpAttachmentFileEntry = secure ? this._cpAttachmentFileEntryLocalService.fetchCPAttachmentFileEntry(cpAttachmentFileEntryId) : this._cpAttachmentFileEntryLocalService.fetchCPAttachmentFileEntry(cpAttachmentFileEntryId);
        if (cpAttachmentFileEntry == null) {
            HttpSession httpSession = PortalSessionThreadLocal.getHttpSession();
            if (httpSession == null) {
                return this._html.escape(sb.toString());
            }
            long companyId = GetterUtil.getLong((Object)httpSession.getAttribute("COMPANY_ID"));
            Company company = this._companyLocalService.getCompany(companyId);
            return this.getDefaultUrl(company.getGroupId());
        }
        Locale siteDefaultLocale = this._portal.getSiteDefaultLocale(cpAttachmentFileEntry.getGroupId());
        sb.append(this.setUrl(cpAttachmentFileEntry.getClassName(), cpAttachmentFileEntry.getClassPK(), siteDefaultLocale));
        sb.append("/");
        sb.append(cpAttachmentFileEntry.getFileEntryId());
        sb.append("/");
        sb.append(URLCodec.encodeURL((String)StringUtil.replace((String)cpAttachmentFileEntry.getTitle(siteDefaultLocale), (char)'/', (String)""), (boolean)true));
        sb.append("?download=");
        sb.append(download);
        return this._html.escape(sb.toString());
    }

    public void sendMediaBytes(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        this.sendMediaBytes(httpServletRequest, httpServletResponse, null);
    }

    public void sendMediaBytes(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String contentDisposition) throws IOException {
        String path = this._http.fixPath(httpServletRequest.getPathInfo());
        String[] pathArray = StringUtil.split((String)path, (char)'/');
        if (pathArray.length < 2) {
            long groupId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"groupId");
            if (groupId == 0L) {
                httpServletResponse.sendError(404);
                return;
            }
            this.sendDefaultMediaBytes(groupId, httpServletRequest, httpServletResponse, contentDisposition);
            return;
        }
        long groupId = this.getGroupId(pathArray[0], GetterUtil.getLong((String)pathArray[1]));
        if (groupId == 0L) {
            httpServletResponse.sendError(404);
            return;
        }
        try {
            FileEntry fileEntry = this.getFileEntry(httpServletRequest);
            if (fileEntry == null) {
                this.sendDefaultMediaBytes(groupId, httpServletRequest, httpServletResponse, contentDisposition);
                return;
            }
            ServletResponseUtil.sendFile((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (String)fileEntry.getFileName(), (byte[])this.getBytes(fileEntry), (String)fileEntry.getMimeType(), (String)contentDisposition);
        }
        catch (PortalException portalException) {
            _log.error((Object)portalException, (Throwable)portalException);
            httpServletResponse.sendError(404);
        }
    }

    protected byte[] getBytes(FileEntry fileEntry) throws IOException, PortalException {
        return this._file.getBytes(fileEntry.getContentStream());
    }

    protected FileEntry getFileEntry(HttpServletRequest httpServletRequest) throws PortalException {
        String path = this._http.fixPath(httpServletRequest.getPathInfo());
        String[] pathArray = StringUtil.split((String)path, (char)'/');
        if (pathArray.length < 2) {
            return null;
        }
        long fileEntryId = GetterUtil.getLong((String)pathArray[pathArray.length - 2]);
        return this.getFileEntry(fileEntryId);
    }

    protected FileEntry getFileEntry(long fileEntryId) {
        try {
            return this._dlAppLocalService.getFileEntry(fileEntryId);
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)portalException, (Throwable)portalException);
            }
            return null;
        }
    }

    protected long getGroupId(String mediaType, long primaryKey) {
        if (mediaType.equals("asset-categories")) {
            AssetCategory assetCategory = this._assetCategoryLocalService.fetchCategory(primaryKey);
            try {
                if (AssetCategoryPermission.contains((PermissionChecker)PermissionThreadLocal.getPermissionChecker(), (AssetCategory)assetCategory, (String)"VIEW")) {
                    Company company = this._companyLocalService.getCompany(assetCategory.getCompanyId());
                    return company.getGroupId();
                }
            }
            catch (PortalException portalException) {
                _log.error((Object)portalException, (Throwable)portalException);
            }
        } else if (mediaType.equals("products")) {
            CProduct cProduct = this._cProductLocalService.fetchCProduct(primaryKey);
            CommerceCatalog commerceCatalog = this._commerceCatalogLocalService.fetchCommerceCatalogByGroupId(cProduct.getGroupId());
            return commerceCatalog.getGroupId();
        }
        return 0L;
    }

    protected void sendDefaultMediaBytes(long groupId, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String contentDisposition) throws IOException {
        try {
            CommerceMediaDefaultImageConfiguration commerceMediaDefaultImageConfiguration = (CommerceMediaDefaultImageConfiguration)ConfigurationProviderUtil.getConfiguration(CommerceMediaDefaultImageConfiguration.class, (SettingsLocator)new GroupServiceSettingsLocator(groupId, "com.liferay.commerce.media.internal.configuration.CommerceMediaDefaultImageConfiguration"));
            FileEntry fileEntry = this.getFileEntry(commerceMediaDefaultImageConfiguration.defaultFileEntryId());
            if (fileEntry == null) {
                Company company = this._portal.getCompany(httpServletRequest);
                Image image = ImageToolUtil.getDefaultCompanyLogo();
                ServletResponseUtil.sendFile((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (String)company.getName(), (byte[])image.getTextObj(), (String)image.getType(), (String)contentDisposition);
                return;
            }
            ServletResponseUtil.sendFile((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (String)fileEntry.getFileName(), (byte[])this.getBytes(fileEntry), (String)fileEntry.getMimeType(), (String)contentDisposition);
        }
        catch (PortalException portalException) {
            _log.error((Object)portalException, (Throwable)portalException);
            httpServletResponse.sendError(404);
        }
    }

    protected String setUrl(String className, long classPK, Locale locale) throws PortalException {
        StringBundler sb = new StringBundler(4);
        if (className.equals(CPDefinition.class.getName())) {
            sb.append("/products/");
            CPDefinition cpDefinition = this._cpDefinitionLocalService.getCPDefinition(classPK);
            sb.append(cpDefinition.getCProductId());
            sb.append("/");
            Map titleMap = cpDefinition.getUrlTitleMap();
            sb.append((String)titleMap.get(locale));
        } else if (className.equals(AssetCategory.class.getName())) {
            sb.append("/asset-categories/");
            AssetCategory assetCategory = this._assetCategoryLocalService.getAssetCategory(classPK);
            sb.append(assetCategory.getCategoryId());
            sb.append("/");
            Map titleMap = assetCategory.getTitleMap();
            sb.append((String)titleMap.get(locale));
        } else {
            throw new UnsupportedOperationException();
        }
        return sb.toString();
    }
}

