/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.initializer.util;

import com.liferay.account.exception.NoSuchGroupException;
import com.liferay.account.model.AccountGroup;
import com.liferay.account.service.AccountGroupLocalService;
import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.currency.service.CommerceCurrencyLocalService;
import com.liferay.commerce.price.list.model.CommercePriceList;
import com.liferay.commerce.price.list.model.CommercePriceListCommerceAccountGroupRel;
import com.liferay.commerce.price.list.service.CommercePriceListCommerceAccountGroupRelLocalService;
import com.liferay.commerce.price.list.service.CommercePriceListLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.FriendlyURLNormalizer;
import com.liferay.portal.kernel.util.Validator;
import java.util.Calendar;
import java.util.TimeZone;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CommercePriceListsImporter.class})
public class CommercePriceListsImporter {
    private static final Log _log = LogFactoryUtil.getLog(CommercePriceListsImporter.class);
    @Reference
    private AccountGroupLocalService _accountGroupLocalService;
    @Reference
    private CommerceCurrencyLocalService _commerceCurrencyLocalService;
    @Reference
    private CommercePriceListCommerceAccountGroupRelLocalService _commercePriceListCommerceAccountGroupRelLocalService;
    @Reference
    private CommercePriceListLocalService _commercePriceListLocalService;
    @Reference
    private FriendlyURLNormalizer _friendlyURLNormalizer;
    @Reference
    private UserLocalService _userLocalService;

    public void importCommercePriceLists(long catalogGroupId, JSONArray jsonArray, long scopeGroupId, long userId) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setCompanyId(user.getCompanyId());
        serviceContext.setScopeGroupId(scopeGroupId);
        serviceContext.setUserId(userId);
        for (int i = 0; i < jsonArray.length(); ++i) {
            this._importCommercePriceList(catalogGroupId, jsonArray.getJSONObject(i), serviceContext);
        }
    }

    private void _importCommercePriceList(long catalogGroupId, JSONObject jsonObject, ServiceContext serviceContext) throws PortalException {
        JSONArray accountGroupsJSONArray;
        String name;
        String currencyCode = jsonObject.getString("currencyCode");
        if (Validator.isNull((String)currencyCode)) {
            return;
        }
        long parentPriceListId = 0L;
        String parentPriceListName = jsonObject.getString("parentPriceList");
        if (!Validator.isBlank((String)parentPriceListName)) {
            String externalReferenceCode = this._friendlyURLNormalizer.normalize(parentPriceListName);
            CommercePriceList parentPriceList = this._commercePriceListLocalService.fetchCommercePriceListByExternalReferenceCode(externalReferenceCode, serviceContext.getCompanyId());
            parentPriceListId = parentPriceList.getParentCommercePriceListId();
        }
        if (Validator.isBlank((String)(name = jsonObject.getString("name")))) {
            return;
        }
        User user = this._userLocalService.getUser(serviceContext.getUserId());
        Calendar displayCalendar = CalendarFactoryUtil.getCalendar((TimeZone)user.getTimeZone());
        int displayDateMonth = displayCalendar.get(jsonObject.getInt("displayDateMonth", 2));
        int displayDateDay = displayCalendar.get(jsonObject.getInt("displayDateDayOfMonth", 5));
        int displayDateYear = displayCalendar.get(jsonObject.getInt("displayDateYear", 1));
        int displayDateHour = displayCalendar.get(jsonObject.getInt("displayDateHour", 10));
        int displayDateMinute = displayCalendar.get(jsonObject.getInt("displayDateMinute", 12));
        int displayDateAmPm = displayCalendar.get(jsonObject.getInt("displayDateAmPm", 9));
        if (displayDateAmPm == 1) {
            displayDateHour += 12;
        }
        Calendar expirationCalendar = CalendarFactoryUtil.getCalendar((TimeZone)user.getTimeZone());
        expirationCalendar.add(2, 1);
        int expirationDateMonth = expirationCalendar.get(jsonObject.getInt("expirationDateMonth", 2));
        int expirationDateDay = expirationCalendar.get(jsonObject.getInt("expirationDateDayOfMonth", 5));
        int expirationDateYear = expirationCalendar.get(jsonObject.getInt("expirationDateYear", 1));
        int expirationDateHour = expirationCalendar.get(jsonObject.getInt("expirationDateHour", 10));
        int expirationDateMinute = expirationCalendar.get(jsonObject.getInt("expirationDateMinute", 12));
        int expirationDateAmPm = expirationCalendar.get(jsonObject.getInt("expirationDateAmPm", 9));
        if (expirationDateAmPm == 1) {
            expirationDateHour += 12;
        }
        if ((accountGroupsJSONArray = jsonObject.getJSONArray("accountGroups")) != null) {
            int priority = jsonObject.getInt("priority");
            boolean neverExpire = jsonObject.getBoolean("neverExpire", true);
            CommerceCurrency commerceCurrency = this._commerceCurrencyLocalService.getCommerceCurrency(serviceContext.getCompanyId(), currencyCode);
            String externalReferenceCode = this._friendlyURLNormalizer.normalize(name);
            CommercePriceList commercePriceList = this._commercePriceListLocalService.addOrUpdateCommercePriceList(externalReferenceCode, catalogGroupId, user.getUserId(), 0L, commerceCurrency.getCommerceCurrencyId(), true, "price-list", parentPriceListId, false, name, (double)priority, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
            for (int i = 0; i < accountGroupsJSONArray.length(); ++i) {
                try {
                    String accountGroupExternalReferenceCode = this._friendlyURLNormalizer.normalize(accountGroupsJSONArray.getString(i));
                    AccountGroup accountGroup = this._accountGroupLocalService.fetchAccountGroupByExternalReferenceCode(accountGroupExternalReferenceCode, serviceContext.getCompanyId());
                    if (accountGroup == null) {
                        throw new NoSuchGroupException();
                    }
                    CommercePriceListCommerceAccountGroupRel commercePriceListCommerceAccountGroupRel = this._commercePriceListCommerceAccountGroupRelLocalService.fetchCommercePriceListCommerceAccountGroupRel(commercePriceList.getCommercePriceListId(), accountGroup.getAccountGroupId());
                    if (commercePriceListCommerceAccountGroupRel != null) continue;
                    this._commercePriceListCommerceAccountGroupRelLocalService.addCommercePriceListCommerceAccountGroupRel(serviceContext.getUserId(), commercePriceList.getCommercePriceListId(), accountGroup.getAccountGroupId(), 0, serviceContext);
                    continue;
                }
                catch (NoSuchGroupException noSuchGroupException) {
                    _log.error((Throwable)noSuchGroupException);
                }
            }
        }
    }
}

