/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.initializer.util;

import com.liferay.commerce.initializer.util.internal.CommerceInitializerUtil;
import com.liferay.commerce.product.model.CPOptionCategory;
import com.liferay.commerce.product.model.CPSpecificationOption;
import com.liferay.commerce.product.service.CPOptionCategoryLocalService;
import com.liferay.commerce.product.service.CPSpecificationOptionLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CPSpecificationOptionsImporter.class})
public class CPSpecificationOptionsImporter {
    @Reference
    private CPOptionCategoryLocalService _cpOptionCategoryLocalService;
    @Reference
    private CPSpecificationOptionLocalService _cpSpecificationOptionLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public List<CPSpecificationOption> importCPSpecificationOptions(JSONArray jsonArray, long scopeGroupId, long userId) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setCompanyId(user.getCompanyId());
        serviceContext.setScopeGroupId(scopeGroupId);
        serviceContext.setUserId(userId);
        ArrayList<CPSpecificationOption> cpSpecificationOptions = new ArrayList<CPSpecificationOption>(jsonArray.length());
        for (int i = 0; i < jsonArray.length(); ++i) {
            CPSpecificationOption cpSpecificationOption = this._importCPSpecificationOption(jsonArray.getJSONObject(i), serviceContext);
            cpSpecificationOptions.add(cpSpecificationOption);
        }
        return cpSpecificationOptions;
    }

    private CPSpecificationOption _importCPSpecificationOption(JSONObject jsonObject, ServiceContext serviceContext) throws PortalException {
        long cpOptionCategoryId = 0L;
        String categoryKey = jsonObject.getString("categoryKey");
        if (Validator.isNotNull((String)categoryKey)) {
            CPOptionCategory cpOptionCategory = this._cpOptionCategoryLocalService.getCPOptionCategory(serviceContext.getCompanyId(), categoryKey);
            cpOptionCategoryId = cpOptionCategory.getCPOptionCategoryId();
        }
        Locale locale = LocaleUtil.getSiteDefault();
        String key = jsonObject.getString("key");
        Map<Locale, String> titleMap = Collections.singletonMap(locale, CommerceInitializerUtil.getValue(jsonObject, "title", key));
        Map<Locale, String> descriptionMap = Collections.singletonMap(locale, jsonObject.getString("description"));
        boolean facetable = jsonObject.getBoolean("facetable");
        CPSpecificationOption cpSpecificationOption = this._cpSpecificationOptionLocalService.fetchCPSpecificationOption(serviceContext.getCompanyId(), key);
        if (cpSpecificationOption != null) {
            return this._cpSpecificationOptionLocalService.updateCPSpecificationOption(cpSpecificationOption.getCPSpecificationOptionId(), cpOptionCategoryId, titleMap, descriptionMap, facetable, key, serviceContext);
        }
        return this._cpSpecificationOptionLocalService.addCPSpecificationOption(serviceContext.getUserId(), cpOptionCategoryId, titleMap, descriptionMap, facetable, key, serviceContext);
    }
}

