/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.initializer.util;

import com.liferay.blogs.model.BlogsEntry;
import com.liferay.blogs.service.BlogsEntryLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.servlet.taglib.ui.ImageSelector;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.File;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import java.io.InputStream;
import java.util.Date;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={BlogsImporter.class})
public class BlogsImporter {
    @Reference
    private BlogsEntryLocalService _blogsEntryLocalService;
    @Reference
    private File _file;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private ResourcePermissionLocalService _resourcePermissionLocalService;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public void importBlogsEntries(JSONArray jsonArray, ClassLoader classLoader, String imageDependenciesPath, long scopeGroupId, long userId) throws Exception {
        User user = this._userLocalService.getUser(userId);
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setCompanyId(user.getCompanyId());
        serviceContext.setScopeGroupId(scopeGroupId);
        serviceContext.setUserId(userId);
        Date date = new Date();
        for (int i = 0; i < jsonArray.length(); ++i) {
            this._addBlogsEntry(jsonArray.getJSONObject(i), classLoader, imageDependenciesPath, userId, date, serviceContext);
        }
    }

    protected void updatePermissions(long companyId, String name, String primKey, JSONArray jsonArray) throws PortalException {
        if (jsonArray == null) {
            jsonArray = this._jsonFactory.createJSONArray("[{\"actionIds\": [\"VIEW\"], \"roleName\": \"Site Member\",\"scope\": 4}]");
        }
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            int scope = jsonObject.getInt("scope");
            String roleName = jsonObject.getString("roleName");
            Role role = this._roleLocalService.getRole(companyId, roleName);
            Object[] actionIds = new String[]{};
            JSONArray actionIdsJSONArray = jsonObject.getJSONArray("actionIds");
            if (actionIdsJSONArray != null) {
                for (int j = 0; j < actionIdsJSONArray.length(); ++j) {
                    actionIds = (String[])ArrayUtil.append((Object[])actionIds, (Object)actionIdsJSONArray.getString(j));
                }
            }
            this._resourcePermissionLocalService.setResourcePermissions(companyId, name, scope, primKey, role.getRoleId(), (String[])actionIds);
        }
    }

    private void _addBlogsEntry(JSONObject jsonObject, ClassLoader classLoader, String imageDependenciesPath, long userId, Date displayDate, ServiceContext serviceContext) throws Exception {
        String content = jsonObject.getString("content");
        String title = jsonObject.getString("title");
        BlogsEntry blogsEntry = this._blogsEntryLocalService.addEntry(userId, title, content, displayDate, serviceContext);
        JSONArray permissionsJSONArray = jsonObject.getJSONArray("permissions");
        if (permissionsJSONArray != null && permissionsJSONArray.length() > 0) {
            this.updatePermissions(blogsEntry.getCompanyId(), blogsEntry.getModelClassName(), String.valueOf(blogsEntry.getPrimaryKey()), permissionsJSONArray);
        } else {
            this.updatePermissions(blogsEntry.getCompanyId(), blogsEntry.getModelClassName(), String.valueOf(blogsEntry.getPrimaryKey()), null);
        }
        String fileName = jsonObject.getString("coverImageFileName");
        InputStream inputStream = classLoader.getResourceAsStream(imageDependenciesPath + fileName);
        ImageSelector imageSelector = new ImageSelector(this._file.getBytes(inputStream), fileName, MimeTypesUtil.getContentType((String)fileName), "");
        this._blogsEntryLocalService.addCoverImage(blogsEntry.getEntryId(), imageSelector);
        JSONArray tagsJSONArray = jsonObject.getJSONArray("tags");
        String[] assetTagNames = ArrayUtil.toStringArray((JSONArray)tagsJSONArray);
        if (assetTagNames.length > 0) {
            this._blogsEntryLocalService.updateAsset(userId, blogsEntry, new long[0], assetTagNames, new long[0], null);
        }
    }
}

