/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.initializer.util;

import com.liferay.account.model.AccountEntry;
import com.liferay.commerce.account.exception.NoSuchAccountGroupException;
import com.liferay.commerce.account.model.CommerceAccount;
import com.liferay.commerce.account.model.CommerceAccountGroup;
import com.liferay.commerce.account.model.CommerceAccountGroupCommerceAccountRel;
import com.liferay.commerce.account.model.CommerceAccountOrganizationRel;
import com.liferay.commerce.account.service.CommerceAccountGroupCommerceAccountRelLocalService;
import com.liferay.commerce.account.service.CommerceAccountGroupLocalService;
import com.liferay.commerce.account.service.CommerceAccountLocalService;
import com.liferay.commerce.account.service.CommerceAccountOrganizationRelLocalService;
import com.liferay.commerce.account.service.persistence.CommerceAccountOrganizationRelPK;
import com.liferay.commerce.exception.NoSuchCountryException;
import com.liferay.commerce.price.list.exception.NoSuchPriceListException;
import com.liferay.commerce.price.list.model.CommercePriceList;
import com.liferay.commerce.price.list.service.CommercePriceListAccountRelLocalService;
import com.liferay.commerce.price.list.service.CommercePriceListLocalService;
import com.liferay.commerce.service.CommerceAddressLocalService;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Country;
import com.liferay.portal.kernel.model.ListTypeConstants;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Region;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.CountryLocalService;
import com.liferay.portal.kernel.service.OrganizationLocalService;
import com.liferay.portal.kernel.service.RegionLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.File;
import com.liferay.portal.kernel.util.FriendlyURLNormalizer;
import com.liferay.portal.kernel.util.Validator;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CommerceAccountsImporter.class})
public class CommerceAccountsImporter {
    private static final Log _log = LogFactoryUtil.getLog(CommerceAccountsImporter.class);
    @Reference
    private CommerceAccountGroupCommerceAccountRelLocalService _commerceAccountGroupCommerceAccountRelLocalService;
    @Reference
    private CommerceAccountGroupLocalService _commerceAccountGroupLocalService;
    @Reference
    private CommerceAccountLocalService _commerceAccountLocalService;
    @Reference
    private CommerceAccountOrganizationRelLocalService _commerceAccountOrganizationRelLocalService;
    @Reference
    private CommerceAddressLocalService _commerceAddressLocalService;
    @Reference
    private CommercePriceListAccountRelLocalService _commercePriceListAccountRelLocalService;
    @Reference
    private CommercePriceListLocalService _commercePriceListLocalService;
    @Reference
    private CountryLocalService _countryLocalService;
    @Reference
    private File _file;
    @Reference
    private FriendlyURLNormalizer _friendlyURLNormalizer;
    @Reference
    private OrganizationLocalService _organizationLocalService;
    @Reference
    private RegionLocalService _regionLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public void importCommerceAccounts(JSONArray jsonArray, ClassLoader classLoader, String dependenciesPath, long scopeGroupId, long userId) throws Exception {
        User user = this._userLocalService.getUser(userId);
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setCompanyId(user.getCompanyId());
        serviceContext.setScopeGroupId(scopeGroupId);
        serviceContext.setUserId(userId);
        for (int i = 0; i < jsonArray.length(); ++i) {
            this._importCommerceAccount(jsonArray.getJSONObject(i), classLoader, dependenciesPath, serviceContext);
        }
    }

    protected Country getCountry(String twoLetterISOCode) throws PortalException {
        DynamicQuery dynamicQuery = this._countryLocalService.dynamicQuery();
        Property nameProperty = PropertyFactoryUtil.forName((String)"a2");
        dynamicQuery.add(nameProperty.eq((Object)twoLetterISOCode));
        List countries = this._countryLocalService.dynamicQuery(dynamicQuery, 0, 1);
        if (countries.isEmpty()) {
            throw new NoSuchCountryException("No country exists with two-letter ISO " + twoLetterISOCode);
        }
        return (Country)countries.get(0);
    }

    private void _importCommerceAccount(JSONObject jsonObject, ClassLoader classLoader, String dependenciesPath, ServiceContext serviceContext) throws Exception {
        JSONArray accountGroupsJSONArray;
        JSONArray priceListsJSONArray;
        String relatedOrganization;
        String name = jsonObject.getString("name");
        CommerceAccount commerceAccount = this._commerceAccountLocalService.fetchCommerceAccountByReferenceCode(serviceContext.getCompanyId(), this._friendlyURLNormalizer.normalize(name));
        if (commerceAccount != null) {
            return;
        }
        String accountType = jsonObject.getString("accountType");
        String email = jsonObject.getString("email");
        String taxId = jsonObject.getString("taxId");
        int commerceAccountType = 1;
        if (accountType.equals("Business")) {
            commerceAccountType = 2;
        }
        commerceAccount = this._commerceAccountLocalService.addCommerceAccount(name, 0L, email, taxId, commerceAccountType, true, this._friendlyURLNormalizer.normalize(name), serviceContext);
        String twoLetterISOCode = jsonObject.getString("country");
        Country country = this.getCountry(twoLetterISOCode);
        long regionId = 0L;
        String regionCode = jsonObject.getString("region");
        if (!Validator.isBlank((String)regionCode)) {
            try {
                Region region = this._regionLocalService.getRegion(country.getCountryId(), regionCode);
                regionId = region.getRegionId();
            }
            catch (PortalException portalException) {
                _log.error((Throwable)portalException);
            }
        }
        String street1 = jsonObject.getString("street1");
        String city = jsonObject.getString("city");
        String zip = jsonObject.getString("zip");
        this._commerceAddressLocalService.addCommerceAddress(AccountEntry.class.getName(), commerceAccount.getCommerceAccountId(), commerceAccount.getName(), "", street1, "", "", city, zip, regionId, country.getCountryId(), "", true, true, serviceContext);
        String companyLogo = jsonObject.getString("companyLogo");
        if (!Validator.isBlank((String)companyLogo)) {
            String filePath = dependenciesPath + "images/" + companyLogo;
            try (InputStream inputStream = classLoader.getResourceAsStream(filePath);){
                if (inputStream == null) {
                    throw new FileNotFoundException("No file found at " + filePath);
                }
                this._commerceAccountLocalService.updateCommerceAccount(commerceAccount.getCommerceAccountId(), commerceAccount.getName(), true, this._file.getBytes(inputStream), commerceAccount.getEmail(), commerceAccount.getTaxId(), true, serviceContext);
            }
        }
        if (!Validator.isBlank((String)(relatedOrganization = jsonObject.getString("relatedOrganization")))) {
            CommerceAccountOrganizationRelPK commerceAccountOrganizationRelPK;
            CommerceAccountOrganizationRel commerceAccountOrganizationRel;
            Organization organization = this._organizationLocalService.fetchOrganization(serviceContext.getCompanyId(), relatedOrganization);
            if (organization == null) {
                organization = this._organizationLocalService.addOrganization(serviceContext.getUserId(), 0L, name, "organization", 0L, 0L, (long)ListTypeConstants.ORGANIZATION_STATUS_DEFAULT, "", false, serviceContext);
            }
            if ((commerceAccountOrganizationRel = this._commerceAccountOrganizationRelLocalService.fetchCommerceAccountOrganizationRel(commerceAccountOrganizationRelPK = new CommerceAccountOrganizationRelPK(commerceAccount.getCommerceAccountId(), organization.getOrganizationId()))) == null) {
                this._commerceAccountOrganizationRelLocalService.addCommerceAccountOrganizationRel(commerceAccount.getCommerceAccountId(), organization.getOrganizationId(), serviceContext);
            }
        }
        if ((priceListsJSONArray = jsonObject.getJSONArray("priceLists")) != null) {
            for (int i = 0; i < priceListsJSONArray.length(); ++i) {
                try {
                    String externalReferenceCode = this._friendlyURLNormalizer.normalize(priceListsJSONArray.getString(i));
                    CommercePriceList commercePriceList = this._commercePriceListLocalService.fetchByExternalReferenceCode(externalReferenceCode, serviceContext.getCompanyId());
                    if (commercePriceList == null) continue;
                    this._commercePriceListAccountRelLocalService.addCommercePriceListAccountRel(serviceContext.getUserId(), commercePriceList.getCommercePriceListId(), commerceAccount.getCommerceAccountId(), 0, serviceContext);
                    continue;
                }
                catch (NoSuchPriceListException noSuchPriceListException) {
                    _log.error((Throwable)noSuchPriceListException);
                }
            }
        }
        if ((accountGroupsJSONArray = jsonObject.getJSONArray("accountGroups")) != null) {
            for (int i = 0; i < accountGroupsJSONArray.length(); ++i) {
                try {
                    CommerceAccountGroupCommerceAccountRel commerceAccountGroupCommerceAccountRel;
                    String accountGroupName = accountGroupsJSONArray.getString(i);
                    String externalReferenceCode = this._friendlyURLNormalizer.normalize(accountGroupName);
                    CommerceAccountGroup commerceAccountGroup = this._commerceAccountGroupLocalService.fetchByExternalReferenceCode(serviceContext.getCompanyId(), externalReferenceCode);
                    if (commerceAccountGroup == null) {
                        commerceAccountGroup = this._commerceAccountGroupLocalService.addCommerceAccountGroup(serviceContext.getCompanyId(), accountGroupName, 2, false, externalReferenceCode, serviceContext);
                    }
                    if ((commerceAccountGroupCommerceAccountRel = this._commerceAccountGroupCommerceAccountRelLocalService.fetchCommerceAccountGroupCommerceAccountRel(commerceAccountGroup.getCommerceAccountGroupId(), commerceAccount.getCommerceAccountId())) != null) continue;
                    this._commerceAccountGroupCommerceAccountRelLocalService.addCommerceAccountGroupCommerceAccountRel(commerceAccountGroup.getCommerceAccountGroupId(), commerceAccount.getCommerceAccountId(), serviceContext);
                    continue;
                }
                catch (NoSuchAccountGroupException noSuchAccountGroupException) {
                    _log.error((Throwable)noSuchAccountGroupException);
                }
            }
        }
    }
}

