/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.initializer.util;

import com.liferay.asset.kernel.model.AssetVocabulary;
import com.liferay.asset.kernel.service.AssetVocabularyLocalService;
import com.liferay.commerce.product.importer.CPFileImporter;
import com.liferay.dynamic.data.mapping.model.DDMFormInstance;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceLocalService;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.service.JournalArticleLocalService;
import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.display.template.PortletDisplayTemplate;
import java.io.File;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import javax.portlet.PortletPreferences;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, service={PortletSettingsImporter.class})
public class PortletSettingsImporter {
    @Reference
    private AssetVocabularyLocalService _assetVocabularyLocalService;
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private CPFileImporter _cpFileImporter;
    @Reference
    private DDMFormInstanceLocalService _ddmFormInstanceLocalService;
    @Reference
    private JournalArticleLocalService _journalArticleLocalService;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private UserLocalService _userLocalService;

    public void importPortletSettings(JSONArray jsonArray, ClassLoader classLoader, String displayTemplateDependenciesPath, long scopeGroupId, long assetVocabularyGroupId, long userId) throws Exception {
        User user = this._userLocalService.getUser(userId);
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setScopeGroupId(scopeGroupId);
        serviceContext.setUserId(userId);
        serviceContext.setCompanyId(user.getCompanyId());
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            String portletName = jsonObject.getString("portletName");
            JSONArray layoutFriendlyURLJSONArray = jsonObject.getJSONArray("layoutFriendlyURLs");
            if (layoutFriendlyURLJSONArray != null) {
                for (int j = 0; j < layoutFriendlyURLJSONArray.length(); ++j) {
                    if (jsonObject.has("layoutFriendlyURL")) {
                        jsonObject.remove("layoutFriendlyURL");
                    }
                    jsonObject.put("layoutFriendlyURL", layoutFriendlyURLJSONArray.get(j));
                    this._importPortletSettings(jsonObject, portletName, classLoader, displayTemplateDependenciesPath, assetVocabularyGroupId, serviceContext);
                }
                continue;
            }
            this._importPortletSettings(jsonObject, portletName, classLoader, displayTemplateDependenciesPath, assetVocabularyGroupId, serviceContext);
        }
    }

    private String _importDisplayTemplate(JSONObject jsonObject, ClassLoader classLoader, String displayTemplateDependenciesPath, ServiceContext serviceContext) throws Exception {
        DDMTemplate ddmTemplate;
        String fileName = jsonObject.getString("FileName");
        String name = jsonObject.getString("Name");
        String portletClassName = jsonObject.getString("PortletClassName");
        long classNameId = this._portal.getClassNameId(portletClassName);
        long resourceClassNameId = this._portal.getClassNameId(PortletDisplayTemplate.class);
        File file = null;
        if (Validator.isNotNull((String)fileName)) {
            InputStream inputStream = classLoader.getResourceAsStream(displayTemplateDependenciesPath + fileName);
            file = FileUtil.createTempFile((InputStream)inputStream);
        }
        if ((ddmTemplate = this._cpFileImporter.getDDMTemplate(file, classNameId, 0L, resourceClassNameId, name, "display", null, "ftl", serviceContext)) == null) {
            return "";
        }
        return "ddmTemplate_" + ddmTemplate.getTemplateKey();
    }

    private void _importPortletSettings(JSONObject jsonObject, String portletName, ClassLoader classLoader, String displayTemplateDependenciesPath, long assetVocabularyGroupId, ServiceContext serviceContext) throws Exception {
        long groupId = serviceContext.getScopeGroupId();
        String instanceId = jsonObject.getString("instanceId");
        String layoutFriendlyURL = jsonObject.getString("layoutFriendlyURL");
        JSONObject portletPreferencesJSONObject = jsonObject.getJSONObject("portletPreferences");
        String portletId = PortletIdCodec.encode((String)portletName, (String)instanceId);
        Layout layout = null;
        if (Validator.isNotNull((String)layoutFriendlyURL) && (layout = this._layoutLocalService.fetchLayoutByFriendlyURL(groupId, false, layoutFriendlyURL)) == null) {
            layout = this._layoutLocalService.fetchLayoutByFriendlyURL(groupId, true, layoutFriendlyURL);
        }
        PortletPreferences portletSetup = null;
        portletSetup = layout != null ? PortletPreferencesFactoryUtil.getLayoutPortletSetup((Layout)layout, (String)portletId) : PortletPreferencesFactoryUtil.getLayoutPortletSetup((long)serviceContext.getCompanyId(), (long)groupId, (int)3, (long)0L, (String)portletId, (String)"");
        Iterator iterator = portletPreferencesJSONObject.keys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            String value = null;
            if (key.equals("assetEntryId")) {
                value = portletPreferencesJSONObject.getString(key);
                JournalArticle journalArticle = this._journalArticleLocalService.fetchArticle(serviceContext.getScopeGroupId(), value);
                value = journalArticle != null ? String.valueOf(journalArticle.getPrimaryKey()) : "0";
            } else if (key.equals("assetVocabularyId")) {
                value = portletPreferencesJSONObject.getString(key);
                if (Validator.isBlank((String)value)) {
                    Group group = serviceContext.getScopeGroup();
                    value = group.getName(serviceContext.getLanguageId());
                }
                String vocabularyName = value;
                if (value != null) {
                    vocabularyName = value.trim();
                    vocabularyName = StringUtil.toLowerCase((String)vocabularyName);
                }
                AssetVocabulary assetVocabulary = this._assetVocabularyLocalService.getGroupVocabulary(assetVocabularyGroupId, vocabularyName);
                value = String.valueOf(assetVocabulary.getVocabularyId());
            } else if (key.equals("classNameIds") || key.equals("anyAssetType")) {
                String className = portletPreferencesJSONObject.getString(key);
                value = String.valueOf(this._classNameLocalService.getClassNameId(className));
            } else if (key.equals("displayStyle")) {
                JSONObject displayStyleJSONObject = portletPreferencesJSONObject.getJSONObject(key);
                value = this._importDisplayTemplate(displayStyleJSONObject, classLoader, displayTemplateDependenciesPath, serviceContext);
                String templateName = displayStyleJSONObject.getString("Name");
                if (Validator.isBlank((String)value) && templateName.contains("ddmTemplate_")) {
                    value = templateName;
                }
            } else if (key.equals("displayStyleGroupId")) {
                value = String.valueOf(groupId);
            } else if (key.equals("formInstanceId")) {
                Criterion criterion;
                DynamicQuery dynamicQuery = this._ddmFormInstanceLocalService.dynamicQuery();
                List ddmFormInstances = this._ddmFormInstanceLocalService.dynamicQuery(dynamicQuery.add(criterion = RestrictionsFactoryUtil.eq((String)"groupId", (Object)groupId)));
                if (!ddmFormInstances.isEmpty()) {
                    DDMFormInstance ddmFormInstance = (DDMFormInstance)ddmFormInstances.get(0);
                    value = String.valueOf(ddmFormInstance.getFormInstanceId());
                }
            } else if (key.equals("groupId")) {
                value = String.valueOf(groupId);
            } else if (key.equals("portletSetupTitle")) {
                value = portletPreferencesJSONObject.getString(key);
                key = key + '_' + serviceContext.getLanguageId();
            } else if (key.equals("preferenceDisplayStyle")) {
                value = portletPreferencesJSONObject.getString(key);
                key = "displayStyle";
            } else {
                value = portletPreferencesJSONObject.getString(key);
            }
            portletSetup.setValue(key, value);
        }
        portletSetup.store();
    }
}

