/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.initializer.util;

import com.liferay.commerce.account.exception.NoSuchAccountGroupException;
import com.liferay.commerce.account.model.CommerceAccountGroup;
import com.liferay.commerce.account.service.CommerceAccountGroupLocalService;
import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.currency.service.CommerceCurrencyLocalService;
import com.liferay.commerce.price.list.model.CommercePriceList;
import com.liferay.commerce.price.list.model.CommercePriceListCommerceAccountGroupRel;
import com.liferay.commerce.price.list.service.CommercePriceListCommerceAccountGroupRelLocalService;
import com.liferay.commerce.price.list.service.CommercePriceListLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.FriendlyURLNormalizerUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Calendar;
import java.util.TimeZone;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, service={CommercePriceListsImporter.class})
public class CommercePriceListsImporter {
    private static final Log _log = LogFactoryUtil.getLog(CommercePriceListsImporter.class);
    @Reference
    private CommerceAccountGroupLocalService _commerceAccountGroupLocalService;
    @Reference
    private CommerceCurrencyLocalService _commerceCurrencyLocalService;
    @Reference
    private CommercePriceListCommerceAccountGroupRelLocalService _commercePriceListCommerceAccountGroupRelLocalService;
    @Reference
    private CommercePriceListLocalService _commercePriceListLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public void importCommercePriceLists(long catalogGroupId, JSONArray jsonArray, long scopeGroupId, long userId) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setScopeGroupId(scopeGroupId);
        serviceContext.setUserId(userId);
        serviceContext.setCompanyId(user.getCompanyId());
        for (int i = 0; i < jsonArray.length(); ++i) {
            this._importCommercePriceList(catalogGroupId, jsonArray.getJSONObject(i), serviceContext);
        }
    }

    private void _importCommercePriceList(long catalogGroupId, JSONObject jsonObject, ServiceContext serviceContext) throws PortalException {
        String name;
        String currencyCode = jsonObject.getString("CurrencyCode");
        if (Validator.isNull((String)currencyCode)) {
            return;
        }
        long parentPriceListId = 0L;
        String parentPriceListName = jsonObject.getString("ParentPriceList");
        if (!Validator.isBlank((String)parentPriceListName)) {
            String externalReferenceCode = FriendlyURLNormalizerUtil.normalize((String)parentPriceListName);
            CommercePriceList parentPriceList = this._commercePriceListLocalService.fetchCommercePriceListByReferenceCode(serviceContext.getCompanyId(), externalReferenceCode);
            parentPriceListId = parentPriceList.getParentCommercePriceListId();
        }
        if (Validator.isBlank((String)(name = jsonObject.getString("Name")))) {
            return;
        }
        CommerceCurrency commerceCurrency = this._commerceCurrencyLocalService.getCommerceCurrency(serviceContext.getCompanyId(), currencyCode);
        User user = this._userLocalService.getUser(serviceContext.getUserId());
        int priority = jsonObject.getInt("Priority");
        Calendar displayCalendar = CalendarFactoryUtil.getCalendar((TimeZone)user.getTimeZone());
        int displayDateMonth = displayCalendar.get(jsonObject.getInt("DisplayDateMonth", 2));
        int displayDateDay = displayCalendar.get(jsonObject.getInt("DisplayDateDayOfMonth", 5));
        int displayDateYear = displayCalendar.get(jsonObject.getInt("DisplayDateYear", 1));
        int displayDateHour = displayCalendar.get(jsonObject.getInt("DisplayDateHour", 10));
        int displayDateMinute = displayCalendar.get(jsonObject.getInt("DisplayDateMinute", 12));
        int displayDateAmPm = displayCalendar.get(jsonObject.getInt("DisplayDateAmPm", 9));
        if (displayDateAmPm == 1) {
            displayDateHour += 12;
        }
        Calendar expirationCalendar = CalendarFactoryUtil.getCalendar((TimeZone)user.getTimeZone());
        expirationCalendar.add(2, 1);
        int expirationDateMonth = expirationCalendar.get(jsonObject.getInt("ExpirationDateMonth", 2));
        int expirationDateDay = expirationCalendar.get(jsonObject.getInt("ExpirationDateDayOfMonth", 5));
        int expirationDateYear = expirationCalendar.get(jsonObject.getInt("ExpirationDateYear", 1));
        int expirationDateHour = expirationCalendar.get(jsonObject.getInt("ExpirationDateHour", 10));
        int expirationDateMinute = expirationCalendar.get(jsonObject.getInt("ExpirationDateMinute", 12));
        int expirationDateAmPm = expirationCalendar.get(jsonObject.getInt("ExpirationDateAmPm", 9));
        if (expirationDateAmPm == 1) {
            expirationDateHour += 12;
        }
        boolean neverExpire = jsonObject.getBoolean("NeverExpire", true);
        String externalReferenceCode = FriendlyURLNormalizerUtil.normalize((String)name);
        CommercePriceList commercePriceList = this._commercePriceListLocalService.upsertCommercePriceList(catalogGroupId, user.getUserId(), 0L, commerceCurrency.getCommerceCurrencyId(), parentPriceListId, name, (double)priority, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, externalReferenceCode, neverExpire, serviceContext);
        JSONArray accountGroupsJSONArray = jsonObject.getJSONArray("AccountGroups");
        if (accountGroupsJSONArray != null) {
            for (int i = 0; i < accountGroupsJSONArray.length(); ++i) {
                try {
                    String accountGroupExternalReferenceCode = FriendlyURLNormalizerUtil.normalize((String)accountGroupsJSONArray.getString(i));
                    CommerceAccountGroup commerceAccountGroup = this._commerceAccountGroupLocalService.fetchCommerceAccountGroupByReferenceCode(serviceContext.getCompanyId(), accountGroupExternalReferenceCode);
                    if (commerceAccountGroup == null) {
                        throw new NoSuchAccountGroupException();
                    }
                    CommercePriceListCommerceAccountGroupRel commercePriceListCommerceAccountGroupRel = this._commercePriceListCommerceAccountGroupRelLocalService.fetchCommercePriceListCommerceAccountGroupRel(commercePriceList.getCommercePriceListId(), commerceAccountGroup.getCommerceAccountGroupId());
                    if (commercePriceListCommerceAccountGroupRel != null) continue;
                    this._commercePriceListCommerceAccountGroupRelLocalService.addCommercePriceListCommerceAccountGroupRel(commercePriceList.getCommercePriceListId(), commerceAccountGroup.getCommerceAccountGroupId(), 0, serviceContext);
                    continue;
                }
                catch (NoSuchAccountGroupException noSuchAccountGroupException) {
                    _log.error((Object)noSuchAccountGroupException, (Throwable)noSuchAccountGroupException);
                }
            }
        }
    }
}

