/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.initializer.util;

import com.liferay.commerce.price.list.exception.NoSuchPriceListException;
import com.liferay.commerce.price.list.model.CommercePriceEntry;
import com.liferay.commerce.price.list.model.CommercePriceList;
import com.liferay.commerce.price.list.service.CommercePriceEntryLocalService;
import com.liferay.commerce.price.list.service.CommercePriceListLocalService;
import com.liferay.commerce.pricing.configuration.CommercePricingConfiguration;
import com.liferay.commerce.product.exception.NoSuchCPInstanceException;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.model.CommerceCatalog;
import com.liferay.commerce.product.service.CPDefinitionLocalService;
import com.liferay.commerce.product.service.CPInstanceLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.settings.SystemSettingsLocator;
import com.liferay.portal.kernel.util.FriendlyURLNormalizerUtil;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, service={CommercePriceEntriesImporter.class})
public class CommercePriceEntriesImporter {
    private static final Log _log = LogFactoryUtil.getLog(CommercePriceEntriesImporter.class);
    @Reference
    private CommercePriceEntryLocalService _commercePriceEntryLocalService;
    @Reference
    private CommercePriceListLocalService _commercePriceListLocalService;
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private CPDefinitionLocalService _cpDefinitionLocalService;
    @Reference
    private CPInstanceLocalService _cpInstanceLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public void importBaseCommercePriceListEntries(CommerceCatalog commerceCatalog, List<CPDefinition> cpDefinitions, String priceListType) throws PortalException {
        CommercePricingConfiguration commercePricingConfiguration = (CommercePricingConfiguration)this._configurationProvider.getConfiguration(CommercePricingConfiguration.class, (SettingsLocator)new SystemSettingsLocator("com.liferay.commerce.pricing.service.name"));
        if (!Objects.equals(commercePricingConfiguration.commercePricingCalculationKey(), "v2.0")) {
            return;
        }
        CommercePriceList catalogBaseCommercePriceList = this._commercePriceListLocalService.fetchCatalogBaseCommercePriceListByType(commerceCatalog.getGroupId(), priceListType);
        if (catalogBaseCommercePriceList == null) {
            if (_log.isWarnEnabled()) {
                if (priceListType.equals("price-list")) {
                    _log.warn((Object)"Catalog base price list is not present");
                } else if (priceListType.equals("promotion")) {
                    _log.warn((Object)"Catalog base promotion is not present");
                }
            }
            return;
        }
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setScopeGroupId(commerceCatalog.getGroupId());
        serviceContext.setUserId(commerceCatalog.getUserId());
        serviceContext.setCompanyId(commerceCatalog.getCompanyId());
        for (CPDefinition cpDefinition : cpDefinitions) {
            this._importBaseCommercePriceListEntries(cpDefinition, catalogBaseCommercePriceList, serviceContext);
        }
    }

    public void importCommercePriceEntries(JSONArray jsonArray, long scopeGroupId, long userId) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setScopeGroupId(scopeGroupId);
        serviceContext.setUserId(userId);
        serviceContext.setCompanyId(user.getCompanyId());
        for (int i = 0; i < jsonArray.length(); ++i) {
            this._importCommercePriceEntry(jsonArray.getJSONObject(i), serviceContext);
        }
    }

    private void _importBaseCommercePriceListEntries(CPDefinition cpDefinition, CommercePriceList commercePriceList, ServiceContext serviceContext) throws PortalException {
        List cpInstances = this._cpInstanceLocalService.getCPDefinitionApprovedCPInstances(cpDefinition.getCPDefinitionId());
        for (CPInstance cpInstance : cpInstances) {
            BigDecimal price = cpInstance.getPrice();
            if ("promotion".equals(commercePriceList.getType())) {
                price = cpInstance.getPromoPrice();
            }
            this._commercePriceEntryLocalService.addCommercePriceEntry(cpDefinition.getCProductId(), cpInstance.getCPInstanceUuid(), commercePriceList.getCommercePriceListId(), price, BigDecimal.ZERO, serviceContext);
        }
    }

    private void _importCommercePriceEntry(JSONObject jsonObject, ServiceContext serviceContext) throws PortalException {
        String name = jsonObject.getString("PriceList");
        String priceListExternalReferenceCode = FriendlyURLNormalizerUtil.normalize((String)name);
        CommercePriceList commercePriceList = this._commercePriceListLocalService.fetchByExternalReferenceCode(serviceContext.getCompanyId(), priceListExternalReferenceCode);
        if (commercePriceList == null) {
            throw new NoSuchPriceListException("No price list found with name " + name);
        }
        String sku = jsonObject.getString("Sku");
        String externalReferenceCode = FriendlyURLNormalizerUtil.normalize((String)sku);
        CPInstance cpInstance = this._cpInstanceLocalService.fetchByExternalReferenceCode(serviceContext.getCompanyId(), externalReferenceCode);
        if (cpInstance == null) {
            throw new NoSuchCPInstanceException("No cpInstance found with sku " + sku);
        }
        CommercePriceEntry commercePriceEntry = this._commercePriceEntryLocalService.fetchCommercePriceEntry(commercePriceList.getCommercePriceListId(), cpInstance.getCPInstanceUuid());
        if (commercePriceEntry != null) {
            return;
        }
        CPDefinition cpDefinition = this._cpDefinitionLocalService.fetchCPDefinition(cpInstance.getCPDefinitionId());
        double price = jsonObject.getDouble("Price", 0.0);
        double promoPrice = jsonObject.getDouble("PromoPrice", 0.0);
        this._commercePriceEntryLocalService.addCommercePriceEntry(cpDefinition.getCProductId(), cpInstance.getCPInstanceUuid(), commercePriceList.getCommercePriceListId(), BigDecimal.valueOf(price), BigDecimal.valueOf(promoPrice), serviceContext);
    }
}

