/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.initializer.util;

import com.liferay.commerce.account.configuration.CommerceAccountGroupServiceConfiguration;
import com.liferay.commerce.account.model.CommerceAccount;
import com.liferay.commerce.account.model.CommerceAccountUserRel;
import com.liferay.commerce.account.service.CommerceAccountLocalService;
import com.liferay.commerce.account.service.CommerceAccountUserRelLocalService;
import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.context.CommerceContextFactory;
import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.currency.service.CommerceCurrencyLocalService;
import com.liferay.commerce.inventory.CPDefinitionInventoryEngine;
import com.liferay.commerce.inventory.CPDefinitionInventoryEngineRegistry;
import com.liferay.commerce.inventory.engine.CommerceInventoryEngine;
import com.liferay.commerce.model.CPDefinitionInventory;
import com.liferay.commerce.model.CommerceAddress;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceShippingEngine;
import com.liferay.commerce.model.CommerceShippingMethod;
import com.liferay.commerce.model.CommerceShippingOption;
import com.liferay.commerce.order.engine.CommerceOrderEngine;
import com.liferay.commerce.product.catalog.CPCatalogEntry;
import com.liferay.commerce.product.catalog.CPQuery;
import com.liferay.commerce.product.catalog.CPSku;
import com.liferay.commerce.product.data.source.CPDataSourceResult;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.service.CPInstanceLocalService;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.product.util.CPDefinitionHelper;
import com.liferay.commerce.service.CPDefinitionInventoryLocalService;
import com.liferay.commerce.service.CommerceAddressLocalService;
import com.liferay.commerce.service.CommerceOrderItemLocalService;
import com.liferay.commerce.service.CommerceOrderLocalService;
import com.liferay.commerce.service.CommerceShippingMethodLocalService;
import com.liferay.commerce.util.CommerceShippingEngineRegistry;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactory;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.settings.GroupServiceSettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.TransactionConfig;
import com.liferay.portal.kernel.transaction.TransactionInvokerUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Callable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, service={CommerceOrderGenerator.class})
public class CommerceOrderGenerator {
    private static final Log _log = LogFactoryUtil.getLog(CommerceOrderGenerator.class);
    private static final TransactionConfig _transactionConfig = TransactionConfig.Factory.create((Propagation)Propagation.REQUIRED, (Class[])new Class[]{Exception.class}, (Class[])new Class[0]);
    @Reference
    private CommerceAccountLocalService _commerceAccountLocalService;
    @Reference
    private CommerceAccountUserRelLocalService _commerceAccountUserRelLocalService;
    @Reference
    private CommerceAddressLocalService _commerceAddressLocalService;
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private CommerceContextFactory _commerceContextFactory;
    @Reference
    private CommerceCurrencyLocalService _commerceCurrencyLocalService;
    @Reference
    private CommerceInventoryEngine _commerceInventoryEngine;
    @Reference
    private CommerceOrderEngine _commerceOrderEngine;
    @Reference
    private CommerceOrderItemLocalService _commerceOrderItemLocalService;
    @Reference
    private CommerceOrderLocalService _commerceOrderLocalService;
    @Reference
    private CommerceShippingEngineRegistry _commerceShippingEngineRegistry;
    @Reference
    private CommerceShippingMethodLocalService _commerceShippingMethodLocalService;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private CPDefinitionHelper _cpDefinitionHelper;
    @Reference
    private CPDefinitionInventoryEngineRegistry _cpDefinitionInventoryEngineRegistry;
    @Reference
    private CPDefinitionInventoryLocalService _cpDefinitionInventoryLocalService;
    @Reference
    private CPInstanceLocalService _cpInstanceLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private PermissionCheckerFactory _permissionCheckerFactory;
    private final Random _random = new Random();
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public void generate(long groupId, int ordersCount) {
        GenerateOrdersCallable generateOrdersCallable = new GenerateOrdersCallable(groupId, ordersCount);
        try {
            TransactionInvokerUtil.invoke((TransactionConfig)_transactionConfig, (Callable)generateOrdersCallable);
        }
        catch (Throwable throwable) {
            _log.error((Object)throwable, throwable);
        }
    }

    private void _generateCommerceOrder(long groupId, CommerceAccount commerceAccount, List<CPCatalogEntry> cpCatalogEntries, long commerceShippingMethodId, CommerceShippingEngine commerceShippingEngine) throws PortalException {
        List commerceAccountUserRels = this._commerceAccountUserRelLocalService.getCommerceAccountUserRels(commerceAccount.getCommerceAccountId(), 0, 1);
        if (commerceAccountUserRels.isEmpty()) {
            String message = "There are no users related to the account " + commerceAccount.getCommerceAccountId();
            if (_log.isInfoEnabled()) {
                _log.info((Object)message);
            }
            throw new PortalException(message);
        }
        CommerceAccountUserRel commerceAccountUserRel = (CommerceAccountUserRel)commerceAccountUserRels.get(0);
        CommerceCurrency commerceCurrency = this._commerceCurrencyLocalService.fetchPrimaryCommerceCurrency(commerceAccount.getCompanyId());
        CommerceOrder commerceOrder = this._commerceOrderLocalService.addCommerceOrder(commerceAccountUserRel.getCommerceAccountUserId(), this._commerceChannelLocalService.getCommerceChannelGroupIdBySiteGroupId(groupId), commerceAccountUserRel.getCommerceAccountId(), commerceCurrency.getCommerceCurrencyId());
        CommerceContext commerceContext = this._commerceContextFactory.create(commerceOrder.getCompanyId(), commerceOrder.getGroupId(), commerceAccountUserRel.getCommerceAccountUserId(), commerceOrder.getCommerceOrderId(), commerceAccountUserRel.getCommerceAccountId());
        ServiceContext serviceContext = this._getServiceContext(commerceOrder);
        this._generateCommerceOrderItems(commerceOrder, cpCatalogEntries, commerceContext, serviceContext);
        commerceOrder = this._commerceOrderLocalService.recalculatePrice(commerceOrder.getCommerceOrderId(), commerceContext);
        List commerceAddresses = this._commerceAddressLocalService.getCommerceAddressesByCompanyId(commerceAccount.getCompanyId(), CommerceAccount.class.getName(), commerceAccount.getCommerceAccountId(), 0, 1, null);
        if (commerceAddresses.isEmpty()) {
            String message = "There are no addresses related to the account " + commerceAccount.getCommerceAccountId();
            if (_log.isInfoEnabled()) {
                _log.info((Object)message);
            }
            throw new PortalException(message);
        }
        CommerceAddress commerceAddress = (CommerceAddress)commerceAddresses.get(0);
        commerceOrder.setShippingAddressId(commerceAddress.getCommerceAddressId());
        String commerceShippingOptionName = commerceOrder.getShippingOptionName();
        List commerceShippingOptions = commerceShippingEngine.getCommerceShippingOptions(commerceContext, commerceOrder, serviceContext.getLocale());
        if (!commerceShippingOptions.isEmpty()) {
            CommerceShippingOption commerceShippingOption = (CommerceShippingOption)commerceShippingOptions.get(0);
            commerceShippingOptionName = commerceShippingOption.getName();
        }
        commerceOrder = this._commerceOrderLocalService.updateCommerceOrder(commerceOrder.getCommerceOrderId(), commerceAddress.getCommerceAddressId(), commerceAddress.getCommerceAddressId(), commerceOrder.getCommercePaymentMethodKey(), commerceShippingMethodId, commerceShippingOptionName, commerceOrder.getPurchaseOrderNumber(), commerceOrder.getSubtotal(), commerceOrder.getShippingAmount(), commerceOrder.getTotal(), commerceOrder.getAdvanceStatus(), commerceContext);
        this._commerceOrderEngine.transitionCommerceOrder(commerceOrder, 6, serviceContext.getUserId());
        this._commerceOrderLocalService.updatePaymentStatus(commerceOrder.getUserId(), commerceOrder.getCommerceOrderId(), 0);
    }

    private void _generateCommerceOrderItems(CommerceOrder commerceOrder, List<CPCatalogEntry> cpCatalogEntries, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        for (CPCatalogEntry cpCatalogEntry : cpCatalogEntries) {
            CPDefinitionInventory cpDefinitionInventory;
            CPDefinitionInventoryEngine cpDefinitionInventoryEngine;
            CPSku cpSku;
            CPInstance cpInstance;
            int maxOrderQuantity;
            List cpSkus = cpCatalogEntry.getCPSkus();
            if (cpSkus.isEmpty() || (maxOrderQuantity = this._getMaxOrderQuantity(cpInstance = this._cpInstanceLocalService.getCPInstance((cpSku = (CPSku)cpSkus.get(0)).getCPInstanceId()), cpDefinitionInventoryEngine = this._cpDefinitionInventoryEngineRegistry.getCPDefinitionInventoryEngine(cpDefinitionInventory = this._cpDefinitionInventoryLocalService.fetchCPDefinitionInventoryByCPDefinitionId(cpInstance.getCPDefinitionId())))) < 1) continue;
            try {
                int quantity = this._randomInt(cpDefinitionInventoryEngine.getMinOrderQuantity(cpInstance), maxOrderQuantity);
                this._commerceOrderItemLocalService.addCommerceOrderItem(commerceOrder.getCommerceOrderId(), cpInstance.getCPInstanceId(), quantity, 0, null, commerceContext, serviceContext);
            }
            catch (Exception exception) {
                _log.error((Object)exception, (Throwable)exception);
            }
        }
    }

    private void _generateCommerceOrders(long groupId, int ordersCount) throws Exception {
        Group group = this._groupLocalService.getGroup(groupId);
        this._setPermissionChecker(group);
        List commerceAccounts = this._commerceAccountLocalService.searchCommerceAccounts(group.getCompanyId(), 0L, null, this._getAccountType(groupId), Boolean.valueOf(true), -1, -1, null);
        if (commerceAccounts.isEmpty()) {
            _log.error((Object)"There are no accounts");
            return;
        }
        long commerceShippingMethodId = this._getCommerceShippingMethodId(groupId);
        SearchContext searchContext = this._getSearchContext(groupId);
        CPDataSourceResult cpDataSourceResult = this._cpDefinitionHelper.search(groupId, searchContext, new CPQuery(), 0, 1);
        if (cpDataSourceResult.getLength() <= 0) {
            _log.error((Object)"There are no products");
            return;
        }
        int retryNumber = 0;
        for (int i = 0; i < ordersCount; ++i) {
            int min = this._randomInt(0, cpDataSourceResult.getLength() - 1);
            int max = min + this._randomInt(1, 20);
            if (max >= cpDataSourceResult.getLength()) {
                max = cpDataSourceResult.getLength() - 1;
            }
            if (min == max) {
                min = 0;
                max = this._randomInt(1, 20);
            }
            cpDataSourceResult = this._cpDefinitionHelper.search(groupId, searchContext, new CPQuery(), min, max);
            try {
                this._generateCommerceOrder(groupId, (CommerceAccount)commerceAccounts.get(this._randomInt(0, commerceAccounts.size() - 1)), cpDataSourceResult.getCPCatalogEntries(), commerceShippingMethodId, this._getCommerceShippingEngine(commerceShippingMethodId));
                retryNumber = 0;
                continue;
            }
            catch (PortalException portalException) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)portalException, (Throwable)portalException);
                }
                if (retryNumber < 5) {
                    --i;
                    ++retryNumber;
                    continue;
                }
                _log.error((Object)portalException.getMessage(), (Throwable)portalException);
            }
        }
    }

    private int _getAccountType(long groupId) throws Exception {
        CommerceAccountGroupServiceConfiguration commerceAccountGroupServiceConfiguration = (CommerceAccountGroupServiceConfiguration)this._configurationProvider.getConfiguration(CommerceAccountGroupServiceConfiguration.class, (SettingsLocator)new GroupServiceSettingsLocator(this._commerceChannelLocalService.getCommerceChannelGroupIdBySiteGroupId(groupId), "com.liferay.commerce.account"));
        if (commerceAccountGroupServiceConfiguration.commerceSiteType() == 0) {
            return 1;
        }
        return 2;
    }

    private CommerceShippingEngine _getCommerceShippingEngine(long commerceShippingMethodId) {
        CommerceShippingMethod commerceShippingMethod = this._commerceShippingMethodLocalService.fetchCommerceShippingMethod(commerceShippingMethodId);
        if (commerceShippingMethod == null) {
            return null;
        }
        return this._commerceShippingEngineRegistry.getCommerceShippingEngine(commerceShippingMethod.getEngineKey());
    }

    private long _getCommerceShippingMethodId(long groupId) throws Exception {
        List commerceShippingMethods = this._commerceShippingMethodLocalService.getCommerceShippingMethods(this._commerceChannelLocalService.getCommerceChannelGroupIdBySiteGroupId(groupId));
        if (commerceShippingMethods.isEmpty()) {
            return 0L;
        }
        CommerceShippingMethod commerceShippingMethod = (CommerceShippingMethod)commerceShippingMethods.get(0);
        return commerceShippingMethod.getCommerceShippingMethodId();
    }

    private int _getMaxOrderQuantity(CPInstance cpInstance, CPDefinitionInventoryEngine cpDefinitionInventoryEngine) throws PortalException {
        int maxOrderQuantity;
        int stockQuantity = this._commerceInventoryEngine.getStockQuantity(cpInstance.getCompanyId(), cpInstance.getSku());
        if (stockQuantity < (maxOrderQuantity = cpDefinitionInventoryEngine.getMaxOrderQuantity(cpInstance))) {
            return stockQuantity;
        }
        return maxOrderQuantity;
    }

    private SearchContext _getSearchContext(long groupId) throws Exception {
        SearchContext searchContext = new SearchContext();
        searchContext.setAttributes((Map)HashMapBuilder.put((Object)"status", (Object)0).build());
        Group group = this._groupLocalService.getGroup(groupId);
        searchContext.setCompanyId(group.getCompanyId());
        searchContext.setAttribute("commerceChannelGroupId", (Serializable)Long.valueOf(groupId));
        return searchContext;
    }

    private ServiceContext _getServiceContext(CommerceOrder commerceOrder) throws PortalException {
        ServiceContext serviceContext = new ServiceContext();
        User user = this._userLocalService.getUser(commerceOrder.getUserId());
        serviceContext.setCompanyId(user.getCompanyId());
        serviceContext.setLanguageId(user.getLanguageId());
        serviceContext.setScopeGroupId(user.getGroupId());
        serviceContext.setUserId(user.getUserId());
        return serviceContext;
    }

    private int _randomInt(int min, int max) {
        if (max < min) {
            throw new IllegalArgumentException("Max value must be greater than or equal to the min value");
        }
        int value = this._random.nextInt();
        int range = max + 1 - min;
        if (range == 0) {
            return value;
        }
        return Math.floorMod(value, range) + min;
    }

    private void _setPermissionChecker(Group group) throws Exception {
        Company company = this._companyLocalService.getCompanyById(group.getCompanyId());
        Role role = this._roleLocalService.fetchRole(company.getCompanyId(), "Administrator");
        List roleUsers = this._userLocalService.getRoleUsers(role.getRoleId());
        User user = (User)roleUsers.get(0);
        PermissionChecker permissionChecker = this._permissionCheckerFactory.create(user);
        PrincipalThreadLocal.setName((long)user.getUserId());
        PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
    }

    private class GenerateOrdersCallable
    implements Callable<Object> {
        private final long _groupId;
        private final int _ordersCount;

        @Override
        public Object call() throws Exception {
            CommerceOrderGenerator.this._generateCommerceOrders(this._groupId, this._ordersCount);
            return null;
        }

        private GenerateOrdersCallable(long groupId, int ordersCount) {
            this._groupId = groupId;
            this._ordersCount = ordersCount;
        }
    }
}

