/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.initializer.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.MappingJsonFactory;
import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.commerce.account.model.CommerceAccountGroup;
import com.liferay.commerce.account.service.CommerceAccountGroupLocalService;
import com.liferay.commerce.account.service.CommerceAccountGroupRelLocalService;
import com.liferay.commerce.initializer.util.AssetCategoriesImporter;
import com.liferay.commerce.initializer.util.AssetTagsImporter;
import com.liferay.commerce.initializer.util.CPAttachmentFileEntryCreator;
import com.liferay.commerce.inventory.service.CommerceInventoryWarehouseItemLocalService;
import com.liferay.commerce.model.CPDAvailabilityEstimate;
import com.liferay.commerce.model.CPDefinitionInventory;
import com.liferay.commerce.model.CommerceAvailabilityEstimate;
import com.liferay.commerce.product.exception.NoSuchSkuContributorCPDefinitionOptionRelException;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPDefinitionOptionRel;
import com.liferay.commerce.product.model.CPDefinitionOptionValueRel;
import com.liferay.commerce.product.model.CPDefinitionSpecificationOptionValue;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.model.CPOption;
import com.liferay.commerce.product.model.CPOptionCategory;
import com.liferay.commerce.product.model.CPOptionValue;
import com.liferay.commerce.product.model.CPSpecificationOption;
import com.liferay.commerce.product.model.CPTaxCategory;
import com.liferay.commerce.product.service.CPDefinitionLocalService;
import com.liferay.commerce.product.service.CPDefinitionOptionRelLocalService;
import com.liferay.commerce.product.service.CPDefinitionOptionValueRelLocalService;
import com.liferay.commerce.product.service.CPDefinitionSpecificationOptionValueLocalService;
import com.liferay.commerce.product.service.CPInstanceLocalService;
import com.liferay.commerce.product.service.CPOptionCategoryLocalService;
import com.liferay.commerce.product.service.CPOptionLocalService;
import com.liferay.commerce.product.service.CPOptionValueLocalService;
import com.liferay.commerce.product.service.CPSpecificationOptionLocalService;
import com.liferay.commerce.product.service.CPTaxCategoryLocalService;
import com.liferay.commerce.product.service.CommerceChannelRelLocalService;
import com.liferay.commerce.service.CPDAvailabilityEstimateLocalService;
import com.liferay.commerce.service.CPDefinitionInventoryLocalService;
import com.liferay.commerce.service.CommerceAvailabilityEstimateLocalService;
import com.liferay.commerce.util.comparator.CommerceAvailabilityEstimatePriorityComparator;
import com.liferay.portal.json.JSONArrayImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.FriendlyURLNormalizerUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, service={CPDefinitionsImporter.class})
public class CPDefinitionsImporter {
    private static final Log _log = LogFactoryUtil.getLog(CPDefinitionsImporter.class);
    @Reference
    private AssetCategoriesImporter _assetCategoriesImporter;
    @Reference
    private AssetTagsImporter _assetTagsImporter;
    @Reference
    private CommerceAccountGroupLocalService _commerceAccountGroupLocalService;
    @Reference
    private CommerceAccountGroupRelLocalService _commerceAccountGroupRelLocalService;
    @Reference
    private CommerceAvailabilityEstimateLocalService _commerceAvailabilityEstimateLocalService;
    @Reference
    private CommerceChannelRelLocalService _commerceChannelRelLocalService;
    @Reference
    private CommerceInventoryWarehouseItemLocalService _commerceInventoryWarehouseItemLocalService;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private CPAttachmentFileEntryCreator _cpAttachmentFileEntryCreator;
    @Reference
    private CPDAvailabilityEstimateLocalService _cpdAvailabilityEstimateLocalService;
    @Reference
    private CPDefinitionInventoryLocalService _cpDefinitionInventoryLocalService;
    @Reference
    private CPDefinitionLocalService _cpDefinitionLocalService;
    @Reference
    private CPDefinitionOptionRelLocalService _cpDefinitionOptionRelLocalService;
    @Reference
    private CPDefinitionOptionValueRelLocalService _cpDefinitionOptionValueRelLocalService;
    @Reference
    private CPDefinitionSpecificationOptionValueLocalService _cpDefinitionSpecificationOptionValueLocalService;
    @Reference
    private CPInstanceLocalService _cpInstanceLocalService;
    @Reference
    private CPOptionCategoryLocalService _cpOptionCategoryLocalService;
    @Reference
    private CPOptionLocalService _cpOptionLocalService;
    @Reference
    private CPOptionValueLocalService _cpOptionValueLocalService;
    @Reference
    private CPSpecificationOptionLocalService _cpSpecificationOptionLocalService;
    @Reference
    private CPTaxCategoryLocalService _cpTaxCategoryLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public void importCPDefinitions(File cpDefinitionsFile, String assetVocabularyName, long catalogGroupId, long commerceChannelId, long[] commerceInventoryWarehouseIds, ClassLoader classLoader, String imageDependenciesPath, long scopeGroupId, long userId) throws Exception {
        ServiceContext serviceContext = this.getServiceContext(scopeGroupId, userId);
        MappingJsonFactory mappingJsonFactory = new MappingJsonFactory();
        JsonParser jsonFactoryParser = mappingJsonFactory.createParser(cpDefinitionsFile);
        JsonToken jsonToken = jsonFactoryParser.nextToken();
        if (jsonToken != JsonToken.START_ARRAY) {
            throw new Exception("JSON Array Expected");
        }
        int importCount = 0;
        while (jsonFactoryParser.nextToken() != JsonToken.END_ARRAY) {
            TreeNode treeNode = jsonFactoryParser.readValueAsTree();
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)treeNode.toString());
            if (_log.isDebugEnabled()) {
                _log.debug((Object)jsonObject);
            }
            this._importCPDefinition(jsonObject, assetVocabularyName, catalogGroupId, commerceChannelId, commerceInventoryWarehouseIds, classLoader, imageDependenciesPath, serviceContext);
            ++importCount;
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Products import count: " + importCount));
        }
        jsonFactoryParser.close();
    }

    public List<CPDefinition> importCPDefinitions(JSONArray jsonArray, String assetVocabularyName, long catalogGroupId, long commerceChannelId, long[] commerceInventoryWarehouseIds, ClassLoader classLoader, String imageDependenciesPath, long scopeGroupId, long userId) throws Exception {
        ServiceContext serviceContext = this.getServiceContext(scopeGroupId, userId);
        ArrayList<CPDefinition> cpDefinitions = new ArrayList<CPDefinition>(jsonArray.length());
        for (int i = 0; i < jsonArray.length(); ++i) {
            CPDefinition cpDefinition = this._importCPDefinition(jsonArray.getJSONObject(i), assetVocabularyName, catalogGroupId, commerceChannelId, commerceInventoryWarehouseIds, classLoader, imageDependenciesPath, serviceContext);
            cpDefinitions.add(cpDefinition);
        }
        return cpDefinitions;
    }

    protected ServiceContext getServiceContext(long scopeGroupId, long userId) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setScopeGroupId(scopeGroupId);
        serviceContext.setUserId(userId);
        serviceContext.setCompanyId(user.getCompanyId());
        return serviceContext;
    }

    private CPDefinition _addCPDefinition(long catalogGroupId, String name, String shortDescription, String description, String externalReferenceCode, boolean shippable, String sku, String taxCategory, long width, long height, long depth, long weight, boolean subscriptionEnabled, int subscriptionLength, String subscriptionType, UnicodeProperties subscriptionTypeSettingsUnicodeProperties, long maxSubscriptionCycles, long[] assetCategoryIds, String[] assetTagNames, ServiceContext serviceContext) throws Exception {
        serviceContext.setAssetCategoryIds(assetCategoryIds);
        serviceContext.setAssetTagNames(assetTagNames);
        User user = this._userLocalService.getUser(serviceContext.getUserId());
        Calendar displayCalendar = CalendarFactoryUtil.getCalendar((TimeZone)user.getTimeZone());
        displayCalendar.add(1, -1);
        int displayDateMonth = displayCalendar.get(2);
        int displayDateDay = displayCalendar.get(5);
        int displayDateYear = displayCalendar.get(1);
        int displayDateHour = displayCalendar.get(10);
        int displayDateMinute = displayCalendar.get(12);
        int displayDateAmPm = displayCalendar.get(9);
        if (displayDateAmPm == 1) {
            displayDateHour += 12;
        }
        Calendar expirationCalendar = CalendarFactoryUtil.getCalendar((TimeZone)user.getTimeZone());
        expirationCalendar.add(2, 1);
        int expirationDateMonth = expirationCalendar.get(2);
        int expirationDateDay = expirationCalendar.get(5);
        int expirationDateYear = expirationCalendar.get(1);
        int expirationDateHour = expirationCalendar.get(10);
        int expirationDateMinute = expirationCalendar.get(12);
        int expirationDateAmPm = expirationCalendar.get(9);
        if (expirationDateAmPm == 1) {
            expirationDateHour += 12;
        }
        Locale locale = LocaleUtil.getSiteDefault();
        Map<Locale, String> nameMap = Collections.singletonMap(locale, name);
        Map<Locale, String> shortDescriptionMap = Collections.singletonMap(locale, shortDescription);
        Map<Locale, String> descriptionMap = Collections.singletonMap(locale, description);
        return this._cpDefinitionLocalService.addCPDefinition(catalogGroupId, user.getUserId(), nameMap, shortDescriptionMap, descriptionMap, nameMap, null, null, null, "simple", true, shippable, false, false, 0.0, (double)width, (double)height, (double)depth, (double)weight, this._getCPTaxCategoryId(taxCategory, serviceContext), false, false, null, true, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, true, sku, subscriptionEnabled, subscriptionLength, subscriptionType, subscriptionTypeSettingsUnicodeProperties, maxSubscriptionCycles, externalReferenceCode, serviceContext);
    }

    private void _addWarehouseQuantities(JSONObject skuJSONObject, long[] commerceInventoryWarehouseIds, ServiceContext serviceContext, CPInstance cpInstance) throws Exception {
        for (int i = 0; i < commerceInventoryWarehouseIds.length; ++i) {
            long commerceInventoryWarehouseId = commerceInventoryWarehouseIds[i];
            int quantity = skuJSONObject.getInt("Warehouse" + String.valueOf(i + 1));
            if (quantity <= 0) continue;
            this._commerceInventoryWarehouseItemLocalService.upsertCommerceInventoryWarehouseItem(serviceContext.getUserId(), commerceInventoryWarehouseId, cpInstance.getSku(), quantity);
        }
    }

    private long _getCPTaxCategoryId(String taxCategory, ServiceContext serviceContext) throws Exception {
        CPTaxCategory cpTaxCategory2;
        if (Validator.isNull((String)taxCategory)) {
            return 0L;
        }
        List cpTaxCategories = this._cpTaxCategoryLocalService.getCPTaxCategories(serviceContext.getCompanyId());
        for (CPTaxCategory cpTaxCategory2 : cpTaxCategories) {
            if (!taxCategory.equals(cpTaxCategory2.getName(LocaleUtil.getSiteDefault()))) continue;
            return cpTaxCategory2.getCPTaxCategoryId();
        }
        Map<Locale, String> nameMap = Collections.singletonMap(LocaleUtil.getSiteDefault(), taxCategory);
        cpTaxCategory2 = this._cpTaxCategoryLocalService.addCPTaxCategory("", nameMap, Collections.emptyMap(), serviceContext);
        return cpTaxCategory2.getCPTaxCategoryId();
    }

    private UnicodeProperties _getSubscriptionTypeSettingsUnicodeProperties(JSONObject subscriptionInfoJSONObject) {
        if (subscriptionInfoJSONObject == null) {
            return null;
        }
        String subscriptionTypeSettingsUnicodeProperties = GetterUtil.getString((Object)subscriptionInfoJSONObject.get("SubscriptionTypeSettingsUnicodeProperties"));
        if (Validator.isNull((String)subscriptionTypeSettingsUnicodeProperties)) {
            return null;
        }
        UnicodeProperties unicodeProperties = new UnicodeProperties(true);
        unicodeProperties.fastLoad(subscriptionTypeSettingsUnicodeProperties);
        return unicodeProperties;
    }

    private CPDefinition _importCPDefinition(JSONObject jsonObject, String assetVocabularyName, long catalogGroupId, long commerceChannelId, long[] commerceInventoryWarehouseIds, ClassLoader classLoader, String imageDependenciesPath, ServiceContext serviceContext) throws Exception {
        JSONArray attachmentsJSONArray;
        String attachment;
        JSONArray imagesJSONArray;
        String image;
        JSONArray optionsJSONArray;
        JSONArray tagsJSONArray;
        Company company = this._companyLocalService.getCompany(serviceContext.getCompanyId());
        List<Object> assetCategories = Collections.emptyList();
        JSONArray categoriesJSONArray = jsonObject.getJSONArray("Categories");
        if (categoriesJSONArray != null) {
            assetCategories = this._assetCategoriesImporter.importAssetCategories(categoriesJSONArray, assetVocabularyName, classLoader, imageDependenciesPath, company.getGroupId(), serviceContext.getUserId());
        }
        if ((tagsJSONArray = jsonObject.getJSONArray("Tags")) != null) {
            this._assetTagsImporter.importAssetTags(tagsJSONArray, company.getGroupId(), serviceContext.getUserId());
        } else {
            tagsJSONArray = new JSONArrayImpl();
        }
        String externalReferenceCode = jsonObject.getString("ExternalReferenceCode");
        CPDefinition cpDefinition = this._cpDefinitionLocalService.fetchCPDefinitionByCProductExternalReferenceCode(company.getCompanyId(), externalReferenceCode);
        if (cpDefinition != null) {
            this._commerceChannelRelLocalService.addCommerceChannelRel(CPDefinition.class.getName(), cpDefinition.getCPDefinitionId(), commerceChannelId, serviceContext);
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CPDefinition.class);
            indexer.reindex((Object)cpDefinition);
            return cpDefinition;
        }
        String name = jsonObject.getString("Name");
        String shortDescription = jsonObject.getString("ShortDescription");
        String description = jsonObject.getString("Description");
        boolean shippable = jsonObject.getBoolean("Shippable", true);
        String sku = jsonObject.getString("Sku");
        String taxCategory = jsonObject.getString("TaxCategory");
        long width = jsonObject.getLong("Width");
        long height = jsonObject.getLong("Height");
        long length = jsonObject.getLong("Length");
        long weight = jsonObject.getLong("Weight");
        boolean subscriptionEnabled = false;
        int subscriptionLength = 0;
        String subscriptionType = null;
        long maxSubscriptionCycles = 0L;
        JSONObject subscriptionInfoJSONObject = jsonObject.getJSONObject("SubscriptionInfo");
        if (subscriptionInfoJSONObject != null) {
            subscriptionEnabled = GetterUtil.getBoolean((Object)subscriptionInfoJSONObject.get("SubscriptionEnabled"));
            subscriptionLength = GetterUtil.getInteger((Object)subscriptionInfoJSONObject.get("SubscriptionLength"), (int)1);
            subscriptionType = GetterUtil.getString((Object)subscriptionInfoJSONObject.get("SubscriptionType"));
            maxSubscriptionCycles = GetterUtil.getLong((Object)subscriptionInfoJSONObject.get("MaxSubscriptionCycles"));
        }
        long[] assetCategoryIds = ListUtil.toLongArray(assetCategories, (Accessor)AssetCategory.CATEGORY_ID_ACCESSOR);
        String[] assetTagNames = ArrayUtil.toStringArray((JSONArray)tagsJSONArray);
        int originalWorkflowAction = serviceContext.getWorkflowAction();
        serviceContext.setWorkflowAction(2);
        cpDefinition = this._addCPDefinition(catalogGroupId, name, shortDescription, description, externalReferenceCode, shippable, sku, taxCategory, width, height, length, weight, subscriptionEnabled, subscriptionLength, subscriptionType, this._getSubscriptionTypeSettingsUnicodeProperties(subscriptionInfoJSONObject), maxSubscriptionCycles, assetCategoryIds, assetTagNames, serviceContext);
        serviceContext.setWorkflowAction(originalWorkflowAction);
        JSONArray specificationOptionsJSONArray = jsonObject.getJSONArray("SpecificationOptions");
        if (specificationOptionsJSONArray != null) {
            for (int i = 0; i < specificationOptionsJSONArray.length(); ++i) {
                JSONObject specificationOptionJSONObject = specificationOptionsJSONArray.getJSONObject(i);
                this._importCPDefinitionSpecificationOptionValue(company.getCompanyId(), cpDefinition.getCPDefinitionId(), specificationOptionJSONObject, i, serviceContext);
            }
        }
        if ((optionsJSONArray = jsonObject.getJSONArray("Options")) != null) {
            for (int i = 0; i < optionsJSONArray.length(); ++i) {
                JSONObject optionJSONObject = optionsJSONArray.getJSONObject(i);
                this._importCPDefinitionOptionRel(catalogGroupId, company.getCompanyId(), cpDefinition.getCPDefinitionId(), optionJSONObject, serviceContext);
            }
        }
        JSONArray skusJSONArray = jsonObject.getJSONArray("Skus");
        Calendar calendar = Calendar.getInstance();
        if (skusJSONArray != null) {
            for (int i = 0; i < skusJSONArray.length(); ++i) {
                JSONObject skuJSONObject = skusJSONArray.getJSONObject(i);
                this._importCPInstance(cpDefinition.getCPDefinitionId(), skuJSONObject, commerceInventoryWarehouseIds, calendar, serviceContext);
            }
        } else {
            block26: {
                try {
                    this._cpInstanceLocalService.buildCPInstances(cpDefinition.getCPDefinitionId(), serviceContext);
                }
                catch (NoSuchSkuContributorCPDefinitionOptionRelException noSuchSkuContributorCPDefinitionOptionRelException) {
                    if (!_log.isInfoEnabled()) break block26;
                    _log.info((Object)("No options defined as sku contributor for CPDefinition " + cpDefinition.getCPDefinitionId()));
                }
            }
            List cpInstances = cpDefinition.getCPInstances();
            for (CPInstance cpInstance : cpInstances) {
                double priceDouble = jsonObject.getDouble("Price", 0.0);
                BigDecimal price = BigDecimal.valueOf(priceDouble);
                BigDecimal cost = BigDecimal.valueOf(jsonObject.getDouble("Cost", 0.0));
                BigDecimal promoPrice = BigDecimal.valueOf(jsonObject.getDouble("PromoPrice", 0.0));
                cpInstance.setPrice(price);
                cpInstance.setPromoPrice(promoPrice);
                cpInstance.setCost(cost);
                String manufacturerPartNumber = jsonObject.getString("ManufacturerPartNumber");
                cpInstance.setManufacturerPartNumber(manufacturerPartNumber);
                String cpInstanceExternalReferenceCode = FriendlyURLNormalizerUtil.normalize((String)sku);
                cpInstance.setExternalReferenceCode(cpInstanceExternalReferenceCode);
                this._cpInstanceLocalService.updateCPInstance(cpInstance);
                this._addWarehouseQuantities(jsonObject, commerceInventoryWarehouseIds, serviceContext, cpInstance);
            }
        }
        String cpDefinitionInventoryEngine = jsonObject.getString("CPDefinitionInventoryEngine");
        String lowStockActivity = jsonObject.getString("LowStockActivity");
        boolean displayAvailability = jsonObject.getBoolean("DisplayAvailability");
        boolean displayStockQuantity = jsonObject.getBoolean("DisplayStockQuantity");
        int minStockQuantity = jsonObject.getInt("MinStockQuantity");
        boolean backOrders = jsonObject.getBoolean("BackOrders");
        int minOrderQuantity = jsonObject.getInt("MinOrderQuantity", 1);
        int maxOrderQuantity = jsonObject.getInt("MaxOrderQuantity", 10000);
        String allowedOrderQuantities = jsonObject.getString("AllowedOrderQuantities");
        int multipleOrderQuantity = jsonObject.getInt("MultipleOrderQuantity", 1);
        CPDefinitionInventory cpDefinitionInventory = this._cpDefinitionInventoryLocalService.fetchCPDefinitionInventoryByCPDefinitionId(cpDefinition.getCPDefinitionId());
        if (cpDefinitionInventory == null) {
            this._cpDefinitionInventoryLocalService.addCPDefinitionInventory(serviceContext.getUserId(), cpDefinition.getCPDefinitionId(), cpDefinitionInventoryEngine, lowStockActivity, displayAvailability, displayStockQuantity, minStockQuantity, backOrders, minOrderQuantity, maxOrderQuantity, allowedOrderQuantities, multipleOrderQuantity);
        } else {
            this._cpDefinitionInventoryLocalService.updateCPDefinitionInventory(cpDefinitionInventory.getCPDefinitionInventoryId(), cpDefinitionInventoryEngine, lowStockActivity, displayAvailability, displayStockQuantity, minStockQuantity, backOrders, minOrderQuantity, maxOrderQuantity, allowedOrderQuantities, multipleOrderQuantity);
        }
        String availabilityEstimate = jsonObject.getString("AvailabilityEstimate");
        if (Validator.isNotNull((String)availabilityEstimate)) {
            this._updateCPDAvailabilityEstimate(cpDefinition.getCProductId(), availabilityEstimate, serviceContext);
        }
        if (Validator.isNotNull((String)(image = jsonObject.getString("Image")))) {
            this._cpAttachmentFileEntryCreator.addCPAttachmentFileEntry((ClassedModel)cpDefinition, classLoader, imageDependenciesPath, image, 0.0, 0, catalogGroupId, serviceContext.getUserId());
        }
        if ((imagesJSONArray = jsonObject.getJSONArray("Images")) != null) {
            for (int i = 0; i < imagesJSONArray.length(); ++i) {
                this._cpAttachmentFileEntryCreator.addCPAttachmentFileEntry((ClassedModel)cpDefinition, classLoader, imageDependenciesPath, imagesJSONArray.getString(i), i, 0, catalogGroupId, serviceContext.getUserId());
            }
        }
        if (Validator.isNotNull((String)(attachment = jsonObject.getString("Attachment")))) {
            this._cpAttachmentFileEntryCreator.addCPAttachmentFileEntry((ClassedModel)cpDefinition, classLoader, imageDependenciesPath, attachment, 0.0, 1, catalogGroupId, serviceContext.getUserId());
        }
        if ((attachmentsJSONArray = jsonObject.getJSONArray("Attachments")) != null) {
            for (int i = 0; i < attachmentsJSONArray.length(); ++i) {
                this._cpAttachmentFileEntryCreator.addCPAttachmentFileEntry((ClassedModel)cpDefinition, classLoader, imageDependenciesPath, attachmentsJSONArray.getString(i), i, 1, catalogGroupId, serviceContext.getUserId());
            }
        }
        this._cpDefinitionLocalService.updateCPDefinitionChannelFilter(cpDefinition.getCPDefinitionId(), true);
        this._commerceChannelRelLocalService.addCommerceChannelRel(CPDefinition.class.getName(), cpDefinition.getCPDefinitionId(), commerceChannelId, serviceContext);
        JSONArray filterAccountGroupsJSONArray = jsonObject.getJSONArray("FilterAccountGroups");
        if (filterAccountGroupsJSONArray != null) {
            this._cpDefinitionLocalService.updateCPDefinitionAccountGroupFilter(cpDefinition.getCPDefinitionId(), true);
            for (int i = 0; i < filterAccountGroupsJSONArray.length(); ++i) {
                String accountGroupExternalReferenceCode = FriendlyURLNormalizerUtil.normalize((String)filterAccountGroupsJSONArray.getString(i));
                CommerceAccountGroup commerceAccountGroup = this._commerceAccountGroupLocalService.fetchCommerceAccountGroupByReferenceCode(company.getCompanyId(), accountGroupExternalReferenceCode);
                if (commerceAccountGroup == null) continue;
                this._commerceAccountGroupRelLocalService.addCommerceAccountGroupRel(CPDefinition.class.getName(), cpDefinition.getCPDefinitionId(), commerceAccountGroup.getCommerceAccountGroupId(), serviceContext);
            }
        }
        return this._cpDefinitionLocalService.updateStatus(cpDefinition.getUserId(), cpDefinition.getCPDefinitionId(), 0, serviceContext, Collections.emptyMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CPDefinitionOptionRel _importCPDefinitionOptionRel(long catalogGroupId, long companyId, long cpDefinitionId, JSONObject jsonObject, ServiceContext serviceContext) throws Exception {
        CPOption cpOption = this._cpOptionLocalService.getCPOption(companyId, jsonObject.getString("Key"));
        boolean importOptionValue = true;
        JSONArray valuesJSONArray = jsonObject.getJSONArray("Values");
        if (valuesJSONArray != null && valuesJSONArray.length() > 0) {
            importOptionValue = false;
        }
        CPDefinitionOptionRel cpDefinitionOptionRel = null;
        long scopeGroupId = serviceContext.getScopeGroupId();
        serviceContext.setScopeGroupId(catalogGroupId);
        try {
            cpDefinitionOptionRel = this._cpDefinitionOptionRelLocalService.addCPDefinitionOptionRel(cpDefinitionId, cpOption.getCPOptionId(), importOptionValue, serviceContext);
        }
        finally {
            serviceContext.setScopeGroupId(scopeGroupId);
        }
        if (!importOptionValue) {
            for (int i = 0; i < valuesJSONArray.length(); ++i) {
                JSONObject valueJSONObject = valuesJSONArray.getJSONObject(i);
                String key = valueJSONObject != null ? valueJSONObject.getString("Key") : valuesJSONArray.getString(i);
                this._importCPDefinitionOptionValueRel(key, cpDefinitionOptionRel, serviceContext);
            }
        }
        return cpDefinitionOptionRel;
    }

    private CPDefinitionOptionValueRel _importCPDefinitionOptionValueRel(String key, CPDefinitionOptionRel cpDefinitionOptionRel, ServiceContext serviceContext) throws Exception {
        CPOptionValue cpOptionValue = this._cpOptionValueLocalService.getCPOptionValue(cpDefinitionOptionRel.getCPOptionId(), FriendlyURLNormalizerUtil.normalize((String)key));
        return this._cpDefinitionOptionValueRelLocalService.addCPDefinitionOptionValueRel(cpDefinitionOptionRel.getCPDefinitionOptionRelId(), cpOptionValue, serviceContext);
    }

    private CPDefinitionSpecificationOptionValue _importCPDefinitionSpecificationOptionValue(long companyId, long cpDefinitionId, JSONObject jsonObject, double defaultPriority, ServiceContext serviceContext) throws Exception {
        CPSpecificationOption cpSpecificationOption = this._cpSpecificationOptionLocalService.getCPSpecificationOption(companyId, jsonObject.getString("Key"));
        long cpOptionCategoryId = 0L;
        String categoryKey = jsonObject.getString("CategoryKey");
        if (Validator.isNotNull((String)categoryKey)) {
            CPOptionCategory cpOptionCategory = this._cpOptionCategoryLocalService.getCPOptionCategory(cpSpecificationOption.getCompanyId(), categoryKey);
            cpOptionCategoryId = cpOptionCategory.getCPOptionCategoryId();
        } else {
            cpOptionCategoryId = cpSpecificationOption.getCPOptionCategoryId();
        }
        Map<Locale, String> valueMap = Collections.singletonMap(LocaleUtil.getSiteDefault(), jsonObject.getString("Value"));
        double priority = jsonObject.getDouble("Priority", defaultPriority);
        return this._cpDefinitionSpecificationOptionValueLocalService.addCPDefinitionSpecificationOptionValue(cpDefinitionId, cpSpecificationOption.getCPSpecificationOptionId(), cpOptionCategoryId, valueMap, priority, serviceContext);
    }

    private CPInstance _importCPInstance(long cpDefinitionId, JSONObject skuJSONObject, long[] commerceInventoryWarehouseIds, Calendar calendar, ServiceContext serviceContext) throws Exception {
        String sku = skuJSONObject.getString("Sku");
        String manufacturerPartNumber = skuJSONObject.getString("ManufacturerPartNumber");
        double price = skuJSONObject.getDouble("Price");
        double promoPrice = skuJSONObject.getDouble("PromoPrice");
        JSONArray optionsJSONArray = skuJSONObject.getJSONArray("ContributorOptions");
        String optionsJSON = null;
        if (optionsJSONArray != null) {
            JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
            for (int i = 0; i < optionsJSONArray.length(); ++i) {
                CPDefinitionOptionRel cpDefinitionOptionRel;
                JSONObject optionsJSONObject = optionsJSONArray.getJSONObject(i);
                String key = optionsJSONObject.getString("key");
                CPOption cpOption = this._cpOptionLocalService.fetchCPOption(serviceContext.getCompanyId(), key);
                if (cpOption == null || (cpDefinitionOptionRel = this._cpDefinitionOptionRelLocalService.fetchCPDefinitionOptionRel(cpDefinitionId, cpOption.getCPOptionId())) == null) continue;
                JSONObject jsonObject = JSONUtil.put((String)"key", (Object)cpDefinitionOptionRel.getKey());
                List cpDefinitionOptionValueRels = this._cpDefinitionOptionValueRelLocalService.getCPDefinitionOptionValueRels(cpDefinitionOptionRel.getCPDefinitionOptionRelId());
                for (CPDefinitionOptionValueRel cpDefinitionOptionValueRel : cpDefinitionOptionValueRels) {
                    String name = cpDefinitionOptionValueRel.getName(LocaleUtil.getSiteDefault());
                    if (!name.equals(optionsJSONObject.getString("value"))) continue;
                    JSONArray valueJSONArray = JSONUtil.put((Object)cpDefinitionOptionValueRel.getKey());
                    jsonObject.put("value", valueJSONArray);
                }
                jsonArray.put(jsonObject);
            }
            optionsJSON = jsonArray.toString();
        }
        CPDefinition cpDefinition = this._cpDefinitionLocalService.getCPDefinition(cpDefinitionId);
        String externalReferenceCode = FriendlyURLNormalizerUtil.normalize((String)sku);
        boolean overrideSubscriptionInfo = false;
        boolean subscriptionEnabled = false;
        int subscriptionLength = 0;
        String subscriptionType = null;
        long maxSubscriptionCycles = 0L;
        JSONObject subscriptionInfoJSONObject = skuJSONObject.getJSONObject("SubscriptionInfo");
        if (subscriptionInfoJSONObject != null) {
            overrideSubscriptionInfo = GetterUtil.getBoolean((Object)subscriptionInfoJSONObject.get("OverrideSubscriptionInfo"));
            subscriptionEnabled = GetterUtil.getBoolean((Object)subscriptionInfoJSONObject.get("SubscriptionEnabled"));
            subscriptionLength = GetterUtil.getInteger((Object)subscriptionInfoJSONObject.get("SubscriptionLength"), (int)1);
            subscriptionType = GetterUtil.getString((Object)subscriptionInfoJSONObject.get("SubscriptionType"));
            maxSubscriptionCycles = GetterUtil.getLong((Object)subscriptionInfoJSONObject.get("MaxSubscriptionCycles"));
        }
        CPInstance cpInstance = this._cpInstanceLocalService.addCPInstance(cpDefinitionId, cpDefinition.getGroupId(), sku, null, manufacturerPartNumber, true, this._cpDefinitionOptionRelLocalService.getCPDefinitionOptionRelCPDefinitionOptionValueRelIds(cpDefinitionId, optionsJSON), cpDefinition.getWidth(), cpDefinition.getHeight(), cpDefinition.getDepth(), cpDefinition.getWeight(), BigDecimal.valueOf(price), BigDecimal.valueOf(promoPrice), BigDecimal.valueOf(0L), true, externalReferenceCode, calendar.get(2), calendar.get(5), calendar.get(1), calendar.get(11), calendar.get(12), 0, 0, 0, 0, 0, true, overrideSubscriptionInfo, subscriptionEnabled, subscriptionLength, subscriptionType, this._getSubscriptionTypeSettingsUnicodeProperties(subscriptionInfoJSONObject), maxSubscriptionCycles, serviceContext);
        this._addWarehouseQuantities(skuJSONObject, commerceInventoryWarehouseIds, serviceContext, cpInstance);
        return cpInstance;
    }

    private CPDAvailabilityEstimate _updateCPDAvailabilityEstimate(long cProductId, String availabilityEstimate, ServiceContext serviceContext) throws Exception {
        CommerceAvailabilityEstimate commerceAvailabilityEstimate2;
        List commerceAvailabilityEstimates = this._commerceAvailabilityEstimateLocalService.getCommerceAvailabilityEstimates(serviceContext.getCompanyId(), -1, -1, (OrderByComparator)new CommerceAvailabilityEstimatePriorityComparator(true));
        for (CommerceAvailabilityEstimate commerceAvailabilityEstimate2 : commerceAvailabilityEstimates) {
            if (!availabilityEstimate.equals(commerceAvailabilityEstimate2.getTitle(LocaleUtil.getSiteDefault()))) continue;
            return this._cpdAvailabilityEstimateLocalService.updateCPDAvailabilityEstimateByCProductId(0L, cProductId, commerceAvailabilityEstimate2.getCommerceAvailabilityEstimateId(), serviceContext);
        }
        Map<Locale, String> titleMap = Collections.singletonMap(LocaleUtil.getSiteDefault(), availabilityEstimate);
        commerceAvailabilityEstimate2 = this._commerceAvailabilityEstimateLocalService.addCommerceAvailabilityEstimate(titleMap, 0.0, serviceContext);
        return this._cpdAvailabilityEstimateLocalService.updateCPDAvailabilityEstimateByCProductId(0L, cProductId, commerceAvailabilityEstimate2.getCommerceAvailabilityEstimateId(), serviceContext);
    }
}

