/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.frontend.internal.search;

import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.liferay.commerce.account.model.CommerceAccount;
import com.liferay.commerce.account.util.CommerceAccountHelper;
import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.context.CommerceContextFactory;
import com.liferay.commerce.frontend.internal.account.CommerceAccountResource;
import com.liferay.commerce.frontend.internal.account.model.Account;
import com.liferay.commerce.frontend.internal.account.model.AccountList;
import com.liferay.commerce.frontend.internal.account.model.Order;
import com.liferay.commerce.frontend.internal.account.model.OrderList;
import com.liferay.commerce.frontend.internal.order.CommerceOrderResource;
import com.liferay.commerce.frontend.internal.search.model.SearchItemModel;
import com.liferay.commerce.frontend.internal.search.util.CommerceSearchUtil;
import com.liferay.commerce.order.CommerceOrderHttpHelper;
import com.liferay.commerce.product.catalog.CPCatalogEntry;
import com.liferay.commerce.product.catalog.CPQuery;
import com.liferay.commerce.product.data.source.CPDataSourceResult;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.product.util.CPDefinitionHelper;
import com.liferay.commerce.service.CommerceOrderService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, service={CommerceSearchResource.class})
public class CommerceSearchResource {
    private static final ObjectMapper _OBJECT_MAPPER = new ObjectMapper(){
        {
            this.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
            this.disable(SerializationFeature.INDENT_OUTPUT);
        }
    };
    private static final Log _log = LogFactoryUtil.getLog(CommerceSearchResource.class);
    @Reference
    private CommerceAccountHelper _commerceAccountHelper;
    @Reference
    private CommerceAccountResource _commerceAccountResource;
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private CommerceContextFactory _commerceContextFactory;
    @Reference
    private CommerceOrderHttpHelper _commerceOrderHttpHelper;
    @Reference
    private CommerceOrderResource _commerceOrderResource;
    @Reference
    private CommerceOrderService _commerceOrderService;
    @Reference
    private CommerceSearchUtil _commerceSearchUtil;
    @Reference
    private CPDefinitionHelper _cpDefinitionHelper;
    @Reference
    private Http _http;
    @Reference
    private LayoutLocalService _layoutLocalService;

    @GET
    @Path(value="/search/{plid}")
    @Produces(value={"application/json"})
    public Response get(@PathParam(value="plid") long plid, @QueryParam(value="q") String queryString, @Context ThemeDisplay themeDisplay, @Context HttpServletRequest httpServletRequest) {
        try {
            String url;
            Layout layout = this._layoutLocalService.getLayout(plid);
            themeDisplay.setScopeGroupId(layout.getGroupId());
            themeDisplay.setLayout(layout);
            themeDisplay.setLayoutSet(layout.getLayoutSet());
            CommerceAccount commerceAccount = this._commerceAccountHelper.getCurrentCommerceAccount(this._commerceChannelLocalService.getCommerceChannelGroupIdBySiteGroupId(themeDisplay.getScopeGroupId()), httpServletRequest);
            ArrayList<SearchItemModel> searchItemModels = new ArrayList<SearchItemModel>();
            searchItemModels.addAll(this.searchProducts(themeDisplay.getCompanyId(), layout.getGroupId(), queryString, themeDisplay));
            if (themeDisplay.isSignedIn()) {
                searchItemModels.addAll(this.searchAccounts(queryString, themeDisplay));
                searchItemModels.addAll(this.searchOrders(queryString, themeDisplay, commerceAccount));
            }
            if (Validator.isNotNull((String)(url = this._commerceSearchUtil.getSearchFriendlyURL(themeDisplay)))) {
                url = this._http.addParameter(url, "q", queryString);
                SearchItemModel searchItemModel = new SearchItemModel("category", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"all-content"));
                searchItemModel.setUrl(url);
                searchItemModels.add(searchItemModel);
            }
            String json = _OBJECT_MAPPER.writeValueAsString(searchItemModels);
            return Response.ok((Object)json, (String)"application/json").build();
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
        }
    }

    protected List<SearchItemModel> searchAccounts(String queryString, ThemeDisplay themeDisplay) throws PortalException {
        ArrayList<SearchItemModel> searchItemModels = new ArrayList<SearchItemModel>();
        CommerceContext commerceContext = this._commerceContextFactory.create(themeDisplay.getCompanyId(), this._commerceChannelLocalService.getCommerceChannelGroupIdBySiteGroupId(themeDisplay.getScopeGroupId()), themeDisplay.getUserId(), 0L, 0L);
        AccountList accountList = this._commerceAccountResource.getAccountList(themeDisplay.getUserId(), 0L, commerceContext.getCommerceSiteType(), queryString, 1, 5, themeDisplay.getPathImage());
        if (accountList.getCount() > 0) {
            searchItemModels.add(new SearchItemModel("label", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"accounts")));
        }
        for (Account account : accountList.getAccounts()) {
            SearchItemModel searchItemModel = new SearchItemModel("item", account.getName());
            searchItemModel.setImage(account.getThumbnail());
            searchItemModel.setUrl(this._getAccountManagementPortletEditURL(GetterUtil.getLong((String)account.getAccountId()), themeDisplay));
            searchItemModels.add(searchItemModel);
        }
        String url = this._commerceSearchUtil.getAccountManagementFriendlyURL(themeDisplay);
        if (Validator.isNotNull((String)url)) {
            url = this._http.addParameter(url, "q", queryString);
            SearchItemModel searchItemModel = new SearchItemModel("category", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"accounts"));
            searchItemModel.setUrl(url);
            searchItemModels.add(searchItemModel);
        }
        return searchItemModels;
    }

    protected List<SearchItemModel> searchOrders(String queryString, ThemeDisplay themeDisplay, CommerceAccount commerceAccount) throws PortalException {
        ArrayList<SearchItemModel> searchItemModels = new ArrayList<SearchItemModel>();
        OrderList orderList = this._commerceOrderResource.getOrderList(themeDisplay.getScopeGroupId(), queryString, 1, 5, themeDisplay.getRequest(), commerceAccount);
        if (orderList.getCount() > 0) {
            searchItemModels.add(new SearchItemModel("label", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"orders")));
        }
        for (Order order : orderList.getOrders()) {
            SearchItemModel searchItemModel = new SearchItemModel("item", HtmlUtil.escape((String)String.valueOf(order.getId())));
            searchItemModel.setIcon("document");
            searchItemModel.setSubtitle(order.getAccountName());
            searchItemModel.setUrl(String.valueOf(this._commerceOrderHttpHelper.getCommerceCartPortletURL(themeDisplay.getScopeGroupId(), themeDisplay.getRequest(), this._commerceOrderService.getCommerceOrder(order.getId()))));
            searchItemModels.add(searchItemModel);
        }
        String url = this._commerceSearchUtil.getOrdersFriendlyURL(themeDisplay);
        if (Validator.isNotNull((String)url)) {
            url = this._http.addParameter(url, "q", queryString);
            SearchItemModel searchItemModel = new SearchItemModel("category", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"orders"));
            searchItemModel.setUrl(url);
            searchItemModels.add(searchItemModel);
        }
        return searchItemModels;
    }

    protected List<SearchItemModel> searchProducts(long companyId, long groupId, String queryString, ThemeDisplay themeDisplay) throws PortalException {
        ArrayList<SearchItemModel> searchItemModels = new ArrayList<SearchItemModel>();
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)themeDisplay.getLocale(), this.getClass());
        SearchContext searchContext = new SearchContext();
        HashMap attributes = HashMapBuilder.put((Object)"status", (Object)0).build();
        CommerceChannel commerceChannel = this._commerceChannelLocalService.fetchCommerceChannelBySiteGroupId(themeDisplay.getScopeGroupId());
        if (commerceChannel != null) {
            attributes.put("commerceChannelGroupId", commerceChannel.getGroupId());
        }
        CommerceAccount commerceAccount = this._commerceAccountHelper.getCurrentCommerceAccount(commerceChannel.getGroupId(), themeDisplay.getRequest());
        long[] commerceAccountGroupIds = null;
        if (commerceAccount != null) {
            commerceAccountGroupIds = this._commerceAccountHelper.getCommerceAccountGroupIds(commerceAccount.getCommerceAccountId());
        }
        searchContext.setAttribute("commerceAccountGroupIds", commerceAccountGroupIds);
        searchContext.setAttributes((Map)attributes);
        searchContext.setCompanyId(companyId);
        searchContext.setKeywords(queryString);
        CPQuery cpQuery = new CPQuery();
        cpQuery.setOrderByCol1("title");
        cpQuery.setOrderByCol2("modifiedDate");
        cpQuery.setOrderByType1("ASC");
        cpQuery.setOrderByType2("DESC");
        CPDataSourceResult cpDataSourceResult = this._cpDefinitionHelper.search(groupId, searchContext, cpQuery, 0, 5);
        if (cpDataSourceResult.getLength() > 0) {
            searchItemModels.add(new SearchItemModel("label", LanguageUtil.get((ResourceBundle)resourceBundle, (String)"catalog")));
        }
        for (CPCatalogEntry cpCatalogEntry : cpDataSourceResult.getCPCatalogEntries()) {
            searchItemModels.add(this._getSearchItemModel(cpCatalogEntry, themeDisplay));
        }
        String url = this._commerceSearchUtil.getCatalogFriendlyURL(themeDisplay);
        if (Validator.isNotNull((String)url)) {
            url = this._http.addParameter(url, "q", queryString);
            SearchItemModel searchItemModel = new SearchItemModel("category", LanguageUtil.get((ResourceBundle)resourceBundle, (String)"catalog"));
            searchItemModel.setUrl(url);
            searchItemModels.add(searchItemModel);
        }
        return searchItemModels;
    }

    private String _getAccountManagementPortletEditURL(long accountId, ThemeDisplay themeDisplay) throws PortalException {
        PortletURL editURL = PortletProviderUtil.getPortletURL((HttpServletRequest)themeDisplay.getRequest(), (String)CommerceAccount.class.getName(), (PortletProvider.Action)PortletProvider.Action.VIEW);
        if (editURL == null) {
            return "";
        }
        editURL.setParameter("commerceAccountId", String.valueOf(accountId));
        return editURL.toString();
    }

    private SearchItemModel _getSearchItemModel(CPCatalogEntry cpCatalogEntry, ThemeDisplay themeDisplay) throws PortalException {
        SearchItemModel searchItemModel = new SearchItemModel("item", HtmlUtil.escape((String)cpCatalogEntry.getName()));
        String subtitle = cpCatalogEntry.getShortDescription();
        if (Validator.isNull((String)subtitle)) {
            subtitle = HtmlUtil.extractText((String)cpCatalogEntry.getDescription());
        }
        searchItemModel.setSubtitle(subtitle);
        searchItemModel.setImage(cpCatalogEntry.getDefaultImageFileUrl());
        String url = this._cpDefinitionHelper.getFriendlyURL(cpCatalogEntry.getCPDefinitionId(), themeDisplay);
        searchItemModel.setUrl(url);
        return searchItemModel;
    }
}

