/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.frontend.internal.address;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.liferay.commerce.context.CommerceContextFactory;
import com.liferay.commerce.frontend.internal.address.model.CountryModel;
import com.liferay.commerce.frontend.internal.address.model.RegionModel;
import com.liferay.commerce.model.CommerceAddress;
import com.liferay.commerce.model.CommerceCountry;
import com.liferay.commerce.model.CommerceRegion;
import com.liferay.commerce.service.CommerceAddressService;
import com.liferay.commerce.service.CommerceCountryService;
import com.liferay.commerce.service.CommerceRegionService;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, service={AddressResource.class})
public class AddressResource {
    private static final ObjectMapper _OBJECT_MAPPER = new ObjectMapper(){
        {
            this.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
            this.enable(SerializationFeature.INDENT_OUTPUT);
        }
    };
    private static final Log _log = LogFactoryUtil.getLog(AddressResource.class);
    @Reference
    private CommerceAddressService _commerceAddressService;
    @Reference
    private CommerceContextFactory _commerceContextFactory;
    @Reference
    private CommerceCountryService _commerceCountryService;
    @Reference
    private CommerceRegionService _commerceRegionService;

    @GET
    @Path(value="/address/{id}")
    @Produces(value={"application/json"})
    public Response getCommerceAddress(@PathParam(value="id") long commerceAddressId) {
        try {
            CommerceAddress commerceAddress = this._commerceAddressService.fetchCommerceAddress(commerceAddressId);
            if (commerceAddress != null) {
                String json = _OBJECT_MAPPER.writeValueAsString((Object)JSONFactoryUtil.looseSerialize((Object)commerceAddress));
                return Response.ok((Object)json, (String)"application/json").build();
            }
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
        }
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
    }

    @GET
    @Path(value="/address/regions/{countryId}")
    @Produces(value={"application/json"})
    public Response getCommerceRegions(@PathParam(value="countryId") long commerceCountryId, @Context ThemeDisplay themeDisplay) {
        ArrayList<RegionModel> regionModels = new ArrayList<RegionModel>();
        List commerceRegions = this._commerceRegionService.getCommerceRegions(commerceCountryId, true);
        for (CommerceRegion commerceRegion : commerceRegions) {
            regionModels.add(new RegionModel(commerceRegion.getCommerceRegionId(), commerceRegion.getName()));
        }
        try {
            String json = _OBJECT_MAPPER.writeValueAsString(regionModels);
            return Response.ok((Object)json, (String)"application/json").build();
        }
        catch (JsonProcessingException jsonProcessingException) {
            _log.error((Object)jsonProcessingException, (Throwable)jsonProcessingException);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @Deprecated
    @GET
    @Path(value="/address/countries")
    @Produces(value={"application/json"})
    public Response getShippingCommerceCountries(@QueryParam(value="companyId") long companyId, @Context ThemeDisplay themeDisplay) {
        return this._getCommerceCountries(this._commerceCountryService.getCommerceCountries(companyId, true), themeDisplay.getLanguageId());
    }

    @GET
    @Path(value="/address/countries")
    @Produces(value={"application/json"})
    public Response getShippingCommerceCountries(@Context ThemeDisplay themeDisplay) {
        List commerceCountries = this._commerceCountryService.getCommerceCountries(themeDisplay.getCompanyId(), true);
        return this._getCommerceCountries(commerceCountries, themeDisplay.getLanguageId());
    }

    @GET
    @Path(value="/address/countries-by-channel-id")
    @Produces(value={"application/json"})
    public Response getShippingCommerceCountriesByChannelId(@QueryParam(value="channelId") long channelId, @Context ThemeDisplay themeDisplay) {
        List commerceCountries = this._commerceCountryService.getShippingCommerceCountriesByChannelId(channelId, -1, -1);
        return this._getCommerceCountries(commerceCountries, themeDisplay.getLanguageId());
    }

    private Response _getCommerceCountries(List<CommerceCountry> commerceCountries, String languageId) {
        ArrayList<CountryModel> countryModels = new ArrayList<CountryModel>();
        for (CommerceCountry commerceCountry : commerceCountries) {
            countryModels.add(new CountryModel(commerceCountry.getCommerceCountryId(), commerceCountry.getName(languageId), commerceCountry.isBillingAllowed(), commerceCountry.isShippingAllowed()));
        }
        try {
            String json = _OBJECT_MAPPER.writeValueAsString(countryModels);
            return Response.ok((Object)json, (String)"application/json").build();
        }
        catch (JsonProcessingException jsonProcessingException) {
            _log.error((Object)jsonProcessingException, (Throwable)jsonProcessingException);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }
}

