/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.workflow.apio.internal.architect.router;

import com.liferay.apio.architect.pagination.PageItems;
import com.liferay.apio.architect.pagination.Pagination;
import com.liferay.apio.architect.router.ReusableNestedCollectionRouter;
import com.liferay.apio.architect.routes.NestedCollectionRoutes;
import com.liferay.portal.apio.user.CurrentUser;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.workflow.WorkflowException;
import com.liferay.portal.kernel.workflow.WorkflowTask;
import com.liferay.portal.kernel.workflow.WorkflowTaskManager;
import com.liferay.workflow.apio.architect.identifier.ReusableWorkflowTaskIdentifier;
import com.liferay.workflow.apio.architect.identifier.WorkflowTaskIdentifier;
import java.util.ArrayList;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ReusableNestedCollectionRouter.class})
public class WorkflowTasksReusableNestedCollectionRouter
implements ReusableNestedCollectionRouter<WorkflowTask, Long, WorkflowTaskIdentifier, ReusableWorkflowTaskIdentifier> {
    @Reference
    protected WorkflowTaskManager workflowTaskManager;

    public NestedCollectionRoutes<WorkflowTask, Long, ReusableWorkflowTaskIdentifier> collectionRoutes(NestedCollectionRoutes.Builder<WorkflowTask, Long, ReusableWorkflowTaskIdentifier> builder) {
        return builder.addGetter(this::_getPageItems, Company.class, CurrentUser.class).build();
    }

    private PageItems<WorkflowTask> _getPageItems(Pagination pagination, ReusableWorkflowTaskIdentifier reusableWorkflowTaskIdentifier, Company company, CurrentUser currentUser) throws WorkflowException {
        List workflowTasks = new ArrayList();
        int count = 0;
        ReusableWorkflowTaskIdentifier.WorkflowTaskType workflowTaskType = reusableWorkflowTaskIdentifier.getWorkflowTaskType();
        if (workflowTaskType.equals((Object)ReusableWorkflowTaskIdentifier.WorkflowTaskType.TO_ME)) {
            workflowTasks = this.workflowTaskManager.getWorkflowTasksByUser(company.getCompanyId(), currentUser.getUserId(), null, pagination.getStartPosition(), pagination.getEndPosition(), null);
            count = this.workflowTaskManager.getWorkflowTaskCountByUser(company.getCompanyId(), currentUser.getUserId(), null);
        } else if (workflowTaskType.equals((Object)ReusableWorkflowTaskIdentifier.WorkflowTaskType.TO_MY_ROLES)) {
            workflowTasks = this.workflowTaskManager.getWorkflowTasksByUserRoles(company.getCompanyId(), currentUser.getUserId(), null, pagination.getStartPosition(), pagination.getEndPosition(), null);
            count = this.workflowTaskManager.getWorkflowTaskCountByUserRoles(company.getCompanyId(), currentUser.getUserId(), null);
        }
        return new PageItems(workflowTasks, count);
    }
}

