/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.workflow.apio.internal.architect.resource;

import com.liferay.apio.architect.pagination.PageItems;
import com.liferay.apio.architect.pagination.Pagination;
import com.liferay.apio.architect.representor.Representor;
import com.liferay.apio.architect.resource.NestedCollectionResource;
import com.liferay.apio.architect.routes.ItemRoutes;
import com.liferay.apio.architect.routes.NestedCollectionRoutes;
import com.liferay.person.apio.architect.identifier.PersonIdentifier;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.workflow.WorkflowException;
import com.liferay.portal.kernel.workflow.WorkflowLog;
import com.liferay.portal.kernel.workflow.WorkflowLogManager;
import com.liferay.portal.workflow.kaleo.KaleoWorkflowModelConverter;
import com.liferay.portal.workflow.kaleo.definition.util.KaleoLogUtil;
import com.liferay.portal.workflow.kaleo.model.KaleoLog;
import com.liferay.portal.workflow.kaleo.service.KaleoLogLocalService;
import com.liferay.workflow.apio.architect.identifier.WorkflowLogIdentifier;
import com.liferay.workflow.apio.architect.identifier.WorkflowTaskIdentifier;
import java.util.Collection;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class WorkflowLogNestedCollectionResource
implements NestedCollectionResource<WorkflowLog, Long, WorkflowLogIdentifier, Long, WorkflowTaskIdentifier> {
    @Reference
    private KaleoLogLocalService _kaleoLogLocalService;
    @Reference
    private KaleoWorkflowModelConverter _kaleoWorkflowModelConverter;
    @Reference
    private WorkflowLogManager _workflowLogManager;

    public NestedCollectionRoutes<WorkflowLog, Long, Long> collectionRoutes(NestedCollectionRoutes.Builder<WorkflowLog, Long, Long> builder) {
        return builder.addGetter(this::_getPageItems, Company.class).build();
    }

    public String getName() {
        return "workflow-logs";
    }

    public ItemRoutes<WorkflowLog, Long> itemRoutes(ItemRoutes.Builder<WorkflowLog, Long> builder) {
        return builder.addGetter(this::_getWorkflowLog).build();
    }

    public Representor<WorkflowLog> representor(Representor.Builder<WorkflowLog, Long> builder) {
        return (Representor)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)builder.types("WorkflowLog", new String[0]).identifier(WorkflowLog::getWorkflowLogId).addDate("dateCreated", WorkflowLog::getCreateDate)).addLinkedModel("auditPerson", PersonIdentifier.class, WorkflowLog::getAuditUserId)).addLinkedModel("person", PersonIdentifier.class, WorkflowLog::getUserId)).addLinkedModel("previousPerson", PersonIdentifier.class, WorkflowLog::getPreviousUserId)).addLinkedModel("task", WorkflowTaskIdentifier.class, WorkflowLog::getWorkflowTaskId)).addString("type", this::_getWorkflowLogType)).addString("commentLog", WorkflowLog::getComment)).addString("previousState", WorkflowLog::getPreviousState)).addString("state", WorkflowLog::getState)).build();
    }

    private PageItems<WorkflowLog> _getPageItems(Pagination pagination, Long workflowTaskId, Company company) throws WorkflowException {
        List workflowLogs = this._workflowLogManager.getWorkflowLogsByWorkflowTask(company.getCompanyId(), workflowTaskId.longValue(), null, pagination.getStartPosition(), pagination.getEndPosition(), null);
        int count = this._workflowLogManager.getWorkflowLogCountByWorkflowTask(company.getCompanyId(), workflowTaskId.longValue(), null);
        return new PageItems((Collection)workflowLogs, count);
    }

    private WorkflowLog _getWorkflowLog(Long workflowLogId) throws PortalException {
        KaleoLog kaleoLog = this._kaleoLogLocalService.getKaleoLog(workflowLogId.longValue());
        return this._kaleoWorkflowModelConverter.toWorkflowLog(kaleoLog);
    }

    private String _getWorkflowLogType(WorkflowLog workflowLog) {
        return KaleoLogUtil.convert((int)workflowLog.getType());
    }
}

