/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.workflow.apio.architect.identifier;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public interface ReusableWorkflowTaskIdentifier {
    public static ReusableWorkflowTaskIdentifier create(WorkflowTaskType workflowTaskType) {
        return () -> workflowTaskType;
    }

    public WorkflowTaskType getWorkflowTaskType();

    public static enum WorkflowTaskType {
        TO_ME("assigned-to-me"),
        TO_MY_ROLES("assigned-to-my-roles");

        private static final Map<String, WorkflowTaskType> _workflowTaskTypes;
        private final String _name;

        public static WorkflowTaskType get(String name) {
            return _workflowTaskTypes.get(name);
        }

        public String getName() {
            return this._name;
        }

        private WorkflowTaskType(String name) {
            this._name = name;
        }

        static {
            _workflowTaskTypes = Collections.unmodifiableMap(new HashMap<String, WorkflowTaskType>(){
                {
                    for (WorkflowTaskType workflowTaskType : WorkflowTaskType.values()) {
                        this.put(workflowTaskType.getName(), workflowTaskType);
                    }
                }
            });
        }
    }
}

